#include "../h/em1.h"
{ (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
  Explicit permission is hereby granted to universities to use or duplicate
  this program for educational or research purposes.  All other use or dup-
  lication  by universities,  and all use or duplication by other organiza-
  tions is expressly prohibited unless written permission has been obtained
  from the Vrije Universiteit. Requests for such permissions may be sent to

       Dr. Andrew S. Tanenbaum
       Wiskundig Seminarium
       Vrije Universiteit
       Postbox 7161
       1007 MC Amsterdam
       The Netherlands

  Organizations wishing to modify part of this software for subsequent sale
  must  explicitly  apply  for  permission.  The exact arrangements will be
  worked out on a case by case basis, but at a minimum will require the or-
  ganization to include the following notice in all software and documenta-
  tion based on our work:

	    This product is based on the Pascal  system  developed  by
       Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
       of the Vrije Universiteit, Amsterdam, The Netherlands.
}

{$r- : range check off}

program encode(import,tables,export,output);
#ifdef STANDARD
label 9999;
#endif

const
	MAGIC= 172;		{indicates compact EM1 code}

type
	byte	= 0..255;
	mnem	= packed array[1..4] of char;
	message	= packed array[1..20] of char;
var
	lino	: integer;
	mn	: array[byte] of mnem;
	hash	: array[byte] of byte;
	CAL	: byte;
	import	: text;
	tables	: text;
	export	: file of byte;

procedure fatal(m:message);
begin
  writeln(output,'encode: input line ',lino:1,': ',m);
#ifdef STANDARD
  goto 9999;
#endif
#ifndef STANDARD
  halt(-1);
#endif
end;

procedure enter(b:byte;m:mnem);
var	h	: byte;
begin h:=(ord(m[1])*ord(m[2]) + ord(m[3])) mod 256;
    while hash[h] <> 0 do
	h:=(h+1) mod 256;
    hash[h]:=b; mn[b]:=m
end;

procedure init;
var	i,n	: integer;
	m	: mnem;
	b	: byte;
begin
    reset(import);
    reset(tables);
    rewrite(export);
    lino:=0;
    n:=1;
    for b:=0 to 255 do
	begin mn[b]:='????'; hash[b]:=0 end;
    while not eoln(tables) do readln(tables);
    readln(tables);
    while not eoln(tables) do readln(tables);
    readln(tables);
    while not eoln(tables) do
	begin m[4]:=' ';
	    for i:=1 to 3 do
		read(tables,m[i]);
	    if m='cal ' then CAL:=n;
	    enter(n,m);
	    readln(tables); n:=n+1;
	end;
    { pseudo's }
    enter(ps_bss,'bss ');	enter(ps_con,'con ');
    enter(ps_end,'end ');	enter(ps_eof,'eof ');
    enter(ps_mes,'mes ');	enter(ps_exc,'exc ');
    enter(ps_exd,'exd ');	enter(ps_hol,'hol ');
    enter(ps_let,'let ');	enter(ps_pro,'pro ');
    enter(ps_rom,'rom ');	enter(ps_ima,'ima ');
    enter(ps_imc,'imc ');	enter(ps_fwp,'fwp ');
    enter(ps_fwa,'fwa ');	enter(ps_fwc,'fwc ');
end;

procedure skipsp;
begin
    while ((import^=' ') or (import^=chr(9))) and not eoln(import) do
	get(import);
    if import^ = ';' then
	while not eoln(import) do get(import);
end;


function getmnem:byte;
var	h	: integer;
	m	: mnem;
	b	: byte;
begin
    m[4]:=' ';
    for h:=1 to 3 do
	read(import,m[h]);
    h:=(ord(m[1])*ord(m[2]) + ord(m[3])) mod 256;
    repeat
	b:=hash[h];
	h:=(h+1) mod 256;
    until (b=0) or (mn[b]=m);
    if b=0 then
	fatal('bad mnemonic found  ');
    getmnem:=b
end;

procedure putb(b:byte);
begin write(export,b) end;

procedure putw(i:integer);
var	truc:	packed record
		    case boolean of
		    false	: (j:integer);
		    true	: (b1,b2:byte)
		end;
begin truc.j:=i; putb(truc.b1); putb(truc.b2) end;

procedure putilb(i:integer);
begin
    if i<256 then
	begin putb(sp_ilb1); putb(i) end
    else
      begin putb(sp_ilb2); putw(i) end
end;

procedure putdlb(i:integer);
begin
    if i<256 then
	begin putb(sp_dlb1); putb(i) end
    else
	begin putb(sp_dlb2); putw(i) end
end;

procedure putcst(i:integer);
begin
    if i>=0 then
	if i<256 then
	    begin putb(sp_cst1); putb(i) end
	else
	    begin putb(sp_cst2); putw(i) end
    else
	if i>-256 then
	    begin putb(sp_cstm); putb(-i) end
	else
	    begin putb(sp_cst2); putw(i) end
end;

procedure copyname(b:byte);
const	SLEN = 20;
var	s	: packed array[1..SLEN] of char;
	i,j,k	: integer;
	short	: boolean;
begin i:=0;
    if not (import^ in ['A'..'Z','a'..'z','_','.']) then
	fatal('bad identifier found');
    short:=import^='.';
    repeat
	i:=i+1; read(import,s[i]);
	short:=short and not (import^ in ['A'..'Z','a'..'z','_','.']);
    until not (import^ in ['A'..'Z','a'..'z','0'..'9','_','.']);
    if short and (b=sp_dnam) then
	begin k:=0;
	    for j:=2 to i do
		k:=k*10 + ord(s[j]) - ord('0');
	    putdlb(k)
	end
    else
	begin
	    putb(b); putb(i);
	    for j:=1 to i do
		putb(ord(s[j]));
	end;
    skipsp;
end;

procedure copystring;
const SLEN = 512;
var	s	: packed array[1..SLEN] of byte;
	c	: char;
	i,j	: integer;
	b	: byte;
begin get(import); i:=0;
    while import^<>'"' do
	begin read(import,c); i:=i+1; b:=ord(c);
	    if c='\' then
		if (import^='"') or (import^='\') then
		    begin read(import,c); b:=ord(c) end
		else
		    begin b:=0;
			for j:=1 to 3 do
			    begin
				if (import^ < '0') or (import^ > '7') then
				    fatal('3 digits required   ');
				read(import,c); b:=8*b + ord(c) - ord('0')
			    end;
		    end;
	    s[i]:=b;
	    if eoln(import) then
		fatal('end quotes missing  ');
	end;
    get(import); putb(sp_scon);
    if i<255 then putb(i) else
	begin putb(255); putw(i) end;
    for j:=1 to i do
	putb(s[j]);
end;

procedure constant;
const	RLEN = 72;
var	i,j,k	: integer;
	rad	: integer;
	ca	: packed array[1..RLEN] of char;
	s	: boolean;
	rc	: boolean;
	c	: char;
begin i:=0; rc:=false;
    repeat read(import,c);
	if c<>'+' then begin i:=i+1; ca[i]:=c end;
	rc:=rc or (c in ['.','e','E']);
    until not (import^ in ['0'..'9','+','-','.','e','E','l','L']);
    if rc then
	begin putb(sp_rcon); putb(i);
	    for j:=1 to i do putb(ord(ca[j]))
	end
    else if (c='l') or (c='L') then
	begin i:=i-1; putb(sp_lcon); putb(i);
	    for j:=1 to i do putb(ord(ca[j]))
	end
    else
	begin j:=1; s:=false; k:=0; rad:=10;
	    if ca[1]='-' then
		begin j:=j+1; s:=true end
	    else if (ca[1]='0') then
		rad:=8;
	    while j<=i do
		begin k:=k*rad + ord(ca[j]) - ord('0'); j:=j+1 end;
	    if s then k:= -k;
	    if (k >= sp_fcst0) and (k < sp_fcst0 + sp_ncst0) then
		putb(k)
	    else
		putcst(k);
	end
end;

procedure operand(opb:byte);
var	b	: byte;
	i	: integer;
begin skipsp;
    if import^ in ['0'..'9','+','-'] then
	constant
    else if import^ = '"' then
	copystring
    else if import^ = '*' then
	begin get(import); read(import,i); putilb(i) end
    else
	begin b:=sp_dnam;
	    if import^ = '$' then begin get(import); b:=sp_pnam end;
	    if opb=CAL then b:=sp_pnam;
	    copyname(b);
	end;
    skipsp;
end;

procedure pseudo(b:byte);
var	i	: integer;
begin
    case b of
	ps_end:
	    ;
	ps_eof:
#ifdef STANDARD
	    goto 9999;
#else
	    halt(0);
#endif
	ps_ima,ps_imc,ps_exd,ps_hol,ps_bss,ps_fwa,ps_fwc:
	    operand(b);
	ps_fwp:
	    begin skipsp; copyname(sp_pnam) end;
	ps_exc,ps_let:
	    begin operand(b);
		if import^ <> ',' then
		    fatal('comma required      ');
		get(import);
		operand(b)
	    end;
	ps_pro:
	    begin skipsp; copyname(sp_pnam);
		for i:=1 to 2 do
		    begin
			if import^ <> ',' then
			    fatal('comma required      ');
			get(import); operand(b)
		    end
	    end;
	ps_rom,ps_con,ps_mes:
	    begin operand(b);
		while import^ = ',' do
		    begin get(import); operand(b) end;
		putb(sp_cend)
	    end;
    end
end;

procedure encode;
var	b	: byte;
	i	: integer;
begin
    if import^ in ['0'..'9'] then
	begin read(import,i);
	    if i<sp_nilb0 then
		putb(i+sp_filb0)
	    else
		putilb(i)
	end
    else
	begin
	    if import^ in ['A'..'Z','a'..'z','_','.'] then
		copyname(sp_dnam);
	    skipsp;
	    if not eoln(import) then
		begin
		    b:=getmnem; putb(b);
		    if b<=sp_lmnem then
			begin skipsp;
			   if not eoln(import) then operand(b)
			end
		    else
			pseudo(b);
		end
	end;
    skipsp
end;

{ main }
begin init; putw(MAGIC);
    while not eof(import) do
	begin lino:=lino+1;
	    if not eoln(import) then encode;
	    if not eoln(import) then
		fatal('end of line expected');
	    readln(import)
	end;
#ifdef STANDARD
9999: ;
#endif
end.
