#include "path.h"	/* this is ../h/path.h or ../h/bootpath.h */
#include "../h/local.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

/*
 * select one of the interpreters
 */

#ifdef NC6
#define C7	1
#endif

#ifdef C7
#define	EQ		=
#endif
#ifndef C7
#define	EQ		/* nothing */
#endif

#ifdef CEM
extern	void	printf(());
#endif
#ifndef CEM
#define	void		int
extern	void	printf();
#endif

char	tflg;
char	eflg;
char	pflg;
char	fflg;
char	cflg;
char	rflg;

char	tchg;
char	echg;
char	pchg;
char	fchg;
char	cchg;

char	*newarg[3];
char	*progname;
char	*intname;
char	*shint;
char	*intdir		EQ INT_DIR;
int	fildes;

struct	header {
	int	magic;
	int	flags;
	int	unresolved;
	int	version;
	int	unused[4];
}	header;

int	sysflag;
int	testflag;

#define	CSIZE		1000
char	cspace[CSIZE];
char	*cptr		EQ cspace;

/*
 * value returning routines
 */
char	*concat();
char	*stralloc();
int	length();

/*
 * used library routines
 */
extern	int	gtty();
extern	int	fork();
extern	int	wait();
extern	int	open();
extern	int	read();
extern	int	write();
extern	void	exit();
extern	void	sleep();
extern	void	execv();

main(argc,argv) char **argv; {
	register char *argp;
	register value;

	progname = argv[0];
#ifndef V7
	argv[argc] = 0;	/* for use in later execv */
#endif
	while (argc>1 && (argv[1][0] == '-' || argv[1][0] == '+')) {
		value = (argv[1][0] == '+');
		argp = (*++argv);
		argp++;
		argc--;
		while (*argp)
			switch(*argp++) {
			case 't':
				tchg = 1;
				tflg = value;
				break;
			case 'e':
				echg = 1;
				eflg = value;
				break;
			case 'p':
				pchg = 1;
				pflg = value;
				break;
			case 'f':
				fchg = 1;
				fflg = value;
				break;
			case 'c':
				cchg = 1;
				cflg = value;
				break;
			case 'r':
				rflg = value;
				break;
			case 'i':
				sysflag = 1;
				break;
			case 'X':
				testflag = 1;
				break;
			default:
				printf("unknown flag '%c'\n",argp[-1]);
		}
	}

	if (!sysflag) {
		if (argc == 1) {
			newarg[0] = argv[0];
			newarg[1] = "e.out";
			newarg[2] = 0;
			argv = newarg;
		}
		if ((fildes = open(argv[1],0)) < 0)
			fatal("can't open %s",argv[1]);
		if (read(fildes,&header,sizeof header)!= sizeof header)
			fatal("read error in %s",argv[1]);
		close(fildes);
		if (header.magic != (172 | 14<<8))
			fatal("file %s is no binary em1 program",argv[1]);
		if (header.unresolved) 
			fatal("%d unresolved references",header.unresolved);
		if (header.version != VERSION)
			fatal("Your object program is out of date. Please recompile",0);

		if (!tchg)
			tflg = ((header.flags&01)!=0);
		if (!echg)
			eflg = ((header.flags&040)!=0);
		if (!pchg)
			pflg = ((header.flags&02)!=0);
		if (!fchg)
			fflg = ((header.flags&04)!=0);
		if (!cchg)
			cflg = ((header.flags&010)!=0);
		rflg = ((header.flags&020)!=0);
		/*
		 * we have a valid codefile now, all flags are set
		 * this is the time to hunt for the right interpreter
		 */

	}
#ifdef HARDWARE_FP
	rflg = 1;
#endif
	if (eflg)
		tflg = 1;
	argp = intname = concat(intdir,"/em1------");
	while (*argp!='-')
		argp++;
	*argp++ =  ( eflg ? 'e' : '-' );
	*argp++ =  ( rflg ? 'r' : '-' );
	*argp++ =  ( cflg ? 'c' : '-' );
	*argp++ =  ( fflg ? 'f' : '-' );
	*argp++ =  ( pflg ? 'p' : '-' );
	*argp++ =  ( tflg ? 't' : '-' );

	/*
	 * If the interpreter we asked for is available this will be
	 * the end of our work.
	 * check in system and current directory
	 */

	if (!(testflag || sysflag))
		execv(intname,argv);

	/*
	 * not in system directory
	 */

	while (*--argp!= '/')
		;
	shint = argp+1;
	if (!sysflag)
		execv(shint,argv);

	/*
	 * interpreter is not found, so make it
	 */

	makeint();

	if (sysflag)
		exit(0);
	execv(shint,argv);

	fatal("Interpreter not available",0);
}

makeint() {
	char *vec[20];
	register char **v;
	int ttbuf[3];

	if (!sysflag && gtty(1,ttbuf) == 0) {
		printf("Special interpreter has to be constructed\n");
		printf("Sorry for the delay\n");
	}
	v = vec;
	*v++ = "as";
	*v++ = concat(intdir,"/local.s");
	*v = concat(intdir,"/x-");
	last(*v++,tflg,'t');
	*v = concat(intdir,"/x-");
	last(*v++,pflg,'p');
	*v = concat(intdir,"/x-");
	last(*v++,fflg,'f');
	*v = concat(intdir,"/x-");
	last(*v++,cflg,'c');
	*v = concat(intdir,"/x-");
	last(*v++,rflg,'r');
	*v = concat(intdir,"/x-");
	last(*v++,eflg,'e');
	*v++ = concat(intdir,"/em.s");
	*v = 0;
	call(AS_PATH,vec);

	/* link with libraries */
	v = vec;
	*v++ = "ld";
	*v++ = testflag ? "-n" : "-s";
	*v++ = "-n";
	*v++ = "a.out";
#ifdef V7
	*v++ = "-lm";
#endif
	*v++ = "-lc";
#ifndef V7
	*v++ = "-la";
#endif
	*v++ = 0;
	call(LD_PATH,vec);

	/* rename (across file system bounds ?) */
	v = vec;
	*v++ = "mv";
	*v++ = "a.out";
	if (sysflag)
		*v++ = concat(concat(intdir,"/"), shint);
	else
		*v++ = shint;
	*v++ = 0;
	call(MV_PATH,vec);
}

last(file,flg,ch) char *file; {
	register char *p;

	p = file;
	while (*p++)
		;
	p[-3] = ch;
	p[-2] = flg ? '+' : '-';
}


char *concat(str1,str2) char *str1,*str2;  {
	register char *result,*p1,*p2;

	p1 = result = stralloc(length(str1) + length(str2) + 1);
	p2 = str1;
	while (*p1++ = *p2++);
	p1--;
	p2 = str2;
	while(*p1++ = *p2++);
	return(result);
}

int length(str) char *str; {
	register char *p;

	p = str;
	while (*p++);
	p--;
	return(p-str);
}


char *stralloc(n) int n;  {
	register char *result;

	result = cptr;
	cptr =+ n;
	if (cptr > &cspace[CSIZE])
		fatal("out of character space",0);
	return(result);
}

call(path,vector) char *path; char **vector; {
	register wid,pid;
	int status;

	while ((pid = fork()) < 0)
		sleep(5);
	if (pid == 0) {
		execv(path,vector);
		fatal("%s: Not found",path);
	} else {
		while ((wid = wait(&status)) != pid)
			if (wid == -1)
				fatal("child disappeared",0);
	}
	if (status & 0177400)
		fatal("bad exit status from %s",path);
}
/* VARARGS1 */
fatal(s,arg) char *s; {

	printf("%s: ",progname);
	printf(s,arg);
	printf("\n");
	exit(-1);
}

putchar(c) {
	if (write(2,&c,1) != 1)
		;
}
