#include "mfile2"
/*
	bulk of the code generation for a 6809 C compiler




		Adrian Freed

*/


#define TRUE 1
#define FALSE 0

#define CANT 0
#define CAN 1
#define DGONE 2

#define INXREG 0
#define INDREG 1

#define HIGHBYTE 0
#define LOWBYTE  1

#define SE   03	/* for amode to allow side effects */
#define POST 01	/* for post processing only */
#define PREE 02	/* for pree processing only */

char *tprint();
struct code
{
	/* long */
	int (*lfunc)();
	char *lv;
	/* int */
	int (*func)();
	char *val;
};
NODE *block();
NODE *unpost();
NODE *unpree();
NODE *dup();
char *nstr();
char * amode();
char *splamode();
char reg();
extern oper();
extern abitop();
extern acomop();
extern artop();
extern ashop();
extern asop();
extern asubop();
extern comop();
extern comp();
extern incop();
extern labitop();
extern lacomop();
extern lartop();
extern lashop();
extern lasubop();
extern lbitop();
extern lcomop();
extern lcomp();
extern lincop();
extern lneg();
extern lrtop();
extern lshop();
extern lsubop();
extern neg();
extern rtop();
extern sabitop();
extern shop();
extern stasg();
extern starg();
extern subop();

#define ADD	"add"
#define SUB	"sub"
#define MULT	"mul"
#define AMOD	"mod"
#define NEG	"neg"
#define COMP	"com"
#define LAND	"and"
#define LOR	"or"
#define EOR	"eor"
#define ADIV	"div"
#define LLS	"ls"
#define LRS	"rs"
#define SB	"sb"
#define RBT	"rb"
#define TB	"tb"

struct code codetab[] =
{
	oper,	  0,	oper,	 0,	/*			0	*/
	oper,	  0,	oper,	 0,	/*	ERROR		1	*/
	oper,	  0,	oper,	 0,	/*	NAME		2	*/
	oper,	  0,	oper,	 0,	/*	STRING		3	*/
	oper,	  0,	oper,	 0,	/*	ICON		4	*/
	oper,	  0,	oper,	 0,	/*	FCON		5	*/
	lcomop,  ADD,	comop,	 ADD,	/*	PLUS		6	*/
	lacomop, ADD,	acomop, ADD,	/*	ASG		1+	*/
	lsubop,  SUB,	subop,	 SUB,	/*	MINUS		8	*/
	lasubop, SUB,	asubop, SUB,	/*	ASG		1+	*/
	lneg,    NEG,	neg,	 NEG,	/*	UNARY		2+	*/
	lrtop,   MULT,	rtop,	 MULT,	/*	MUL		11	*/
	lartop,  MULT,	artop,	 MULT,	/*	ASG		1+	*/
	oper,	  0,	oper,	 0,	/*	UNARY		2+	*/
	lbitop,  LAND,	comop,	 LAND,	/*	AND		14	*/
	labitop, LAND,	acomop, LAND,	/*	ASG		1+	*/
	oper,	  0,	oper,	 0,	/*	UNARY		2+	*/
	lbitop,  LOR,	comop,	 LOR,	/*	OR		17	*/
	labitop, LOR,	acomop, LOR,	/*	ASG		1+	*/
	lbitop,  EOR,	comop,	 EOR,	/*	ER		19	*/
	labitop, EOR,	acomop, EOR,	/*	ASG		1+	*/
	oper,	  0,	oper,	 0,	/*	QUEST		21	*/
	oper,	  0,	oper,	 0,	/*	COLON		22	*/
	oper,	  0,	oper,	 0,	/*	ANDAND		23	*/
	oper,	  0,	oper,	 0,	/*	OROR		24	*/
	oper,	  0,	oper,	 0,	/*	ASOP		25	*/
	oper,	  0,	oper,	 0,	/*	RELOP		26	*/
	oper,	  0,	oper,	 0,	/*	EQUOP		27	*/
	oper,	  0,	oper,	 0,	/*	DIVOP		28	*/
	oper,	  0,	oper,	 0,	/*	SHIFTOP		29	*/
	oper,	  0,	oper,	 0,	/*	INCOP		30	*/
	oper,	  0,	oper,	 0,	/*	UNOP		31	*/
	oper,	  0,	oper,	 0,	/*	STROP		32	*/
	oper,	  0,	oper,	 0,	/*	TYPE		33	*/
	oper,	  0,	oper,	 0,	/*	CLASS		34	*/
	oper,	  0,	oper,	 0,	/*	STRUCT		35	*/
	oper,	  0,	oper,	 0,	/*	RETURN		36	*/
	oper,	  0,	oper,	 0,	/*	GOTO		37	*/
	oper,	  0,	oper,	 0,	/*	IF		38	*/
	oper,	  0,	oper,	 0,	/*	ELSE		39	*/
	oper,	  0,	oper,	 0,	/*	SWITCH		40	*/
	oper,	  0,	oper,	 0,	/*	BREAK		41	*/
	oper,	  0,	oper,	 0,	/*	CONTINUE	42	*/
	oper,	  0,	oper,	 0,	/*	WHILE		43	*/
	oper,	  0,	oper,	 0,	/*	DO		44	*/
	oper,	  0,	oper,	 0,	/*	FOR		45	*/
	oper,	  0,	oper,	 0,	/*	DEFAULT		46	*/
	oper,	  0,	oper,	 0,	/*	CASE		47	*/
	oper,	  0,	oper,	 0,	/*	SIZEOF		48	*/
	oper,	  0,	oper,	 0,	/*	ENUM		49	*/
	oper,	  0,	oper,	 0,	/*	LP		50	*/
	oper,	  0,	oper,	 0,	/*	RP		51	*/
	oper,	  0,	oper,	 0,	/*	LC		52	*/
	oper,	  0,	oper,	 0,	/*	RC		53	*/
	oper,	  0,	oper,	 0,	/*	LB		54	*/
	oper,	  0,	oper,	 0,	/*	RB		55	*/
	oper,	  0,	oper,	 0,	/*	CM		56	*/
	oper,	  0,	oper,	 0,	/*	SM		57	*/
	asop, "=",	asop, 	"=",	/*	ASSIGN		58	*/
	oper,	  0,	oper,	 0,	/*	COMOP		59	*/
	lrtop,   ADIV,	rtop,	 ADIV,	/*	DIV		60	*/
	lartop,  ADIV,	artop,	 ADIV,	/*	ASG		1+	*/
	lrtop,   AMOD,	rtop,	 AMOD,	/*	MOD		62	*/
	lartop,  AMOD,	artop,  AMOD,	/*	ASG		1+	*/
	lshop,   LLS,	shop,	 LLS,	/*	LS		64	*/
	lashop,  LLS,	ashop,	 LLS,	/*	ASG		1+	*/
	lshop,   LRS,	shop,	 LRS,	/*	RS		66	*/
	lashop,  LRS,	ashop,	 LRS,	/*	ASG		1+	*/
	oper,	  0,	oper,	 0,	/*	DOT		68	*/
	oper,	  0,	oper,	 0,	/*	STREF		69	*/
	oper,	  0,	oper,	 0,	/*	CALL		70	*/
	oper,	  0,	oper,	 0,	/*			71	*/
	oper,	  0,	oper,	 0,	/*	XXX		72	*/
	oper,	  0,	oper,	 0,	/*	FORTCALL	73	*/
	oper,	  0,	oper,	 0,	/*	XXX		74	*/
	oper,	  0,	oper,	 0,	/*	XXX		75	*/
	oper,	  0,	oper,	 0,	/*	NOT		76	*/
	lcomp,	  0,	comp,	 COMP,	/*	COMPL		77	*/
	lincop,  ADD,	incop,	 ADD,	/*	INCR		78	*/
	lincop,  SUB,	incop,	 SUB,	/*	DECR		79	*/
	oper,	  0,	oper,	 0,	/*	EQ		80	*/
	oper,	  0,	oper,	 0,	/*	NE		81	*/
	oper,	  0,	oper,	 0,	/*	LE		82	*/
	oper,	  0,	oper,	 0,	/*	LT		83	*/
	oper,	  0,	oper,	 0,	/*	GE		84	*/
	oper,	  0,	oper,	 0,	/*	GT		85	*/
	oper,	  0,	oper,	 0,	/*	ULE		86	*/
	oper,	  0,	oper,	 0,	/*	ULT		87	*/
	oper,	  0,	oper,	 0,	/*	UGE		88	*/
	oper,	  0,	oper,	 0,	/*	UGT		89	*/
	lrtop,   SB,	rtop,	 SB,	/*	SETBIT		90	*/
	lrtop,   TB,	rtop,	 TB,	/*	TESTBIT		91	*/
	lrtop,   RBT,	rtop,	 RBT,	/*	RESETBIT	92	*/
	oper,	  0,	oper,	 0,	/*	ARS		93	*/
	oper,	  0,	oper,	 0,	/*	REG		94	*/
	oper,	  0,	oper,	 0,	/*	REG		95	*/
	oper,	  0,	oper,	 0,	/*	CCODES		96	*/
	oper,	  0,	oper,	 0,	/*	FREE		97	*/
	stasg,	  0,	stasg,	 0,	/*	STASG		98	*/
	starg,	  0,	starg,	 0,	/*	STARG		99	*/
	oper,	  0,	oper,	 0,	/*	STCALL		100	*/
	oper,	  0,	oper,	 0,	/*	XXX		101	*/
	oper,	  0,	oper,	 0,	/*	XXX		102	*/
	oper,	  0,	oper,	 0,	/*	FLD		103	*/
	oper,	  0,	oper,	 0,	/*	SCONV		104	*/
	oper,	  0,	oper,	 0,	/*	PCONV		105	*/
	oper,	  0,	oper,	 0,	/*	PMCONV		106	*/
	oper,	  0,	oper,	 0,	/*	PVCONV		107	*/
	oper,	  0,	oper,	 0,	/*	FORCE		108	*/
	oper,	  0,	oper,	 0,	/*	CBRANCH		109	*/
	oper,	  0,	oper,	 0,	/*	INIT		110	*/
	oper,	  0,	oper,	 0,	/*	CAST		111	*/
	oper,	  0,	oper,	 0	/*	RET		112	*/
};
char srch = 'a';	/* short register destination */
extern edebug;
codegen(p)
NODE *p;
{
	register o;
	register ty;
	unsigned tl;
	register x;
	register NODE *q;
	char buf[20];

#ifndef BUG2
	if(edebug) fwalk(p, eprint, 0);
#endif
	o = p->in.op;
	ty = optype(o);
	if(logop(o) || o==QUEST || o==CBRANCH || o==GOTO)
		return(genlog(p));
	if(ty==LTYPE)
	{
		/* leaf node */
		switch(o)
		{
	    case ICON:
			{
				char buf[20];

			printf("\tld%c\t%s\n", reg(p->in.type), nstr(p,buf));
			}
		break;
	    case FCON:
		break;
	    case NAME:
			/* global variable */
			{
				char buf[20];

				printf("\tld%c\t%s\n", reg(p->in.type), nstr(p,buf));
			}
		break;
	    case REG:
			if(p->tn.rval==1)
				printf("\ttfr\ty,d\n");
			else
				printf("\ttfr\tu,d\n");
			break;
	    default:
			/*	help	*/
			cerror("unknown leaf node");
		}
	}
	else
	if(ty==UTYPE)
	{
		unsigned t;

		/* unary op */
		switch(o)
		{
	    case FORCE:
		/* force code to be generated */
		ind(p->in.left);
		break;
	    case INIT:
		{
			char buf[20];

			printf("\tf%cb\t%s\n", bast(p->in.type)==INT? 'c':'d',
					nstr(p->in.left,buf)+1);
		}
		break;
	    case UNARY CALL:
	    case UNARY STCALL:
		/* call with no arguments */
		if(p->in.left->in.op == ICON)
		{
			char buf[20];
			printf("\tjbs\t%s\n", nstr((p->in.left), buf)+1);
		}
		else
		{
			ind(p->in.left);
			printf("\ttfr	d,x\n");
			printf("\tjsr\t,x\n");
		}
		break;
	    case UNARY FORTCALL:
		break;
	    case UNARY MUL:
		if(p->in.left->in.op == STASG)
		{
			ind(p->in.left);
			break;
		}
		if(addr(p->in.left) != CANT)
		{
			printf("\tldx\t%s\n", amode(p->in.left, buf, SE));
			printf("\tld%c\t,x\n", bast(p->in.type)==INT? 'b':'d');
		}
		else if(((q = p->in.left)->in.op == PLUS)
			&& (q->in.right->in.op == ICON))
		{
			char buf[80];
			inx(q->in.left);
			q->in.right->in.op = NAME;	/* this forces nstr to do the right thing */
			printf("\tld%c\t%s,x\n", reg(p->in.type), nstr(q->in.right, buf));
		}
		else
		{
			ind(p->in.left);
			if(bast(p->in.type)==INT)
			{
				printf("\ttfr	d,x\n");
				printf("\tldb\t,x\n");
			}
			else
			{
				printf("\ttfr	d,x\n");
				printf("\tldd\t,x\n");
			}
		}
		break;
	    case UNARY AND:
		agen(p->in.left, INDREG);
		break;
	    case SCONV:
	   /* scaler conversion ops */
		ind(p->in.left);
		if(p->in.left->in.type == LONG || p->in.left->in.type == ULONG)
		{
		}
		else
		{
		   /* int->long */
			if(ISUNSIGNED(p->in.type) || ISUNSIGNED(p->in.left->in.type))
				printf("\tclra\n");
			else
				printf("\tsex\n");
		}
		break;
	    case PCONV:
	    /* structures */
		ind(p->in.left);
		break;
	    case STARG:
		genaop(p);
		break;
	    /* field */
	    case FLD:
		break;
	    case UNARY MINUS:
	    case COMPL:
		genaop(p);
		break;
	    default:
		/* help */
		cerror("unknown unary op");
		}
	}
	else
	{
		/* binary op */
		switch(o)
		{
		/* call */
	    case CALL:
	    case STCALL:
		/* the arguments */
		if(p->in.right->in.op!=CM)
			stck(p->in.right);
		else
			codegen(p->in.right);

		if(p->in.left->in.op==ICON)
		{
			char buf[20];
			printf("\tjbs\t%s\n", nstr((p->in.left), buf)+1);
		}
		else
		{
			ind(p->in.left);
			printf("\ttfr	d,x\n");
			printf("\tjsr\t,x\n");
		}
		/* take the arguments off */

		printf("\tleas\t%d,s\n", argsize(p->in.right));
		break;
	    case FORTCALL:
		uerror("Fortran not supported");
		break;
	    case CM:
		/* argument separater */
		if(p->in.right->in.op!=CM)
			stck(p->in.right);
		else
			codegen(p->in.right);
		if(p->in.left->in.op!=CM)
			stck(p->in.left);
		else
			codegen(p->in.left);
		break;
	    case COMOP:
			/* the comma operator */
			ind(p->in.left);
			ind(p->in.right);
		break;
	    default:
		genaop(p);
		}
	}
}
/* generate code for arithmetic and bit ops */
genaop(p)
NODE *p;
{
	register o;

	o = p->in.op;
	if(bast(p->in.type)==LONG)
		return (*(codetab[o].lfunc))(p, codetab[o].lv, o);
	else
		return (*(codetab[o].func))(p, codetab[o].val, o);
}
bast(t)
unsigned t;
{

	if(ISPTR(t))
		t = LONG;
	else
	if(ISUNSIGNED(t=BTYPE(t)))
		t = DEUNSIGN(t);
	if(t==CHAR)
		return INT;
	return(t);
}

char reg(t)
TWORD t;
{
	if(bast(t)==INT)
		return 'b';
	else
		return 'd';
}
oper(p, s)
NODE *p;
char *s;
{
#ifndef BUG2
	fwalk(p, eprint, 0);
#endif
	cerror("funny node in codegen");
}
int wflag = 1;
extern FILE *outfile;
argsize( p ) register NODE *p;
{
	register t;
	t = 0;
	if( p->in.op == CM ){
		t = argsize( p->in.left );
		p = p->in.right;
		}
	if( p->in.type == DOUBLE || p->in.type == FLOAT ){
		SETOFF( t, 2 );
		return( t+8 );
		}
	else if( bast(p->in.type) == LONG ){
		SETOFF( t, 1);
		return( t+2 );
		}
	else if( p->in.op == STARG ){
		SETOFF( t, p->stn.stalign );  /* alignment */
		return( t + p->stn.stsize );  /* size */
		}
	else {
		SETOFF( t, 1 );
		return( t+1 );
		}
	}
pushd()
{
	printf("\tpshs\td\n");
}
pushb()
{
	printf("\tpshs\tb\n");
}
pushx()
{
	printf("\tpshs\tx\n");
}
acomop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		char buf[20];
		NODE *pp, *q;


		if(((o == ASG PLUS) || (o == ASG MINUS))
		  && (bast(p->in.type)== INT) && (p->in.right->in.op == ICON)
		   && (p->in.right->tn.lval == 1))
		{
			printf("\t%s\t%s\n", o==ASG PLUS? "inc":"dec", amode(p->in.left, buf, top(p)?SE:PREE));
			if(!top(p))
				printf("\tldb\t%s\n", amode(p->in.left, buf, POST));
		}
		else
		{
			comonop(p, s, o, comop);
		}
	}
	else if(!usex(p->in.right))
	{
		char buf[20];

		agen(p->in.left, INXREG);
		ind(p->in.right);
		printf("\t%sb\t,x\n", s);
		printf("\tstb\t,x\n");
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\t%sb\t,s+\n", s);
		assend(p,s,o);
	}
}

comonop(p, s, o, f)
NODE *p;
char *s;
unsigned o;
int (*f)();
{
	register NODE *q, *pp;
	char buf[20];

	q = unpost(p->in.left);
	pp = p->in.left;
	p->in.left = q;
	(*f)(p, s, o);
	tfree(q);
	printf("\tst%c\t%s\n", reg(pp->in.type), amode(pp, buf, POST));
	p->in.left = pp;
}
artop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{

		comonop(p, s, o, rtop);
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\tjsr\tc%s\n", s);
		assend(p,s,o);
	}
}

ashop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		comonop(p, s, o, shop);
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\tjsr\tc%s\n", s);
		assend(p,s,o);
	}
}

asubop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		comonop(p, s, o, subop);
	}
	else
	{
		assbeg(p,s,o);
		printf("\tldb\t,x\n");
		printf("\tsubb\t,s+\n");
		assend(p,s,o);
	}
}

lbitop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	register NODE *q;
	register char *cp;
	char buf1[20];
	char buf2[20];
	char swap = 0;
	if(spladdr(p->in.right)== CAN)
	{
	}
	else if(spladdr(p->in.left)== CAN)
	{
		q = p->in.left;
		p->in.left = p->in.right;
		p->in.right = q;
		swap = 1;
	}
	else
	{
		ind(p->in.left);
		pushd();
		ind(p->in.right);
		printf("\t%sa\t,s+\n\t%sb\t,s+\n", s, s);
		return;
	}
	ind(p->in.left);
	printf("\t%sa\t%s\n\t%sb\t%s\n", s, splamode(p->in.right, buf1, HIGHBYTE), s, splamode(p->in.right, buf2, LOWBYTE));
	if(swap)
	{
		q = p->in.left;
		p->in.left = p->in.right;
		p->in.right = q;
	}
}

#define L p->in.left
#define R p->in.right
#define AOP(x) printf("\t%sb\t%s\n", s, amode((x),buf, SE))
#define DOOP printf("\t%sb\t,s+\n", s)
comop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	char buf[20];

	switch((addr(p->in.left)<<2) | addr(p->in.right))
	{
	case (CANT<<2)|CANT:
	case (DGONE<<2)|DGONE:
	case (CANT<<2)|DGONE:
		stck(L); ind(R); DOOP;
		break;
	case (CAN<<2)|CANT:
	case (CAN<<2)|DGONE:
		ind(R); AOP(L);
		break;
	case (CANT<<2)|CAN:
	case (DGONE<<2)|CAN:
	case (CAN<<2)|CAN:
		ind(L); AOP(R);
		break;
	case (DGONE<<2)|CANT:
		stck(R); ind(L); DOOP;
		break;
	}
}
#undef L
#undef R
#undef AOP
#undef DOOP

comp(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	printf("\tcomb\n");
}

lincop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(p->in.left->in.op == REG)
	{
		char buf[20];

		if(!top(p))
			printf("\ttfr\ty,d\n");
		if(p->in.op == INCR)
			printf("\tleay\t%s,y\n", nstr(p->in.right, buf)+1);
		else
			printf("\tleay\t-%s,y\n", nstr(p->in.right, buf)+1);
	}
	else if(addr(p->in.left) == CAN)
	{
		char buff[20];
		printf("\tldd\t%s\n", amode(p->in.left, buff, PREE));
		printf("\t%sd\t#%d\n", s, p->in.right->tn.lval);
		printf("\tstd\t%s\n", amode(p->in.left, buff, POST));
		if(!top(p))
			printf("\t%sd\t#%d\n", s, -(p->in.right->tn.lval));
	}
	else
	{
		agen(p->in.left, INXREG);
		printf("\tldd\t,x\n");
		printf("\t%sd\t#%d\n", s, p->in.right->tn.lval);
		printf("\tstd\t,x\n");
		if(!top(p))
			printf("\t%sd\t#%d\n", s, -(p->in.right->tn.lval));
	}
}

labitop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		comonop(p, s, o, lbitop);
	}
	else if(!usex(p->in.right))
	{
		agen(p->in.left, INXREG);
		ind(p->in.right);
		printf("\t%sa\t,x\n\t%sb\t1,x\n", s, s);
		printf("\tstd\t,x\n");
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\t%sa\t,s+\n\t%sb\t,s+\n", s, s);
		assend(p,s,o);
	}
}

lacomop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(p->in.left->in.op==REG)
	{
		char buf[20];

		if(p->in.op != (ASG PLUS))
			cerror("cant do operation on register");
		if(p->in.right->in.op==ICON)
			printf("\tleay\t%s,y\n", nstr(p->in.right, buf)+1);
		else
		{
			ind(p->in.right);
			printf("\tleay\td,y\n");
		}
		if(!top(p))
			printf("\ttfr\ty,d\n");
	}
	else
	{
		if(addr(p->in.left)==CAN)
		{
			comonop(p, s, o, lcomop);
		}
		else if(!usex(p->in.right))
		{
			agen(p->in.left, INXREG);
			ind(p->in.right);
			printf("\taddd\t,x\n");
			printf("\tstd\t,x\n");
		}
		else
		{
				assbeg(p,s,o);
				ind(p->in.right);
				printf("\t%sd\t,s++\n", s);
				assend(p,s,o);
		}
	}
}

lartop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{

		comonop(p, s, o, lrtop);
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\tjsr\tcl%s\n", s);
		assend(p,s,o);
	}
}

lashop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		comonop(p, s, o, lshop);
	}
	else
	{
		assbeg(p,s,o);
		ind(p->in.right);
		printf("\tjsr\tcl%s\n", s);
		assend(p,s,o);
	}
}

asop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	char buf[20];
	register NODE *q;

	if(addr(p->in.left)== CAN || p->in.left->in.op == REG)
	{
		if(p->in.left->in.op!=REG)
		{
			if(top(p) && ((q = p->in.right)->in.op == ICON) &&
				(*q->in.name == 0 && q->tn.lval == 0))
			{
				if(bast(p->in.type)== INT)
				{
					printf("\tclr\t%s\n", amode(p->in.left, buf, SE));
					return;
				}
				else if(spladdr(p->in.left) == CAN)
				{
					printf("\tclr\t%s\n", splamode(p->in.left, buf, HIGHBYTE));
					printf("\tclr\t%s\n", splamode(p->in.left, buf, LOWBYTE));
					return;
				}
			}
			ind(p->in.right);
			printf("\tst%c\t%s\n", reg(p->in.left->in.type), amode(p->in.left,buf, SE));
		}
		else
			if(addr(p->in.right))
			{
				printf("\tldy\t%s\n", amode(p->in.right,buf, SE));
				if(!top(p))
					printf("\ttfr\ty,d\n");
			}
			else
			{
				q = block(UNARY MUL, p->in.right, NIL, 0, 0, 0);
				if(addr(q) == CAN)
				{
					printf("\tleay\t%s\n", amode(q, buf, SE));
					if(!top(p))
						printf("\ttfr\ty,d");
				}
				else
				{
					ind(p->in.right);
					printf("\ttfr\td,y\n");
				}
				tfree1(q);
			}
	}
	else if(!usex(p->in.right))
	{
		agen(p->in.left, INXREG);
		if(top(p) && ((q = p->in.right)->in.op == ICON) &&
			(*q->in.name == 0 && q->tn.lval == 0))
		{
			if(bast(p->in.type) == INT)
				printf("\tclr\t,x\n");
			else {
				printf("\tclr\t,x+\n");
				printf("\tclr\t,x\n");
			}
		}
		else
		{
			ind(p->in.right);
			printf("\tst%c\t,x\n", reg(p->in.left->in.type));
		}
	}
	else
	{
		agen(p->in.left, INDREG);
		pushd();
		ind(p->in.right);
		printf("\tst%c\t[,s++]\n", reg(p->in.left->in.type));
	}
}

lasubop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left)==CAN)
	{
		comonop(p, s, o, lsubop);
	}
	else
	{
		assbeg(p,s,o);
		printf("\tldd\t,x\n");
		printf("\tsubd\t,s++\n");
		assend(p,s,o);
	}
}
#define R p->in.right
#define L p->in.left
#define AOP(x) printf("\t%sd\t%s\n", s, amode((x),buf, SE))
#define DOOP printf("\t%sd\t,s++\n", s)

lcomop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	char buf[20];

	switch((addr(p->in.left)<<2) | addr(p->in.right))
	{
	case (CANT<<2)|CANT:
	case (DGONE<<2)|DGONE:
	case (CANT<<2)|DGONE:
		stck(L); ind(R); DOOP;
		break;
	case (CAN<<2)|CANT:
	case (CAN<<2)|DGONE:
		ind(R); AOP(L);
		break;
	case (CANT<<2)|CAN:
	case (DGONE<<2)|CAN:
	case (CAN<<2)|CAN:
		ind(L); AOP(R);
		break;
	case (DGONE<<2)|CANT:
		stck(R); ind(L); DOOP;
		break;
	}
}

#undef L 
#undef R
lcomp(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	printf("\tcoma\n\tcomb\n");
}

incop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.left) == CAN)
	{
		if(p->in.right->tn.lval == 1)
		{
			char buff[20];
			if(!top(p))
				printf("\tldb\t%s\n", amode(p->in.left, buff, PREE));
			printf("\t%s\t%s\n", o==INCR ? "inc" : "dec", amode(p->in.left, buff, top(p)? SE:POST));
		}
		else
		{
			char buff[20];
			printf("\tldb\t%s\n", amode(p->in.left, buff, PREE));
			printf("\t%sb\t#%d\n", s, p->in.right->tn.lval);
			printf("\tstb\t%s\n", amode(p->in.left, buff, POST));
			if(!top(p))
				printf("\t%sb\t#%d\n", s, -(p->in.right->tn.lval));
		}
	}
	else
	{
		agen(p->in.left, INXREG);
		printf("\tldb\t,x\n");
		printf("\t%sb\t#%d\n", s, p->in.right->tn.lval);
		printf("\tstb\t,x\n");
		if(!top(p))
			printf("\t%sb\t#%d\n", s, -(p->in.right->tn.lval));
	}
}

lneg(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	printf("\tcoma\n\tcomb\n\taddd\t#1\n");
}

lrtop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	pushd();
	ind(p->in.right);
	if(ISUNSIGNED(p->in.type))
		printf("\tjsr\tclu%s\n", s);
	else
		printf("\tjsr\tcl%s\n", s);
}

lshop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(p->in.right->in.op == ICON)
	{
		register unsigned i;
		char b[20];

		for(i=0; i<20; ++i)
			b[i] = '\0';

		ind(p->in.left);
		if(p->in.op == LS || p->in.op == ASG LS)
			sprintf(b,"aslb\n\trola");
		else
		if(ISUNSIGNED(p->in.type))
			sprintf(b,"lsra\n\trorb");
		else

			sprintf(b,"asra\n\trorb");
		for(i=1;i<=p->in.right->tn.lval;++i)
			printf("\t%s\n", b);
	}
	else
		lrtop(p,s,o);
}

lsubop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.right) == CAN)
	{
		char buf[20];
		ind(p->in.left);
		printf("\tsubd\t%s\n", amode(p->in.right, buf, SE));
	}
	else
	{
		ind(p->in.right);
		pushd();
		ind(p->in.left);
		printf("\tsubd\t,s++\n");
	}
}

neg(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	printf("\tnegb\n");
}

rtop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	ind(p->in.left);
	pushb();
	ind(p->in.right);
	if(ISUNSIGNED(p->in.type))
		printf("\tlbsr\tcu%s\n",s);
	else
		printf("\tjsr\tc%s\n", s);
}


shdir(p)
NODE *p;
{
	if(p->in.op==RS)
		return('r');
	else
		return('l');
}
shop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(p->in.right->in.op == ICON)
	{
		register unsigned i;
		char b[20];

		ind(p->in.left);
		if(ISUNSIGNED(p->in.left->in.type) && (p->in.op == RS || p->in.op == ASG RS))
			sprintf(b,"ls%cb", shdir(p));
		else
			sprintf(b,"as%cb", shdir(p));
		for(i=1;i<=p->in.right->tn.lval;++i)
			printf("\t%s\n", b);
	}
	else
		rtop(p,s,o);
}

starg(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	printf("put str on stack\n");
}

stasg(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	int size;

	size = p->stn.stsize;
	agen(p->in.left, INDREG);
	printf("\tpshs\td\n");
	ind(p->in.right);
	printf("\tpshs\td\n");
	printf("\tldd\t#%d\n",size);
	printf("\tlbsr\tstasg\n");
	printf("\tldd\t,s\n");
	printf("\tleas\t4,s\n");
}

subop(p, s, o)
NODE *p;
char *s;
unsigned o;
{
	if(addr(p->in.right) == CAN)
	{
		char buff[20];
		ind(p->in.left);
		printf("\tsubb\t%s\n", amode(p->in.right, buff, SE));
	}
	else
	{
		ind(p->in.right);
		pushb();
		ind(p->in.left);
		printf("\tsubb\t,s+\n");
	}
}
assbeg(p,s,o)
NODE *p;
char *s;
unsigned o;
{
/*
		get address
		make a copy on the stack
		get the object addressed on the top of the stack
		free the top of the stack
*/
		agen(p->in.left, INXREG);
		pushx();
		if(o == ASG MINUS)
		{
			ind(p->in.right);
			if(usex(p->in.right))
				printf("\tldx\t,s\n");
			if(bast(p->in.type)== INT)
				pushb();
			else
				pushd();
			return;
		}
		if(bast(p->in.type)==LONG)
		{
			printf("\tldd\t,x\n");
			printf("\tpshs\td\n");
		}
		else
		{
			printf("\tldb\t,x\n");
			printf("\tpshs\tb\n");
		}
}
assend(p,s,o)
NODE *p;
char *s;
unsigned o;
{
/*
		store the top of stack at stacked address
		pop the stacked address
		leaving value on top of stack
*/
		if(bast(p->in.type)==INT)
			printf("\tstb\t[,s++]\n");
		else
			printf("\tstd\t[,s++]\n");

}
agen(p, flag)
NODE *p;
{
	if(p->in.op==NAME)
	{
			/* global */
		if(*(p->in.name))
			printf("\tld%c\t#%.8s+%d\n", flag==INXREG ? 'x' : 'd', p->in.name, p->tn.lval);
		else
			printf("\tld%c\t#%d\n", flag==INXREG ? 'x' : 'd', p->tn.lval);
		return;
	}
	else
	if(p->in.op==REG)
	{
		/* register */
		cerror("cant take address of register");
	}
	else
	{
		ind(p->in.left);
		if(flag == INXREG)
			printf("\ttfr\td,x\n");
	}
}

/*
 * Determine if an expression will require
 * the use of the x register for evaluation
 */
usex(p)
NODE *p;
{

	register unsigned o;

	more:
	switch(optype(o = p->in.op))
	{
	case LTYPE: return 0;
	case UTYPE:
		switch(o)
		{
		case UNARY CALL:
		case UNARY FORTCALL:
				return 1;
		case FORCE:
		case UNARY AND:
		case UNARY MINUS:
		case SCONV:
		case COMPL:
			p = p->in.left;
			goto more;
		case UNARY MUL:
				if(addr(p)== CAN)
					return 0;
				if(addr(p) == DGONE)
				{
					p = p->in.left;
					goto more;
				}
				return 1;

		case STARG:	return 1;

		default:	return 0;
		}

		default:
			switch(o)	/* binary nodes */
			{
			case CALL:
			case FORTCALL:	return 1;

			case ASG PLUS:
			case ASG AND:
			case ASG OR:
			case ASG ER:
					if(addr(p->in.left) != CAN)
						return 1;
					p = p->in.right;
					goto more;
			case MUL:
			case ASG MUL:
			case DIV:
			case ASG DIV:
			case MOD:
			case ASG MOD:
			case SETBIT:
			case TESTBIT:
			case RESETBIT:
			case STASG:
					return 1;
			case ASSIGN:
					if(addr(p->in.left) == CAN)
					{
						p = p->in.right;
						goto more;
					}
					return 1;
			case LS:
			case RS:
				if(p->in.right->in.op == ICON)
				{
					p = p->in.left;
					goto more;
				}
				return 1;
			case INCR:
			case DECR:
				if(addr(p->in.left) == CAN)
					return 0;
				else
					return 1;
			}
		}
	if(usex(p->in.left))
		return 1;
	p = p->in.right;
	goto more;
}

/*
	return the ability of the 6809 to compute the 
	expression using addressing modes.

	The possibilities are:

	CANT
	DGONE
	CAN

	DGONE is the case where a subexpression has
		to be evaluated in 'd' to use the addressing
		modes.
*/
addr(p)
NODE *p;
{
	unsigned i=0;


	while(p->in.op==UNARY MUL)
	{

		++i;
		p = p->in.left;
	}
	if(i<=1 && (p->in.op == NAME || p->in.op == ICON))
		return CAN;
	if(i == 1 && p->in.op == REG)
		return CAN;
	if(i>2||i==0)
		return CANT;
	if(p->in.op == PLUS)
	{
		if(p->in.left->in.op == REG)
			if(p->in.right->in.op == ICON)
				return CAN;
			else
				return DGONE;
		else
			return CANT;
	}
	else if(p->in.op == INCR)
	{
		if((p->in.left->in.op == REG) && (((i = p->in.right->tn.lval) == 1) || (i == 2)))
			return CAN;
		else 
			return CANT;
	}
	else if(p->in.op == ASG MINUS)
	{
		if((p->in.left->in.op == REG) && (((i = p->in.right->tn.lval) == 1) || (i == 2)))
			return CAN;
		else 
			return CANT;
	}
	return CANT;
}

/*
	Can we directly address word expressions
	and split them into two seperate bytes.
 */
spladdr(p)
NODE *p;
{
	register NODE *q;
	if((p->in.op == NAME) || (p->in.op == ICON))
		return CAN;
	if(p->in.op == UNARY MUL)
	{
		if(((q = p->in.left)->in.op == PLUS) &&
			(q->in.left->in.op == REG) &&
				(q->in.right->in.op == ICON))
					return CAN;
		if(q->in.op == REG)
			return CAN;
	}
	return CANT;
}

aamode(p)
NODE *p;
{
}
char *amode(p, buf, se)
char *buf;
unsigned se;
NODE *p;
{
	/* return a pointer to a string representing the operand */
	/* generate code for sub-expression if necessary */
	register char *s;
	register i=0;
	char b[20];


	while(p->in.op==UNARY MUL)
	{
		p = p->in.left;
		++i;
	}
	if(i==0)
		return nstr(p, buf);
	if(i==1)
	{
		if(p->in.op==NAME || p->in.op == ICON)
			sprintf(buf, "[%s]", nstr(p,b));
		else
		if(p->in.op == REG)
			sprintf(buf, ",%s", nstr(p,b));
		else
		if(p->in.op == PLUS)
		{
			if(p->in.right->in.op == ICON)
				if(*p->in.name || p->tn.lval)
					sprintf(buf, "%s,%s", nstr(p->in.right, b)+1, nstr(p->in.left, b));
				else
					sprintf(buf, ",%s", nstr(p->in.left, b));
			else
			{
				ind(p->in.right);
				sprintf(buf, "d,%s", nstr(p->in.left, b));
			}
		}
		else if(p->in.op == INCR)
		{
			if(se & POST)
			{
				if(p->in.right->tn.lval == 1)
					s = "+";
				else
					s = "++";
			}
			else
				s = "";
			sprintf(buf, ",%s%s", nstr(p->in.left, b), s);
		}
		else if(p->in.op == ASG MINUS)
		{
			if(se & PREE)
			{
				if(p->in.right->tn.lval == 1)
					s = "-";
				else
					s = "--";
			}
			else
				s = "";
			sprintf(buf, ",%s%s", s, nstr(p->in.left, b));
		}
		else
			cerror("funny tree in amode");
	}
	else if(i!=2)
		cerror("too much indirection in amode");
	else
	{
		if(p->in.op == PLUS)
		{
			if(p->in.right->in.op == ICON)
				if(*p->in.name || p->tn.lval)
					sprintf(buf, "[%s,%s]", nstr(p->in.right, b)+1, nstr(p->in.left, b));
				else
					sprintf(buf, "[,%s]", nstr(p->in.left, b));
			else
			{
				ind(p->in.right);
				sprintf(buf, "[d,%s]", nstr(p->in.left, b));
			}
		}
		else if(p->in.op == INCR)
		{
			if(se & POST)
				s = "++";
			else
				s = "";
			sprintf(buf, "[,%s%s]", nstr(p->in.left, b), s);
		}
		else if(p->in.op == ASG MINUS)
		{
			if(se & PREE)
				s = "--";
			else
				s = "";
			sprintf(buf, "[,%s%s]", s, nstr(p->in.left, b));
		}
		else
			cerror("funny tree in amode");
	}
	return buf;
}

char * splamode(p, buf, off)
NODE *p;
char *buf;
{

	register NODE *q;
	if(p->in.op == NAME)
	{
		if(*(p->in.name))
			sprintf(buf, "%.8s+%d", p->in.name, p->tn.lval+(short)off);
		else
			sprintf(buf, "%d", p->tn.lval+(short)off);
	}
	else if(p->in.op == ICON)
	{
		if(*(p->in.name))
			sprintf(buf, "#%.8s+%d%s", p->in.name, p->tn.lval,
				off == HIGHBYTE ? ">8":"");
		else
			sprintf(buf, "#%d%s", p->tn.lval,
				off == HIGHBYTE ? ">8":"");
	}
	else if(p->in.op == UNARY MUL)
	{
		if(((q = p->in.left)->in.op == PLUS) &&
		(q->in.left->in.op == REG) &&
		(q->in.right->in.op == ICON))
		{
			if(*(q->in.right->in.name))
			{
				char b[20];
				sprintf(buf, "%.8s+%d,%s", q->in.right->in.name,
					q->in.right->tn.lval+(short)off,
					nstr(q->in.left, b));
			}
			else
			{
				char b[20];
				sprintf(buf, "%d,%s", q->in.right->tn.lval+(short)off,
						nstr(q->in.left, b));
			}
		}
		else if(q->in.op == REG)
		{
			char b[20];
			if(off == HIGHBYTE)
				sprintf(buf, ",%s", nstr(q, b));
			else
				sprintf(buf, "1,%s", nstr(q, b));
		}
	}
	else
	cerror("funny node in splamode");
	return buf;
}

/*
	return a pointer to a string representing a name
*/
char *nstr(p,b)
char *b;
NODE *p;
{

	if(p->in.op==NAME)
	{
		if(*(p->in.name))
			sprintf(b, "%.8s+%d", p->in.name, p->tn.lval);
		else
			sprintf(b, "%d", p->tn.lval);
	}
	else if(p->in.op==ICON)
	{
		if(*(p->in.name))
			sprintf(b, "#%.8s+%d", p->in.name, p->tn.lval);
		else
			sprintf(b, "#%d", p->tn.lval);
	}
	else if(p->in.op==REG)
	{
		if(p->tn.rval==1)
			return "y";
		else
			return "u";
	}
	else
		cerror("unknown node in nstr");
	return(b);
}
stck(p)
NODE *p;
{
	int size;
	/* generate p on the stack */
	if(p->in.op != STARG)
	{
		ind(p);
		if(bast(p->in.type)==INT)
			pushb();
		else
			pushd();
	}
	else
	{
		size = p->stn.stsize;
		ind(p->in.left);
		printf("\ttfr\td,x\n");
		printf("\tldd\t#%d\n", size);
		printf("\tlbsr\tstarg\n");
	}
}

ind(p)
NODE *p;
{

	/* generate p in d register */
	if(addr(p) || p->in.op == REG)
	{
		char buf[20];

		if(p->in.op == REG)
			printf("\ttfr\t%s,d\n", nstr(p,buf));
		else
			printf("\tld%c\t%s\n", reg(p->in.type), amode(p, buf, SE));
	}
	else
		codegen(p);
}

inx(p)
NODE *p;
{

	/* generate p in x register */
	if((addr(p) && bast(p->in.type) == LONG) || p->in.op == REG)
	{
		char buf[20];

		if(p->in.op == REG)
			printf("\ttfr\t%s,x\n", nstr(p,buf));
		else
			printf("\tldx\t%s\n", amode(p, buf, SE));
	}
	else
	{
		codegen(p);
		printf("\ttfr\td,x\n");
	}
}

NODE *
dup(p)
register NODE *p;
{

	register NODE *q;
	register i;

	q = block(p->in.op, NIL, NIL, 0, 0, 0);

	switch(optype(p->in.op))
	{
	case LTYPE:	q->tn.lval = p->tn.lval;
			q->tn.rval = p->tn.rval;
			break;
	case BITYPE:	q->in.right = dup(p->in.right);
	case UTYPE:	q->in.left = dup(p->in.left);
			break;
	}
	q->in.type = p->in.type;
	q->in.rall = p->in.rall;
	q->in.su   = p->in.su;

	for(i = 0;i < NCHNAM; i++)
		q->in.name[i] = p->in.name[i];
	return q;
}

/* remove post processing from a tree
 * ie like p++, p--
 * the tree must be abbressable
 * a copy of the original is returned
 */

NODE *
unpost(p)
register NODE *p;
{

	register NODE *q, *head;
	NODE *r;

	if(!addr(p)) cerror("funny node in unpost");

	q = head = dup(p);

	if(q->in.left->in.op == UNARY MUL)
		q = q->in.left;

	if(q->in.left->in.op == INCR)
	{
		r = q ->in.left->in.left;
		tfree1(q->in.left->in.right);
		tfree1(q->in.left);
		q->in.left = r;
	}
	return head;
}

/* remove pree processing from a tree
 * ie thing like ++p, --p
 * the tree must be abbressable
 * a copy of the original is returned
 */
NODE *
unpree(p)
register NODE *p;
{

	register NODE *q, *head;
	NODE *r;

	if(!addr(p)) cerror("funny node in unpree");

	q = head = dup(p);

	if(q->in.left->in.op == UNARY MUL)
		q = q->in.left;

	if(q->in.left->in.op == ASG MINUS)
	{
		r = q ->in.left->in.left;
		tfree1(q->in.left->in.right);
		tfree1(q->in.left);
		q->in.left = r;
	}
	return head;
}
