; The use and distribution of the information
; contained herein may be restricted.
;
title	ec,<economizer>,24,19-jul-74,tph/mhb/jdm

	.csect	ec
	.globl	econom,d.core


	.globl	edsave,edrest,basfrc,edrsr1,preset
	.globl	zotall,edfipk,getbuf

plusta=	2		;low lim variable part of str or push-pop
minsta=	4		;high lim variable part of hdr or tag
pludyn=	6		;current pointer str or push-pop
mindyn=	10		;current pointer hdr or tag
plulim=	12		;high lim str or push-pop
minlim=	14		;low lim hdr or tag
; ask exec for some memory

d.core:	.core			;now ask for the memory
	tstb	iosts		;any error (set cc's)
	rts	pc		;and exit
;call:
;	r1	r1 stack
;	jsr	r5,econom
;	xxxnom			;xxx is area in which space is needed
;rtrn:
;	r0	spda
;	r1	r1 stack
;	r2-r5	preserved

xxxnom=	20		;tmp storage rel sp

econom:	mov	(r5)+,-(sp)	;pick up xxxnom
	jsr	r5,edsave	;save r2-r5
	mov	spta,r5		;access to high seg
	mov	#177776,r4	;usefun mask
	mov	pludyn(r5),-(sp);get push-pop limit
	bic	r4,(sp)		;is it odd?
	add	(sp),pludyn(r5)	;save parity/make limit even
	mov	spda,r0		;access to data
	mov	pludyn(r0),-(sp);make its limit even also
	bic	r4,(sp)		;and save the low bit
	add	(sp),pludyn(r0)	;to restore from stack
	mov	r1,-(sp)	;r1 also must be even
	bic	r4,(sp)		;odd bit
	sub	(sp),r1		;now r1 must be even
	cmp	#strnom,xxxnom(sp);are we out of string space?
	bne	4$		;no
	jsr	pc,recycl	;recycle old strings
	mov	plulim(r0),r2	;see how much free string space now
	sub	pludyn(r0),r2	;is it as much or more than called for?
	cmp	r2,strnom(r0)	;user put his desire here
	bhis	3$		;there is enough now
	br	1$		;not enough, try reallocating

4$:	jsr	pc,gcfit	;sum up nominals, available space
	bmi	1$		;nominals > 32k, yech
	cmp	r2,sumnom(r0)	;will reallocation suffice?
	bhis	2$		;yes, there is enough to go around
	jsr	pc,recycl	;no, so recycle strings first
1$:	jsr	pc,adjust	;punish or reward nominals
2$:	jsr	pc,realoc	;redistribute the available space
3$:	add	(sp)+,r1	;restore r1 low bit
	sub	(sp)+,pludyn(r0);restore low bit to string limit
	mov	spta,r5		;and also to push-pop limit
	sub	(sp)+,pludyn(r5);(realoc moved words)
	jsr	r5,edrest
	tst	(sp)+		;remove xxxnom
	mov	spda,r0		;restore base
	rts	r5
	.sbttl	recycl - recover used strings

;call:
;	r0	spda
;	r1	r1 stack
;	jsr	pc,recycl
;rtrn:
;	r0	spda
;	r1	r1 stack
;	r2-r5	scratch

bit:	.byte	200,100,40,20,10,4,2,1

bittab=	basbuf
bittln=	256.		;words
slicsz=	bittln*2*8.*2	;bytes

recycl:	jsr	pc,basfrc	;flush .tmp buffer to use as bittab
	clr	curblk(r3)	;no useful block in buffer
	mov	r1,-(sp)	;save r1
	mov	plusta(r0),r1	;get string area bottom
	add	r0,r1		;make absolute
	mov	r1,-(sp)	;pack from here/initial slice base
sliclp:	mov	spda,r0		;restore spda/pointer to string list
	mov	(sp),r2		;compute new slice base
	sub	r0,r2		;relative for comparison
	cmp	r2,pludyn(r0)	;is next base off end?
	blo	gcmark		;no, process a slice, return to sliclp
	sub	r0,r1		;make the packing limit relative
	mov	r1,pludyn(r0)	;and save as the new "free" pntr
	tst	(sp)+		;remove slice base
	mov	(sp)+,r1	;restore r1
	rts	pc		;done

	.sbttl	gcmark - recycler's marking phase

;gcmark marks each string within slice in the bittab
;it also saves first two bytes of string in pntr and puts a
;back pointer to string header in place of these two bytes.
;if a string was already pointed to by a header
;previously encountered on the string list the sign bit of len is set.

;entry:
;	r0	spda
;	r1	packing pointer
;	r2-r5	scratch
;	(sp)	slice base
;usage:
;	r0	current string header (going down string list)
;	r2	absolute string loc.
;	r3	spda+index to bittab
;	r4	index to bit


len=	4		;length string rel header

gcmark:	mov	#bittln,r5	;words in bit table
	mov	#bittab,r4	;relative bittab
	add	r0,r4		;now absolute
9$:	clr	(r4)+		;clear the bittab
	sob	r5,9$		;every word
1$:	tst	(r0)		;end of string list?
	beq	gcswep		;yes, time to compact
	add	(r0),r0		;slip down to next header
	mov	r0,r2		;absolute to header
	tst	length(r2)	;skip null strings
	beq	1$		;they cause trouble
	add	pntr(r2),r2	;absolute to string
	mov	r2,r3		;copy to break up
	jsr	pc,gcbkup	;break up address
	bcs	1$		;out of slice
	add	spda,r3		;add data base to byte index
	bitb	bit(r4),bittab(r3);did we see this string before?
	beq	2$		;if not; it is a primary reference
	bis	#100000,len(r0)	;it is secondary, note that fact
2$:	bisb	bit(r4),bittab(r3);a string starts here!
	mov	(r2),pntr(r0)	;first two bytes of the string
	mov	r0,(r2)		;back pointer from string
	br	1$

	.sbttl	gcbkup - break abs address into bit and byte indices

;call:
;	r3	absolute address
;	(sp)	slice base
;	jsr	pc,gcbkup
;rtrn:
;	c	set iff address not in slice
;	r3	byte index into bittab
;	r4	bit index into bit
;	r0,r1,r2,r5	preserved

gcbkup:	sub	2(sp),r3	;relative to slice base
	blo	1$		;if below slice
	cmp	r3,#slicsz	;is it above slice
	bhis	1$		;if above
	asr	r3		;string pointers known to be even
	mov	r3,r4		;will be the bit part
	bic	#-bittln*2,r3	;mask for byte in bittab
	bic	r3,r4		;clear these out of bit part
	swab	r4		;**get bit address right justified
	asr	r4		;**these instructions depend on bittln
	rts	pc

1$:	sec			;out of slice
	rts	pc
	.sbttl	gcswep - recycler's compacting phase

;usage:
;	r0	bittab byte pointer
;	r1	packing pointer
;	r2	bit index
;	r3	count of bytes-to-go in sweep of bittab
;	r4	bit/string starting address
;	r5	bittab index/string header address
;	(sp)	slice base

gcswep:	clr	r2		;bit index - left to right scan
2$:	mov	spda,r0		;get data base
	mov	pludyn(r0),r3	;end of active string area
	add	r0,r3		;now absolute
	jsr	pc,gcbkup	;break it up
	bcs	8$		;not in this slice
	cmp	r2,r4		;check bit index
	bhi	10$		;done!
	blo	8$		;must sweep all this bit
	tst	r3		;check the byte index
	bne	5$		;short sweep cycle
	br	10$		;none to do

8$:	mov	#bittln*2,r3	;loop on bytes in bittab
5$:	add	#bittab,r0	;abs bit table base
	movb	bit(r2),r4	;get bit for fast loop
1$:	bitb	r4,(r0)+	;search for bit on
	bne	3$		;a string starts here
9$:	sob	r3,1$		;loop through all bittab
	inc	r2		;and then shift over a bit
	cmp	r2,#8.		;see if all bits scanned-for
	bne	2$		;no
10$:	add	#slicsz,(sp)	;index up to next slice
	br	sliclp

3$:	mov	r2,r4		;make string address
	asl	r4		;**high part is from bit
	swab	r4		;**these insts depend on bittln
	mov	r0,r5		;work on the byte address
	sub	#bittab+1,r5	;remove the bittab base part
	sub	spda,r5		;remove data base
	bis	r5,r4		;combine parts
	asl	r4		;remember this shift from before?
	add	(sp),r4		;add slice base=string address
	mov	(r4),r5		;lo, the header address we stuck here
6$:	mov	pntr(r5),-(sp)	;save back link/2 bytes of string
	mov	r1,pntr(r5)	;new string location
	sub	r5,pntr(r5)	;make relative
	tst	len(r5)		;see if primary or secondary reference
	bpl	4$		;if primary
	bic	#100000,len(r5)	;clear the flag bit
	mov	(sp)+,r5	;that was a back pointer
	br	6$		;track further

4$:	mov	(sp)+,(r4)	;that was 2 bytes of string
	mov	len(r5),r5	;# bytes to compact
	asr	r5		;round up to words
	adc	r5		;now words
	beq	11$		;done if null string
7$:	mov	(r4)+,(r1)+	;move one string word down
	sob	r5,7$		;move every one of them
11$:	movb	bit(r2),r4	;restore the test bit
	br	9$		;continue scan
	.sbttl	core allocator routines
	.sbttl	adjust - punish or reward nominals

welfar=	60			;if nom shrinks<=40 restored to this

adjust:	mov	xxxnom+2(sp),r4	;pick up area indicator
	cmp	r4,#strnom	;no adjustment to this one
	beq	punish		;so skip
	clr	strnom(r0)	;let it just get left overs
	add	r0,r4		;make absolute
	mov	(r4),r5		;multiply nominal
	asr	r5		;by 1.25
	asr	r5
	asr	r5		;less one if odd
	asl	r5
	add	r5,(r4)		;update parameter
punish:	mov	#tagnom,r3	;punish each nom now
	add	r0,r3		;thus reducing the rewarded one
	mov	#3,r2		;punish by mult by (1-1/16)
1$:	mov	(r3),r4		;old value
	ash	#-5,r4		;punish it
	asl	r4		;and less one if odd
	sub	r4,(r3)		;reward is 75/64
	beq	3$		;0 ok -- for ro system
	cmp	(r3),#40	;minimum value allowed otherwise
	bhis	3$		;big enough
	mov	#welfar,(r3)	;subsistance
3$:	tst	(r3)+		;advance to next parameter
	sob	r2,1$		;loop through all
	rts	pc

	.sbttl	gcfit - sums up free space and nominals

gcfit:	mov	r1,r2		;stack pointer
	sub	#nstorg,r2	;less bottom gives free space
	jsr	pc,casumf	;sum free string and string header
	mov	spta,r0		;program base
	jsr	pc,casumf	;sum free push-pop and statement hdr
	mov	#tagnom,r3	;sum some nominals
	add	r0,r3		;absolute
	mov	(r3)+,r4	;tag
	add	(r3)+,r4	;pro
	add	(r3)+,r4	;hdr
	mov	r4,nstrnm(r0)	;save these
	bmi	1$		;overflow
	tst	(r3)+		;skip strnow
	add	(r3),r4		;str
	add	r1snom(r0),r4	;last r1s
	mov	r4,sumnom(r0)	;save all here
1$:	rts	pc

	.sbttl	realoc - reallocate free space
ptaoff=	0		;pta offset relative sp (tmp storage)
pdaoff=	2
r1soff=	4

realoc:	.stat			;get core size parameters
	mov	xrb+xrlen,r5	;current size
	jsr	pc,gcfit	;compute sums
	bmi	3$		;if overflow
2$:	cmp	r2,sumnom(r0)	;if total small need more core
	bge	1$		;no need
	cmp	r5,xrb+xrloc	;max size for this job
	blo	4$		;yes
5$:	mov	r5,xrb+xrlen	;make sure we got our core
	jsr	pc,d.core	;call for core
	bne	3$		;error
	cmp	nstrnm(r0),#3*welfar	;if less than this
	blo	3$		;give up
	jsr	pc,punish	;else keep reducing noms
	br	realoc		;and trying again

3$:	jsr	pc,edrsr1	;reset r1 stack
	jsr	pc,preset	;clear all variables - release strings
	jsr	pc,zotall	;close all user files
	jsr	pc,getbuf	;now grab a firqb and
	movb	xcdchn,fqfil(r4);set (possible) extra channel to close
	beq	6$		;there is none
	jsr	r5,edfipk	;there is one, so call for
	+	rstfq		; a reset type close on it
6$:	mov	#xcdcor-trap,iosts	;to get to ederrn
	ioterr	!fatal		;after xcdcor error

4$:	inc	r5		;one more k o core
	mov	spta,r4		;add to push-pop area
	add	#blklen,plulim(r4);=1 k o core
	add	#blklen,r2	;and to sum
	br	2$

1$:	sub	nstrnm(r0),r2	;put all extra space
	mov	r1snom(r0),r4	;get nominal r1 space
	sub	r4,r2		;remove it from extra
	mov	r2,strnow(r0)	;in string area
	mov	r5,xrb+xrlen	;here is where k desired goes
	jsr	pc,d.core	;ask for core
	bne	3$		;error
	sub	r1,r4		;less current pointer
	add	#nstorg,r4	;plus lower limit
	mov	r4,-(sp)	;save offset [r1soff]
	add	r1corg,r4	;new r1 stack origin
	add	hdrnom(r0),r4	;by seeing how it moves from bottom
	sub	mindyn(r0),r4	;(which is r1 stack org)
	sub	r0,r4		;offset for data area
	mov	r4,-(sp)	;save it [pdaoff]
	add	strnow(r0),r4	;to get to boundary of data and program
	add	pludyn(r0),r4	;add two pieces
	add	r0,r4		;now absolute new address of boundary
	mov	spta,r2		;program base
	add	tagnom(r0),r4	;now compute last offset
	sub	mindyn(r2),r4	;same way
	sub	r2,r4		;now offset for program area
	mov	r4,-(sp)	;save it [ptaoff]
	tst	pdaoff(sp)	;see which way pda goes
	bpl	ca10		;if up move program,data,stack
	jsr	pc,camr1s	;if down, move stack
	jsr	pc,campda	;	data
	jsr	pc,campta	;	program
	br	ca99		;wheh!
ca10:	jsr	pc,campta	;move program
	jsr	pc,campda	;	data
	jsr	pc,camr1s	;	stack
ca99:	mov	r1soff(sp),r5	;r1 stack offset
	add	r5,r1corg	;update r1
	add	r5,r1ring	;relating to csr's
	add	r5,r1		;update r1 stack pointer
	sub	pdaoff(sp),r5	;between r1s and pda
	mov	mindyn(r0),r4	;and to header active region
	cmp	(r0),r4		;is first header on stack?
	bge	ca98		;no, so none to reloc
	add	r5,(r0)		;yes,so update pointer
	mov	r0,r4
	add	(r4),r4		;and get abs pointer to header on stack
ca97:	sub	r5,2(r4)	;now it is different distance to string
	mov	r4,r3
	add	(r4),r4		;next item
	cmp	r4,r1corg	;does it point off stack?
	blo	ca97		;no
	sub	r5,(r3)		;yes, better reloc
ca98:	mov	base+curloc(r0),r2	;fix data pointer
	add	#base,r2	;relative pointer
	mov	(sp)+,r3	;[ptaoff] figure crazy relocation
	sub	(sp)+,r3	;[pdaoff]
	cmp	r2,pludyn(r0)	;ck for corss string area
	blo	ca981		;no
	add	r3,base+curloc(r0)	;and move it in
ca981:	jsr	pc,ca98s	;clear free string header space
	mov	spta,r0		;clear tag space
	tst	(sp)+		;[r1soff] drop to clear tag space

ca98s:	mov	mindyn(r0),r2	;use r2 for count
	sub	minlim(r0),r2	;of number of free bytes
	asr	r2		;err, i mean words
	beq	ca98b		;in case there aren't any
	add	mindyn(r0),r0	;pointer to high end of free area
ca98a:	clr	-(r0)		;clear one word
	sob	r2,ca98a	;and work until done
ca98b:	br	ca130

;routine to sum up free space in spxa area

casumf:	add	#pludyn,r0	;aim at relevent block
	sub	(r0)+,r2	;+dyn
	add	(r0)+,r2	;-dyn
	add	(r0)+,r2	;+lim
	sub	(r0),r2		;-lim
	br	ca130		;restore spda and return

	.sbttl	realoc's moving routines


campda:	mov	#strnow,r3	;set up access to noms
	add	r0,r3		;absolute
	mov	pdaoff+2(sp),r4	;and offset
	jsr	pc,camove	;move it
	add	r0,spda		;update spda
	mov	#9.,r3		;and many other places
	mov	#cosi,r5	;from here
ca13:	add	r0,(r5)+	;all in csr area
	sob	r3,ca13
	br	ca130		;restore data pointer

campta:	mov	r0,r3		;make an absolute pointer
	add	#pronom,r3	;to nominals area
	mov	spta,r0		;move program area
	mov	ptaoff+2(sp),r4	;by this much
	jsr	pc,camove	;up or down as appropriate
	add	r0,spta		;update spta
	add	r0,scth		;and scth
	add	r0,r5ring	;is sometimes saved ipc
ca130:	mov	spda,r0		;retrieve spda
	rts	pc

camr1s:	mov	r1corg,r2	;see how much junk on stack
	mov	r1soff+2(sp),r4	;get stack offset
	bpl	camr1a		;if it goes up
	mov	r1,r5		;if down move it now
	add	r1,r4		;move it to here
	sub	r1,r2		;which needs to be moved
	br	camovd		;down

camr1a:	mov	r2,r5		;present base of stack
	sub	r1,r2		;number bytes to be moved
	add	r5,r4		;new base
	br	camovu		;take it fellows
;routine to move area to establish nominal free space.
;assumes base for area in r0.  resets limit parameters.

;call:
;	r0	spda or spta
;	r3	pntr to nom for plus area
;	r4	offset for the area
;	jsr	pc,camove
;rtrn:
;	r0	offset that was in r4
;	r1	preserved
;	r2,r3,r4,r5	junk

camove:	mov	pludyn(r0),r2	;get current limit
	mov	r2,r5		;set new upper limit
	add	(r3),r5		;to current point plus nominal
	mov	r5,plulim(r0)	;now it is set
	mov	mindyn(r0),r5	;set new lower limit
	sub	-(r3),r5	;to current point less nominal
	mov	r5,minlim(r0)	;set now
	mov	r2,r5		;compute active region length
	sub	mindyn(r0),r2	;to know how much to move
	add	r0,r5		;abs start (or end) for move
	mov	r4,r0		;move up or down?
	beq	ca3		;or no move at all
	bmi	ca4		;down, so start at min end
	add	r5,r4		;up from pludyn to here
camovu:	asr	r2		;only half as many words as bytes
	beq	ca3
ca2:	mov	-(r5),-(r4)	;move one word
	sob	r2,ca2		;these many times
	rts	pc

ca4:	sub	r2,r5		;abs ptr to mindyn to start from
	add	r5,r4		;to here
camovd:	asr	r2		;halve count
	beq	ca3
ca5:	mov	(r5)+,(r4)+	;in this order to avoid overlap
	sob	r2,ca5		;this many words
ca3:	rts	pc

	.end
