MODULE test5;
{
 A fairly close transliteration of WG2.4 test X5.

 The program does a non-recursive tree walk, here
 the type of the tree is known to the treewalker.
}
CONST treemax = 64; { max. nodes in tree }

TYPE link = integer;
     node = RECORD
              left, right: link;
              info: integer
            END;
VAR tree: ARRAY 1:treemax OF node;

PROCEDURE gen(n: integer); { generate tree with n nodes }
VAR i: integer;
BEGIN
  i := 1;
  REPEAT
    WITH tree[i] DO
      left := 2*i;
      right := 2*i+1;
      info := i
    END;
    inc(i)
  UNTIL i>n DIV 2-1;
  REPEAT
    WITH tree[i] DO
      left := 0;
      right := 0;
      info := i*(i-1) DIV 2-300
    END;
    inc(i)
  UNTIL i>n
END gen;

PROCEDURE walk(t: link);
  VAR sum: integer;

  MODULE stack;
  DEFINE push, pop, empty;
  USE link;
    VAR st: ARRAY 1:100 OF link;
        stp: integer;

    PROCEDURE push(t: link);
    BEGIN inc(stp); st[stp] := t END push;

    PROCEDURE pop(VAR t: link);
    BEGIN t := st[stp]; dec(stp) END pop;

    PROCEDURE empty: boolean;
    BEGIN empty := stp=1 END empty;

  BEGIN { stack }
    stp := 1
  END stack;

BEGIN { tree walk }
  sum := 0;
  LOOP
    WHILE t<>0 DO
      push(t);
      t := tree[t].left
    END;
    WHEN empty EXIT;
    pop(t);
    sum := sum+tree[t].info;
    t := tree[t].right
  END;
  IF sum=27600 THEN writen(sum) END
END walk;

BEGIN { Test X5 }
  gen(64);
  rewrite('a.tst');
  writes('Expected:- 27600'); newline;
  writes('Obtained:- '); 
  walk(1); newline
END test5.
{
.bp
}
