MODULE t8b1;
  CONST m = 8;   (* no. of vehicles on screen *)
  VAR i, x0, y0: integer;
      scrsig, pensig: signal;
      x, y:   ARRAY 1:m OF integer;   (* coordinates *)
      dx, dy: ARRAY 1:m OF integer;   (* increments *)
      del:    ARRAY 1:m OF integer;   (* delay steps *)

DEVICE MODULE display [4];
  USE x, y, dx, dy, del, pensig, scrsig, m;
  CONST n = 8;   (* no. of commands *)
  VAR mode: (frame, figure, command);
      i: integer;
      z: integer; (* index of currently identified vehicle *)
      dpc [172000B]: integer; (* display program counter *)
      frm: ARRAY 0:17 OF integer;   (* frame display code *)
      fig: ARRAY 1:13 OF integer;   (* vehicle display code *)
      com: ARRAY 1:n, 0:15 OF integer;   (* command codes *)

  PROCESS screen [320B];
  BEGIN
    LOOP wait(scrsig);
      mode := frame; dpc := adr(frm); doio;
      mode := figure; i := m;
      REPEAT fig[1] := x[i]; fig[2] := y[i];
        fig[11] := 64 + i;
        IF i=z THEN fig[10] := 103630B   (* blink on *)
               ELSE fig[10] := 103620B   (* blink off *)
        END;
        dpc := adr(fig); doio; dec(i)
      UNTIL i = 0;
      mode := command; i := n;
      REPEAT dpc := adr(com[i]); doio; dec(i)
      UNTIL i = 0
    END
  END screen;

  PROCESS pen [324B];
    VAR d: integer;
  BEGIN
    LOOP frm[0] := 117164B; doio;   (* wait until pen signals *)
         frm[0] := 117125B;
      IF mode = figure THEN z := i
      ELSIF mode = command THEN
        CASE i OF
          1: BEGIN inc(dx[z]) END;
          2: BEGIN inc(dy[z]) END;
          3: BEGIN dec(dx[z]) END;
          4: BEGIN dec(dy[z]) END;
          5: BEGIN inc(del[z]) END;
          6: BEGIN dec(del[z]) END;
          7: BEGIN dx[z] := 0; dy[z] := 0; del[z] := 0;
               IF z = 1 THEN halt(0) END
             END;
          8: BEGIN dx[z] := -dx[z]; dy[z] := -dy[z] END
        END
      END;
      dpc := adr(frm);   (* restart display *)
      d := 25;
      REPEAT wait(pensig); dec(d) UNTIL d = 0
    END
  END pen;

BEGIN (* display module *)
  frm[00] := 117124B; frm[01] := 000000B; frm[02] := 000000B;
  frm[03] := 110000B; frm[04] := 041777B; frm[05] := 000000B;
  frm[06] := 040000B; frm[07] := 001777B; frm[08] := 061777B;
  frm[09] := 000000B; frm[10] := 040000B; frm[11] := 021777B;
  frm[12] := 000000B; frm[13] := 000200B; frm[14] := 041777B;
  frm[15] := 000000B; frm[16] := 173400B;
  mode := frame; z := 1; screen; pen
END display;

DEVICE MODULE timing [6];
  DEFINE tick;
  VAR tick: signal;
      lcs [177546B]: bits;

  PROCESS clock [100B];
  BEGIN lcs[6] := true;
    LOOP doio;
      WHILE awaited(tick) DO send(tick) END
    END
  END clock;

BEGIN clock
END timing;

PROCESS vehicle(i: integer);
  VAR d: integer;
BEGIN
  LOOP d := del[i];
    REPEAT wait(tick); dec(d)
    UNTIL d < 0;
    inc(x[i], dx[i]);
    IF (x[i] < 0) OR (x[i] > 1740B) THEN
       dx[i] := -dx[i]; inc(x[i], dx[i])
    END;
    inc(y[i], dy[i]);
    IF (y[i] < 200B) OR (y[i] > 1740B) THEN
       dy[i] := -dy[i]; inc(y[i], dy[i])
    END
  END
END vehicle;

PROCESS clock;
BEGIN
  LOOP wait(tick); send(scrsig); send(pensig)
  END
END clock;

BEGIN (* spacerace *)
  i := m;
  x0 := 2000B/(m+1); y0 := 220B;
  REPEAT x[i] := i*x[0]; y[i] := y0;
    dx[i] := 0; dy[i] := 0; del[i] := 0;
    vehicle(i); dec(i)
  UNTIL i = 0;
  clock
END t8b1.
{
.bp
}
