c	program synthetics
c
c	mode 1 - creates common shot point hyperbolas caused
c		 by a point scatterer located at x0,z0.
c		 Output is convolved with a Ricker wavelet with	
c		 a peak frequency of fp.
c
c	units are in meters and seconds.
c
	dimension p(1024),r(100)
c
	sgd=50.
	dx=50.
	dt=0.004
	v=3000.
	nx=32
	nt=128
	fp=50.
	nr=50
	nx3=nx/3
	x0=nx3*dx
	na=nt/4
	z0=(na-1)*dt*v
	t0m=z0/v
	z02=z0*z0
	mode=1
c
	call argfil(1,2,512)
c
c	create Ricker wavelet
c
	call ricker(r,dt,fp,nr)
	write(6,101) (r(i), i=1,nr)
101	format(2x,5f8.2)
c
c	mode=1 here
c
	do 10 ix=1,nx
	x=sgd+(ix-1)*dx
	x=x-x0
	x2=x*x
	do 1 it=1,nt
1	p(it)=0.
	t0=sqrt(x2+z02)/v
	it0=t0/dt
	write(6,100) ix,it0
100	format(2x,'ix=',i3,2x,'it0=',i5)
	ish=18
	it0s=it0-ish
	if(it0s.gt.nt) go to 5
	call wave(it0s,p,r,nt,nr,t0m,dt,it0)
5	do 7 j=1,nt
	q=p(j)
	write(1) q
7	continue
10 	continue
	stop
	end
c
	subroutine ricker(r,dt,fp,nr)
	dimension r(nr)
c
c	generates a ricker wavelet with a peak freq. of fp (Hz) and 
c	a length of nr.
	pi=3.14159265
	alpha=pi*fp
	alpha2=alpha*alpha
	tau=2.525/alpha
	a=50.
	nr2=nr/2 + 1
	do 1 it=1,nr
	t=(nr2-it)*dt
	t1=t-tau
	t2=t1*t1
	e=exp(-alpha2*t2)
	c=2.*alpha2*t2 - 1.
1	r(it)=a*c*e
	return
	end
c
	subroutine wave(it0s,p,r,nt,nr,t0m,dt,it0)
	dimension p(nt),r(nr)
	ne=it0s+nr-1
	n=min0(ne,nt)
	do 1 i=it0s,n
	j=i-it0s+1
	t=(it0-1)*dt
1	p(i)=r(j)*(t0m/t)**2
	return
	end
