MODULE t8b2;
CONST lf = 12C; cr = 15C; bs = 10C; esc = 33C;
      fs = 34C; rs = 36C; bel = 7C; dc1 = 21C;
VAR ch, fch: char;
  i: integer;
  com: ARRAY 1:80 OF char; (* current commmand *)

DEVICE MODULE terminalinput [4];
  DEFINE get;
  USE ch;
  CONST del = 177C; bufsize = 256;
  VAR n, in, out: integer;
      nonempty, nonfull: signal;
      buf: ARRAY 1:bufsize OF char;

  PROCEDURE get;
  BEGIN IF n = 0 THEN wait(nonempty) END;
    ch := buf[out]; out := (out MOD bufsize) + 1;
    dec(n); send(nonfull)
  END get;

  PROCESS driver [300B];
    VAR ts [175610B]: bits;
        tb [175612B]: integer;
        ch: char;
  BEGIN
    LOOP IF n = bufsize THEN wait(nonfull) END;
      ts[6] := true; doio; ts[6] := false;
      ch := char(tb MOD 200B);
      IF ch = del THEN halt(0) END;
      buf[in] := ch; in := (in MOD bufsize) + 1;
      inc(n); send(nonempty)
    END
  END driver;

BEGIN n := 0; in := 1; out := 1; driver
END terminalinput;

DEVICE MODULE terminaloutput [4];
  DEFINE put;
  CONST bufsize = 256;
  VAR n, in, out: integer;
      nonempty, nonfull: signal;
      buf: ARRAY 1:bufsize OF char;

  PROCEDURE put(x: char);
  BEGIN IF n = bufsize THEN wait(nonfull) END;
    buf[in] := x; in := (in MOD bufsize) + 1;
    inc(n); send(nonempty)
  END put;

  PROCESS driver [304B];
    VAR ts [175614B]: bits;
        tb [175616B]: char;
  BEGIN
    LOOP IF n = 0 THEN wait(nonempty) END;
      tb := buf[out]; out := (out MOD bufsize) + 1;
      ts[6] := true; doio; ts[6] := false;
      dec(n); send(nonfull)
    END
END driver;

BEGIN n := 0; in := 1; out := 1; driver
END terminaloutput;

INTERFACE MODULE diskio;
  DEFINE open, read, write, close;
  USE ch, fs;
  CONST nsec = 4;   (* no of sectors *)
    sectorsize = 512;
    bufsize = 2048;   (* bufsize = nsec*sectorsize *)
    maxsectors = 48;  (* max no. of sectors per file *)
    nfl = 8;          (* no. of files *)
  VAR mode: integer;  (* 0=free, 1=read, 2=write *)
    nc: integer;      (* no. of chars in current sector *)
    ns: integer;      (* no. of sectors written *)
    xp: integer;      (* buffer index of program *)
    current: integer; (* index of current file *)
    file: ARRAY 1:nfl OF RECORD adr, size: integer END;
    buf: ARRAY 1:bufsize OF char;

DEVICE MODULE disk [5];
  DEFINE opendisk, transmitsector, closedisk;
  USE buf, bufsize, sectorsize, nsec, fs;
  VAR np, nd: integer;   (* no of sectors available *)
    sp, sd: signal;
    diskstate: bits;
    diskreq, diskfree: signal;

    rkds [177400B]: bits;        (* drive status *)
    rker [177402B]: bits;        (* error status *)
    rkcs [177404B]: bits;        (* control status *)
    rkwc [177406B]: integer;     (* word count *)
    rkba [177410B]: integer;     (* buffer address *)
    rkda [177412B]: integer;     (* disk address *)
  PROCEDURE opendisk(m, a: integer);
  (* initialise disK in mode m at address a *)
  BEGIN IF diskstate[6] THEN wait(diskfree) END;
    IF m = 1 THEN
      diskstate := [0, 2, 6]; nd := nsec; np := 0
    ELSE
      diskstate := [0, 1, 6]; nd := 0; np := nsec
    END;
    rkda := a + 20000B; send(diskreq);
    dec(np); IF np<0 THEN wait(sp) END
  END opendisk;

  PROCEDURE transmitsector;
  BEGIN inc(nd); IF nd >=0 THEN send(sp) END;
        dec(np); IF np < 0 THEN wait(sp) END
  END transmitsector;

  PROCEDURE closedisk;
  BEGIN inc(nd); IF nd >=0 THEN send(sd) END
  END closedisk;

  PROCESS driver [220B];
    CONST wps = 256;    (* words/sector = bufsize/2 *)
    VAR endchar: char;
        xd: integer;    (* buffer index *)
  BEGIN
    LOOP wait(diskreq); xd := 1;
      REPEAT dec(nd);
        IF nd < 0 THEN wait(sd) END;
        rkwc := -wps; rkba := adr(buf[xd]);
        rkcs := diskstate; doio; rkcs[6] := false;
        IF rkcs[15] THEN halt(15) END;
        inc(xd, sectorsize); endchar := buf[xd-1];
        IF xd > bufsize THEN xd := 1 END;
        inc(np); IF np >= 0 THEN send(sp) END
      UNTIL endchar = fs;
      diskstate := []; send(diskfree)
    END
  END driver;

BEGIN diskstate := []; driver
END disk;

PROCEDURE open(m: integer; k:char);
(* open file k in mode m *)
BEGIN mode := m; nc := sectorsize; ns := 0; xp := 1;
  current := integer(k) - integer('0');
  IF (m=1) AND (file[current].size = 0) THEN halt(3) END;
  opendisk(m, file[current].adr)
END open;

PROCEDURE write;
BEGIN (* assume mode = 2, nc < sectorsize, ch <> fs *)
  buf[xp] := ch; inc(xp); dec(nc);
  IF nc= 0 THEN
    IF xp > bufsize THEN xp := 1 END;
    transmitsector; nc := sectorsize;
    inc(ns); IF ns = maxsectors THEN halt(1) END
  END
END write;

PROCEDURE read;
BEGIN (* assume mode = 1 *)
  IF nc = 0 THEN
    IF xp > bufsize THEN xp := 1 END;
    transmitsector; nc := sectorsize
  END;
  ch := buf[xp]; inc(xp); dec(nc)
END read;

PROCEDURE close;
BEGIN (* assume mode = 1 OR 2 *)
  IF mode = 2 THEN
    buf[xp+nc-1] := fs;
    inc(ns); file[current].size := ns
  END;
  closedisk; mode := 0
END close;

BEGIN (* interface module diskio *)
  mode := 0; current := nfl;
  REPEAT file[current].adr := current*64;
         file[current].size := 0; dec(current)
  UNTIL current = 0
END diskio;

MODULE scanner;
  DEFINE readcommand;
  USE ch, com, lf, bs, get, put;
  VAR k, n: integer;
      line: ARRAY 1:80 OF char;

  PROCEDURE readline;
    VAR i: integer;
    (* assume linlength <= 80 *)
  BEGIN put('*'); i := 0; k := 0;
    REPEAT get;
      IF ch = bs THEN (* cancel *)
        put('\'); i := 0; n := 0;
      ELSE
        inc(i); line[i] := ch; put(ch);
        IF ch = '.' THEN inc(n) END
      END
    UNTIL ch = lf
  END readline;

  PROCEDURE readcommand;
    VAR j: integer;
   BEGIN 
    WHILE n = 0 DO readline END;
    dec(n); j := 0;
    REPEAT inc(j); inc(k); com[j] := line[k]
    UNTIL line[k] = '.'
  END readcommand;

BEGIN n := 0;
END scanner;

PROCEDURE escseq;
BEGIN put(esc); put('&'); put('p')
END escseq;

PROCEDURE acknowledge;
BEGIN put(dc1); get;
  IF ch <> 'S' THEN put(ch); put(bel) END;
  REPEAT get UNTIL ch = lf
END acknowledge;

BEGIN (* main *)
  LOOP readcommand;
    IF com[1] = 'C' THEN     (* control *)
      escseq; i := 2;
      WHILE com[i] <> '.' DO
        put(com[i]); inc(i)
      END;
      acknowledge
    ELSIF com[1] = 'R' THEN   (* read tape *)
      open(2, com[2]);
      REPEAT (* read a line *)
        escseq; put('0'); put('R'); put(dc1);
        get; fch := ch; write;
        REPEAT get; write
        UNTIL ch = lf
      UNTIL fch = rs;
      close
    ELSIF com[1] = 'W' THEN    (* write tape *)
      open(1, com[2]); read;
      WHILE ch <> rs DO
        escseq; put('W'); put(ch);
        REPEAT read; put(ch)
        UNTIL ch = lf;
        acknowledge; read
      END;
      escseq; put('5'); put('C'); (* mark tape *)
      acknowledge; close
    END;
    put(bel)
  END
END t8b2.
{
.bp
}
