#

#include	"mas.h"


extern struct expr exptab[];
extern struct symbol *symtab;
extern struct fb *fbtable;
extern struct evalx r;

extern pc_def;
extern unsigned pc;
extern char seg;


evalexpr()
{
	register struct expr *x;
	register struct symbol *sym;
	register struct fb *fbp;
	int n,k;

	x = exptab;
	r.r_type = UND;

	switch ( x->e_rand ) {		/* first operand */
	case e_CON:
		r.r_val = x->e_val;
		r.r_seg = CABS;
		n = ABS;
		break;

	case e_SYM:
		sym = &symtab[x->e_val];
		if ( (n = sym->s_def & SMASK) == UND )
			return;
		r.r_val = sym->s_pc;
		r.r_seg = sym->s_seg;
		break;

	case e_TL:
		fbp = &fbtable[x->e_val];
		if ( (n = fbp->fb_def) == UND )
			return;
		r.r_val = fbp->fb_pc;
		r.r_seg = fbp->fb_seg;
		break;

	case e_PC:
		r.r_val = pc;
		r.r_seg = seg;
		n = pc_def;
		break;

	default:
		syserr();
	}

	if ( n == EST ) {
		if ( x->e_rator == 0 ) {
			r.r_type = EST;
			return;
		}
		r.r_type = EXP;
	}

	while ( k = x++->e_rator ) {
		switch ( x->e_rand ) {
		case e_CON:
			if(r.r_seg != CABS && k != e_PLUS && k != e_MINUS)
			{
				r.r_type = UND;
				return;
			}
			if ( r.r_type == EXP )
				continue;
			switch ( k ) {
			case e_PLUS:
				r.r_val =+ x->e_val;
				continue;
		
			case e_MINUS:
				r.r_val =- x->e_val;
				continue;
		
			case e_SLASH:
				r.r_val =/ x->e_val;
				continue;
		
			case e_STAR:
				r.r_val =* x->e_val;
				continue;
			case e_AMPER:
				r.r_val =& x->e_val;
				continue;
			case e_LTHAN:
				r.r_val =<< x->e_val;
				continue;
		
			case e_GTHAN:
				r.r_val =>> x->e_val;
				continue;
		
			default:
				syserr();
			}
			continue;

		case e_SYM:
			sym = &symtab[x->e_val];
			switch ( sym->s_def ) {
			case COMM + UND:
			case GLBL + UND:
			case UND:
				r.r_type = UND;
				return;

			case GLBL + EST:
			case EST:
				r.r_type = EXP;

			case GLBL + ABS:
			case ABS:
				compute(k, sym->s_seg, sym->s_pc, sym->s_def);
				if(r.r_type == UND)
					return;
				continue;

			default:
				syserr();
			}
			continue;

		case e_TL:
			fbp = &fbtable[x->e_val];
			switch ( fbp->fb_def ) {
			case UND:
				r.r_type = UND;
				return;

			case EST:
				r.r_type = EXP;

			case ABS:
				compute(k, fbp->fb_seg, fbp->fb_pc, fbp->fb_def);
				if(r.r_type == UND)
					return;
				continue;


			default:
				syserr();
			}
			continue;

		case e_PC:
			if(pc_def == EST)
				r.r_type = EXP;
			compute(k, seg, pc, pc_def);
		}
	}

	if ( r.r_type != EXP )
		r.r_type = ABS;
	return;
}




compute(op, seg, val, def)
char seg;
{

	if(r.r_seg == CABS)
	{
		if(op == e_PLUS)
			r.r_seg = seg;
		else
		r.r_type = UND;	/* pick up errors in the second pass */
	}
	else
	if(r.r_seg == seg)
	{
		if(op == e_MINUS)
		{
			if((def & SMASK) == ABS)
			{
				if(r.r_type == ABS)
				{
					r.r_val =- val;
					r.r_type = ABS;
				}
				r.r_seg = CABS;
			}
			else
				r.r_type = def & SMASK;
			return;
		}
	}
	r.r_type = UND;
}
