#define	DEFINITIVE
	/*
	 *
	 *	aug '77		Chris M, Ian J
	 *
	 *	consolidated ps
	 *	faster - gprocs - print time - no k flag -
	 *	better defintion of a & t flags
	 *
	 *	nov '77		Ian J
	 *
	 *	introduce 'c' and 'p' flags
	 *	'c'  => print sum of child usr+sys times
	 *	'p'  => print sum of usr+sys times
	 *	'cp' => print sum of child & parant times
	 *	default is 'p'
	 *	also check locations 54&56 for non-zero
	 *	if so this long indicates clock tics since
	 *	clock initialized. print this info atop listing.
	 */
#ifdef	DEFINITIVE

/*
 *	ps - process status
 *	examine and print certain things about processes
 */

#include <param.h>
#include <proc.h>
#include <tty.h>
#include <user.h>

struct proc proc[NPROC];
int ttydev;
struct user u;
char partab[1];

int	lflg;
int	zflg;
int	cflg;
int	pflg;
int	xflg;
int	tflg;
int	aflg;
int	mem;		/* file desc. for kernal memory space */
int	swap;		/* file desc. for swap area */
char 	mtty 0;		/* char id for terminal on which ps done */

int	ndev;
char	devc[65];	/* last character of tty name from dev */
int	devl[65];	/* corresponding major/minor number */
int	devt[65];

struct {
	long pusr;
	long psys;
	long cusr;
	long csys;
} tbuf;

struct ibuf {
	char	idevmin, idevmaj;
	int	inum;
	int	iflags;
	char	inl;
	char	iuid;
	char	igid;
	char	isize0;
	int	isize;
	int	iaddr[8];
	long	ictime;
	long	imtime;
	int	fill;
};
#define RSIZE 32
#define usagerr { printf("\n\t ps [-][alxcpzt[c]]\n"); done(-1); }

main(argc, argv)
char **argv;
{
	struct proc *p;
	int nproc, b;
	register int i, c, n;
	char *ap;
	int uid, puid;
	long tics;
	extern fout;

	fout = dup(1);
	if ( argc > 2 ) usagerr;
	if (argc > 1) {
		ap = argv[1];
		while (*ap) switch (*ap++) {
		case 'a':
			aflg++;
			break;

		case 't':
			tflg++;
			if( *ap ) mtty = *ap++;
			break;

		case 'x':
			xflg++;
			break;

		case 'l':
			lflg++;
			break;

		case 'z':
			zflg++;
			break;

		case 'c':
			cflg++;
			break;

		case 'p':
			pflg++;
			break;

		case '-':
			break;
		default:
			usagerr;

		}
	}
	if( (cflg==0)&&(pflg==0) ) pflg++;

	if(chdir("/dev") < 0) {
		printf("Chdir /dev failed\n");
		done(-1);
	}
	if ((mem = open("mem", 0)) <= 0) {
		printf("No mem\n");
		done(-1);
	}
	getdev();
	uid = getuid();
	if((swap = open("swap",0)) < 0)
		printf("No swap\n");
	if( (nproc=gprocs(proc)) > NPROC ) {
		printf(" tell a guru to re-compile PS.C \n");
		done(-1);
	}
	if ( zflg ) {
		seek(mem,054,0); read(mem,&tics,4);
		if( tics ) {
			ptime(tics);
			printf(" since boot");
			i = proc[0].p_addr;
			c = i>>3;
			i = (i&07)<<6;
			i =+ &(0->u_utime);
			seek(mem, c, 3);
			seek(mem, i, 1);
			read(mem,&tbuf,sizeof tbuf); /* get times for system process */
			printf("\n     %ld%% idle time\n",100*(tbuf.pusr+tbuf.psys+tbuf.cusr+tbuf.csys)/tics);
		}
	}
	if(lflg)
	   printf("TTY F S UID   PID PRI   ADDR  SZ  WCHAN   TIME  COMMAND\n");
	   else printf("%s  PID   TIME  COMMAND\n",tflg ? " " : "TTY");
	for (i=0; i<nproc; i++) {
		if (proc[i].p_stat==0)
			continue;
		if (proc[i].p_ttyp==0) {
			if (xflg==0)
				continue;
			c = '?';
		} else {
			for(c=0; c<ndev; c++)
			if(devt[c] == proc[i].p_ttyp) {
				c = devc[c];
				goto out;
			}
			seek(mem, &((proc[i].p_ttyp)->t_dev), 0);
			read(mem, &ttydev, 2);
			for(c=0; c<ndev; c++)
			if(devl[c] == ttydev) {
				devt[c] = proc[i].p_ttyp;
				c = devc[c];
				goto out;
			}
			c = '?';
		out:;
		}
		puid = proc[i].p_uid & 0377;
		/*
		 *	four possibilities of which process's to look at:
		 *
		 *		    a=0		    a=1
		 *
		 *	t=0	all terminals	all terminals
		 *		own processes	all processes
		 *
		 *	t=1	own terminal	own terminal	*
		 *		own processes	all processes
		 *
		 *	*note:	default is own terminal but maybe the named
		 *		terminal
		 */
		if( aflg ) {
			if( tflg && c!=mtty ) continue;
		} else {
			if( uid != puid ) continue;
			else if( tflg && c!=mtty ) continue;
		}
		if (lflg || c!=mtty)
			{ putchar(c); putchar(':'); }
		else if( tflg == 0 )
			{ putchar(' '); putchar(' '); }
		if (lflg) {
			printf("%3o %c%4d", proc[i].p_flag,
				"0SWRIZT"[proc[i].p_stat], puid);
		}
		printf("%6l", proc[i].p_pid);
		if (lflg) {
			if( proc[i].p_nice == 0) c = ' ';
			else if(proc[i].p_nice > 0) c = '+';
			      else c = '-';
			printf("%4d%c%6o%4d", proc[i].p_pri, c, proc[i].p_addr,
				(proc[i].p_size+7)>>3);
			if (proc[i].p_wchan)
				printf("%7o", proc[i].p_wchan); else
				printf("       ");
		}
		if (proc[i].p_stat==SZOMB)
			printf("        <defunct>");
		else
			prcom(i);
		putchar('\n');
	}
	done(0);
}

getdev()
{
	register struct {
			int dir_ino;
			char dir_n[14];
	} *p;
	register i, c;
	int f;
	int mdev;
	char *dbuf = &proc;
	int sdbuf = sizeof proc;
	int sbuf[20];

	if( (f = open("."))<0 ) {
		printf("cannot open /dev\n");
		done(-1);
	}
	c = 0;
	if( mtty == 0 ) {
		fstat( 0, sbuf);
		mdev = sbuf->iaddr[0];
	}

loop:
	if( (i = read(f, dbuf, sdbuf))<=0 ) {
		close(f);
		ndev = c;
		return;
	}
	for(p = dbuf; p < &dbuf[i]; p++) {
		if(p->dir_ino == 0)
			continue;
		if(p->dir_n[0] == 't' &&
		   p->dir_n[1] == 't' &&
		   p->dir_n[2] == 'y' &&
		   p->dir_n[4] == 0 &&
		   p->dir_n[3] != 0) {
			if(stat(p->dir_n, sbuf) < 0)
				continue;
			devc[c] = p->dir_n[3];
			devl[c] = sbuf->iaddr[0];
			if( (mdev == devl[c]) && (mtty==0) )
				mtty = devc[c];
			c++;
			continue;
		}
	}
	goto loop;
}

prcom(i)
{
	int baddr, laddr, mf;
	register int *ip,cp;
	register char *cp1;
	int c, nbad;
	long ct;
	char stbuf[513];

	baddr = 0;
	laddr = 0;
	if (proc[i].p_flag&SLOAD) {
		laddr = proc[i].p_addr;
		mf = mem;
	} else {
		baddr = proc[i].p_addr;
		mf = swap;
	}
	baddr =+ laddr>>3;
	laddr = (laddr&07)<<6;
	seek(mf, baddr, 3);
	laddr =+ &(0->u_utime);
	seek(mf,laddr,1);
	read(mf,&tbuf,sizeof tbuf);
	if(pflg) ct =  tbuf.pusr+tbuf.psys; else ct=0;
	if(cflg) ct =+ tbuf.cusr+tbuf.csys;
	ptime(ct);
	if( i == 0 ) {
		printf(" UNIX");
		return(1);
	}
	baddr = 0; laddr = 0;
	if(proc[i].p_flag & SLOAD)
		laddr = proc[i].p_addr;
	else
		baddr = proc[i].p_addr;
	laddr =+ proc[i].p_size - 8;
	baddr =+ laddr>>3;
	laddr = (laddr&07) << 6;
	seek(mf,baddr,3);
	cp = laddr;
	if(mf == mem)		/* less reading */
		cp =+ 512-RSIZE;
	seek(mf,cp,1);
	cp =- laddr;
	ip = &stbuf[512];
	do {
		read(mf,stbuf + cp,( mf == mem ? RSIZE : 512));
		while(ip > (stbuf + cp))
			if( *--ip == -1) goto found;
		seek(mf, -(RSIZE<<1), 1);
		cp =- RSIZE;
	} while( cp >= 0);
	return(0);
found:	cp1 = ++ip;
	nbad = 0;
	for (; cp1 < &stbuf[512]; cp1++) {
		c = *cp1;
		if (c==0)
			*cp1 = ' ';
		else if (c < ' ' || c > 0176) {
			if (++nbad >= 5) {
				*cp1++ = ' ';
				break;
			}
			*cp1 = '?';
		}
	}
	while (*--cp1==' ') *cp1 = 0;
	printf(lflg?" %.16s":" %.64s", ip);
	return(1);
}

ptime(tics)
long tics;
{
	struct {
		int hiword;
		int loword;
	};
	register divn,sepc,trac,cp;

	divn = 100;
	sepc = '.'; trac = 's';
	if(tics > 15000) {
		sepc = 'm';
		tics = tics / 50; divn = 60;
		if(tics > 18000)
		{
			sepc = 'h';trac = 'm';
			tics = tics / 60;
		}
	}
	else tics = tics * 2;
	cp = tics.loword;
	printf(" %3l%c%1l%1l%c", cp/divn,sepc,
		(cp%divn)/10, cp%10, trac);
}

done(cc)
{

	flush();
	exit(cc);
}
#endif
#ifndef	DEFINITIVE
#

/*
 *	ps - process status
 *	examine and print certain things about processes
 */

#include "/srce/usr/sys/param.h"
#include "/srce/usr/sys/proc.h"
#include "/srce/usr/sys/tty.h"
#include "/srce/usr/sys/user.h"

struct {
	char name[8];
	int  type;
	char  *value;
} nl[3];

struct proc proc[NPROC];
struct tty tty;
char partab[1];
int	lflg;
int	kflg;
int	xflg;
int	tflg;
int	aflg;
int	mem;
int	swap;

int	stbuf[257];
int	ndev;
char	devc[65];
int	devl[65];
int	devt[65];
char	*coref;
struct ibuf {
	char	idevmin, idevmaj;
	int	inum;
	int	iflags;
	char	inl;
	char	iuid;
	char	igid;
	char	isize0;
	int	isize;
	int	iaddr[8];
	char	*ictime[2];
	char	*imtime[2];
	int	fill;
};
int	obuf[259];


main(argc, argv)
char **argv;
{
	struct proc *p;
	int n, b;
	int i, c, mtty;
	char *ap;
	int uid, puid;

	obuf[0] = 1;
	if (argc>1) {
		ap = argv[1];
		while (*ap) switch (*ap++) {
		case 'a':
			aflg++;
			break;

		case 't':
			tflg++;
			break;

		case 'x':
			xflg++;
			break;

		case 'l':
			lflg++;
			break;

		case 'k':
			kflg++;
			break;

		}
	}

	if(chdir("/dev") < 0) {
		printf("cannot change to /dev\n");
		done();
	}
	setup(&nl[0], "_proc");
	setup(&nl[1], "_swapdev");
	nlist(argc>2? argv[2]:"/unix", nl);
	if (nl[0].type==0) {
		printf("No namelist\n");
		return;
	}
	coref = "/dev/mem";
	if(kflg)
		coref = "/usr/sys/core";
	if ((mem = open(coref, 0)) <= 0) {
		printf("No mem\n");
		done();
	}
	seek(mem, nl[1].value, 0);
	read(mem, &nl[1].value, 2);
	seek(mem, nl[0].value, 0);
	read(mem, proc, sizeof proc);
	getdev();
	mtty = ttyn(0);
	uid = getuid() & 0377;
	if(lflg)
	printf("TTY F S UID   PID PRI  ADDR  SZ  WCHAN COMMAND\n"); else
		printf("TTY  PID COMMAND\n");
	for (i=0; i<NPROC; i++) {
		if (proc[i].p_stat==0)
			continue;
		if (proc[i].p_ttyp==0) {
			if (xflg==0)
				continue;
			c = '?';
		} else {
			for(c=0; c<ndev; c++)
			if(devt[c] == proc[i].p_ttyp) {
				c = devc[c];
				goto out;
			}
			seek(mem, proc[i].p_ttyp, 0);
			read(mem, &tty, sizeof tty);
			for(c=0; c<ndev; c++)
			if(devl[c] == tty.t_dev) {
				devt[c] = proc[i].p_ttyp;
				c = devc[c];
				goto out;
			}
			c = '?';
		out:;
		}
		puid = proc[i].p_uid & 0377;
		if (uid != puid && aflg==0)
			continue;
		if (lflg || c!=mtty)
			printf("%c:", c);
		else
			printf("  ");
		if (lflg) {
			printf("%3o %c%4d", proc[i].p_flag,
				"0SWRIZT"[proc[i].p_stat], puid);
		}
		printf("%6l", proc[i].p_pid);
		if (lflg) {
			printf("%4d%6o%4d", proc[i].p_pri, proc[i].p_addr,
				(proc[i].p_size+7)>>3);
			if (proc[i].p_wchan)
				printf("%7o", proc[i].p_wchan); else
				printf("       ");
		}
		if (proc[i].p_stat==5)
			printf("       <defunct>");
		else
			prcom(i);
		printf("\n");
	}
	done();
}

getdev()
{
	register struct { int dir_ino; char dir_n[14]; } *p;
	register i, c;
	int f;
	char dbuf[512];
	int sbuf[20];

	f = open("/dev");
	if(f < 0) {
		printf("cannot open /dev\n");
		done();
	}
	swap = -1;
	c = 0;

loop:
	i = read(f, dbuf, 512);
	if(i <= 0) {
		close(f);
		if(swap < 0) {
			printf("no swap device\n");
			done();
		}
		ndev = c;
		return;
	}
	while(i < 512)
		dbuf[i++] = 0;
	for(p = dbuf; p < dbuf+512; p++) {
		if(p->dir_ino == 0)
			continue;
		if(p->dir_n[0] == 't' &&
		   p->dir_n[1] == 't' &&
		   p->dir_n[2] == 'y' &&
		   p->dir_n[4] == 0 &&
		   p->dir_n[3] != 0) {
			if(stat(p->dir_n, sbuf) < 0)
				continue;
			devc[c] = p->dir_n[3];
			devl[c] = sbuf->iaddr[0];
			c++;
			continue;
		}
		if(swap >= 0)
			continue;
		if(stat(p->dir_n, sbuf) < 0)
			continue;
		if((sbuf->iflags & 060000) != 060000)
			continue;
		if(sbuf->iaddr[0] == nl[1].value)
			swap = open(p->dir_n, 0);
	}
	goto loop;
}

setup(p, s)
char *p, *s;
{
	while (*p++ = *s++);
}

prcom(i)
{
	int baddr, laddr, mf;
	register int *ip;
	register char *cp, *cp1;
	int c, nbad;
	int ti;

	baddr = 0;
	laddr = 0;
	if (proc[i].p_flag&SLOAD) {
		laddr = proc[i].p_addr;
		mf = mem;
	} else {
		baddr = proc[i].p_addr;
		mf = swap;
	}
	laddr =+ proc[i].p_size - 8;
	baddr =+ laddr>>3;
	laddr = (laddr&07)<<6;
	seek(mf, baddr, 3);
	seek(mf, laddr, 1);
	if(read(mf, stbuf, 512) != 512)
		return(0);
	for (ip = &stbuf[256]; ip > &stbuf[0];) {
		if (*--ip == -1) {
			cp = ip+1;
			if (*cp==0)
				cp++;
			nbad = 0;
			for (cp1 = cp; cp1 < &stbuf[256]; cp1++) {
				c = *cp1;
				if (c==0)
					*cp1 = ' ';
				else if (c < ' ' || c > 0176) {
					if (++nbad >= 5) {
						*cp1++ = ' ';
						break;
					}
					*cp1 = '?';
				}
			}
			while (*--cp1==' ')
				*cp1 = 0;
			printf(lflg?" %.16s":" %.64s", cp);
			return(1);
		}
	}
	return(0);
}

done()
{

	fflush(obuf);
	exit();
}

putchar(c)
{

	putc(c, obuf);
}
#endif
