#include	"link.h"
char	*fortlib	"/lib/f4";
char	*digits		"0123456789";

main(argc,argv)
int	argc;
char	*argv[];
{
	register int i,j;
	register char *p;
	char *np,c;


	/* establish free core */

	memhigh = (memlow = sbrk(GOBBLE)) + GOBBLE;
	if(memlow == -1)
		ferror("Core exceeded.");


	/* treat initial switches */

	for(i=1;i<argc;i++) {
		p = argv[i];
		if(*p++ != '-')
			break;
		j = *p++;
		j =+ *p++<<8;

		switch(j) {
		
		case 'ls':	flags =| LS;
				break;
		case 'wr':	flags =| WR;
				break;
		case 'no':	flags =| NO;
				break;
		case 'p1':	flags =| P1;
				flags =& ~ID;
				break;
		case 'ns':	flags =| NS;
				break;
		case 'go':	flags =| GO;
				break;
		case 'o=':	objyes = p;
				break;
		case 'm=':	mapyes = p;
				flags =| LS;
				break;
		case 'cr':	flags =| CR | LS;
				crefstr = p;
				break;
		case 'id':	flags =| ID;
				flags =& ~P1;
				break;
		case 'nl':	flags =| NL;
				break;
		default:	goto out;

		}
	}


	/* stash rest of args */

out:
	filec = argc - i;
	filev = &argv[i];
	for(i = 0; i < filec; i++) 
		if(*filev[i] != '-') {
			firstfile = filev[i];
			break;
		}
	if(firstfile == NIL)
		exit(0);


	list_init();
	/* linker proper */

	pass1();
	pass2();
	load_map();
	flush();

	/*
	 *	if cross reference, close pipe to cref-er,
	 * then wait for it to complete
	 */

	if(flags&CR) {
		close(crfile);
		wait(&crfile);
	}

	if(errcnt) {
		if(flags & LS) {
			printf("Errors detected: %d\n",errcnt);
			flush();
			close(fout);
		}
		fout = 2;
		printf("Errors detected: %d\n",errcnt);
	}
	flush();
	exit(errcnt != 0);
}


list_init()
{
	register int outchan;
	register int i;
	int pargs[2];
	char *ss1,*ss2;

	ss1 = "x";
	ss2 = "x";

	fout = 1;
	if(flags&LS) {
		outchan = mapyes ? (*mapyes ? creat(mapyes,0644) : dup(1) ) : creat(ext(firstfile,".map"),0644);
		if(outchan == -1)
			ferror("Cannot create map file.");
		fout = outchan;
	}

	if(flags&CR) {
		if((i = pipe(pargs)) == -1) {
			printf("Unable to cref?\n");
			flags =& ~CR;
			return;
		}
		switch(fork()) {

		case 0:	crfile = pargs[1];
			close(pargs[0]);
			break;
		
		case -1:	
			printf("Unable to fork?\n");
			flags =& ~CR;
			return;
	
		default:
			close(pargs[1]);
			*ss1 = digits[pargs[0]];
			*ss2 = digits[outchan];
			execl("/usr/bin/crefer","-",crefstr,ss1,ss2,0);
			exit(2);
		}
	}
}

char *ext(s1,s2)
char *s1,*s2;
{
	register char *r1,*r2,*r3;
	static char ss[60];
	char *w;

	w = NIL; r1 = s1; r2 = s2; r3 = ss;
	while(*r3 = *r1++) {
		if(*r3 == '/') w = NIL;
		if(*r3++ == '.') w = r3;
	}
	if(w) {r3 = w; --r3;}
	while(*r3++ = *r2++);
	return(ss);
}
ferror(s)
char *s;
{
	flush();
	close(fout);
	fout = 2;
	printf("%s\n",s);
	flush();
	exit(1);
}

/* pass 1 -
 *	read in all files, analyzing only the GSD sections
 *	set up library searches
 *	At the end of the pass, address are assigned.
 *	Also, since overlays are not implemented, the
 *	gbl/lcl distinction is ignored
 */

pass1()
{
	register int t;
	register *rr1,*rr2;
	int	libflag;
	int	radbuf[2];
	int	islib;


	libpnt = libuse;
	libflag = 0;
	islib = 0;

	init_in();

	while(t=getrec())
	switch(t) {

	/* end of gsd.  skip file to EMOD,  and reset library flag */
	case ESD:
		slewto(EMOD);
		libflag = 0;
		break;

	/* library indicator. the remainder of the record is a list of
 	 * radix 50 names which this module claims to declare. If any of
	 * them are undefined,  the module is read in. Otherwise, it is
	 * skipped. 
	 */

	case LMOD:
		libflag++;
		islib++;
		while(t=movbyte(radbuf,4)) {
			rr2 = gsearch(radbuf);
			if(rr2 != NIL && (rr2->gflags&(DEF|EXC)) == 0)
				break;
		}
		if(t==0)
			break;
		libflag = 0;
		*libpnt++ = 1;
		slewto(GSD);

	/* fall through to GSD processor.  This is the main job during
	 * this pass. Each module has a string of psects which it
	 * declares. Each of these has a low limit and high limit for
	 * relocation purposes during pass ; right now the low-limit 
	 * is set to the offset from the start of the base psect,
	 * and the high limit to the size of the psect (in bytes).
	 * Each psect also has an associated string of global symbols
	 * which it declares. A list of undefined globals is also
	 * set up for library search.  Perhaps this list will eventually
	 * be optimized for a better search.
	 */

	case GSD:
		if(libflag) {
			libflag = 0;
			slewto(EMOD);
			*libpnt++ = 0;
			break;
		}

		while((t=getgsd())>=0)
		switch(t) {

		case MDN:
			rr1 = getcore(SMOD);
			if(curmod == NIL)
				curmod = modhead = rr1;
			else
				curmod->mpnt = rr1;
			curmod = rr1;

			rr1->mname[0] = gsdent.nm[0]; rr1->mname[1] = gsdent.nm[1];
			rr1->mversion[0] = 0; rr1->mversion[1] = 0;
			rr1->mislib = islib;
			islib = 0;
			break;

		case PVI:
			curmod->mversion[0] = gsdent.nm[0];
			curmod->mversion[1] = gsdent.nm[1];
			break;

		case CSN:
			if(gsdent.fbyte & REL) {
				if(gsdent.nm[0] == 0)
					gsdent.fbyte = DEF | REL;
				else
					gsdent.fbyte = DEF | REL | OVR | GBL;
			} else
				gsdent.fbyte = DEF | OVR | GBL;

			/* the default attributes have been set up.
			 * Now fall through & treat it as a psect
			 */

		case PSN:
			rr1 = psearch(gsdent.nm);
			if(rr1 == NIL) {
				rr1 = getcore(SPSECT);
				rr1->pname[0] = gsdent.nm[0];
				rr1->pname[1] = gsdent.nm[1];
				rr1->pflags = gsdent.fbyte & 0377;
				if(psecttail == NIL)
					psecthead = rr1;
				else
					psecttail->ppnt = rr1;
				psecttail = rr1;
			}
			
			/* check for name already existing. If it is
			 * found, just fix length 
			 */
	
			for(rr2 = curmod->mpsl;rr2 != NIL;rr2 = rr2->pll)
				if(rr2->plp == rr1 ) 
					goto psn1;
	
			rr2 = curmod->mpsl;

			if(rr2 == NIL)
				rr2 = curmod->mpsl = getcore(SPSL);
			else {
				while(rr2->pll != NIL )
					rr2 = rr2->pll;
				rr2 = rr2->pll = getcore(SPSL);
			}
			rr2->plp = rr1;
		psn1:	if(rr1->pflags & OVR) {
				rr2->llimlow = 0;
				rr1->plimlow = max(rr1->plimlow,gsdent.val);
			} else {
				rr2->llimlow = rr1->plimlow;
				rr1->plimlow =+ gsdent.val;
			}
			if((rr1->pflags & BSS) && !(gsdent.fbyte & BSS))
				rr1->pflags =& ~BSS;
			rr1->pflags =| (gsdent.fbyte & COM);
			rr2->llimhigh = gsdent.val;
			cursec = rr2;
			break;


		case GSN:
			rr2 = getglo(gsdent.nm);
			if( !(gsdent.fbyte & DEF)) {
				crefout(gsdent.nm,0);
				break;
			}
			if(rr2->gflags & DEF)
				if(!(gsdent.fbyte & COM)) if(
				(rr2->gpsectl->plp != cursec->plp ||
				 (rr2->gflags & REL) != (gsdent.fbyte & REL) ||
				 (rr2->gflags & REL) ?
					rr2->gvalue + rr2->gpsectl->llimlow != gsdent.val + cursec->llimlow :
					rr2->gvalue != gsdent.val)) {
				printf("Mult. def : <");
				radout(gsdent.nm);
				printf("> in <");
				radout(cursec->plp->pname);
				printf("> in <");
				radout(curmod->mname);
				printf(">\n");
				errcnt++;
				break;		/* ignore it */
			}
			if((rr2->gflags & DEF) && (gsdent.fbyte & COM))
				break;
			crefout(gsdent.nm,1);
			rr2->gflags = gsdent.fbyte & 0377;
			rr2->gvalue = gsdent.val;
			rr2->gpsectl = cursec;
			(rr1 = getcore(SPSL))->gglp = cursec->plg;
			cursec->plg = rr1;
			rr1->glp = rr2;
		
		}	/* end of GSD type switch */
	}		/* end of RECORD type switch */

	/* a pass is now made through core resident
	 * data to define all addresses
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt) {
		if((rr1->pflags & COM) && getglo(rr1->pname)->gpsectl->plp != rr1) {
			rr1->pflags =| CMX;
			rr1->plimlow = 0;
		}
		if(rr1->pflags&SHR) {
			t = rr1->plimlow;
			rr1->plimlow = txtsize;
			txtsize = (txtsize + t +1) &~1;
			rr1->plimhigh = txtsize;
		}
	}

	/* if there is no shareable segment,  the
	 * data segment begins at zero.  If the P1
	 * option is in effect,  the shr segment is
	 * really private,  and is immediately followed
	 * by data. Otherwise, the data segment is rounded
	 * up to the next 8K byte boundary
	 */

	if((flags&P1) || txtsize == 0)
		datstart = txtsize;
	else
		datstart = (txtsize + 017777) & ~017777;
	if(flags & ID)
		datstart = 0;

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags&(BSS|SHR|REL))==REL) {
			t = rr1->plimlow;
			rr1->plimlow = datstart + datsize;
			datsize = (datsize + t + 1)&~1;
			rr1->plimhigh = datstart + datsize;
		}

	bssstart = datstart + datsize;

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags)&BSS) {
			t = rr1->plimlow;
			rr1->plimlow = bssstart + bsssize;
			bsssize = (bsssize + t + 1)&~1;
			rr1->plimhigh = bssstart + bsssize;
		}

	/* Now the psectl list is searched,  and the sub-psects
	 * are relocated.  Also,  absolute values are given
	 * to all relocatable global symbols
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if(rr1->pflags & CMX) {
			rr2 = getglo(rr1->pname);
			rr1->pflags = (rr2->gpsectl->plp->pflags & (SHR|INS|BSS|DEF|REL)) | OVR | COM;
			rr1->plimhigh = rr1->plimlow = rr1->gflags & REL ?
				rr1->gvalue + rr1->gpsectl->llimlow :
				rr1->gvalue;
		}
	for(t = modhead; t != NIL; t = t->mpnt)
		for(rr2 = t->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr2->llimlow =+ rr2->plp->plimlow;
			rr2->llimhigh =+ rr2->llimlow;
			for(rr1 = rr2->plg; rr1 != NIL; rr1 = rr1->gglp)
				if(rr1->glp->gflags&REL)
					rr1->glp->gvalue =+ rr2->llimlow;
		}

	radixin("end", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = bssstart + bsssize;
		rr1->gflags =| DEF;
	}
	radixin("etext", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = txtsize;
		rr1->gflags =| DEF;
	}
	radixin("edata", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = datstart + datsize;
		rr1->gflags =| DEF;
	}
}			/* end of pass1 */

radout(p)
int *p;
{
	char rasc[6];
	radcon(p,rasc);
	printf("%.6s",rasc);
}

max(a1,a2)
char *a1,*a2;
{
	return(a1 > a2 ? a1 : a2);
}
radixin(s,p)
char *s;
int *p;
{
	register int r50,cc;
	register char c;
	int w;
	w = 2;
	do {
		r50 = 0;
		cc = 3;
		do {
			if(c = *s)
				s++;
			r50 =* 050;
			if(c == ' ' || c == 0)
				continue;
			if(c >= 'a' && c <= 'z') {
				r50 =+ c - 'a' + 1;
				continue;
			}
			if(c == '$') {
				r50 =+ 27;
				continue;
			}
			if(c == '.') {
				r50 =+ 28;
				continue;
			}
			r50 =+ c - '0' + 30;
		} while(--cc);
		*p++ = r50;
	} while(--w);
}


char *getcore(n)
int n;
{
	register char *w;
	while(memhigh - memlow <= n) {
		if(sbrk(GOBBLE) == -1)
			ferror("Core exceeded.");
		memhigh =+ GOBBLE;
	}
	w = memlow;
	memlow =+ n;
	return(w);
}



/* initialize input; called from both passes */

init_in()
{
	wfile = 0;
	opn_next();
}


getgsd()
{
	if(movbyte(&gsdent,sizeof gsdent))
		return(gsdent.gtype);
	return(-1);
}



struct psect *psearch(s)
int *s;
{
	register struct psect *rp;
	for(rp = psecthead; rp != NIL; rp = rp->ppnt)
		if(rp->pname[0] == s[0] && rp->pname[1] == s[1])
			return(rp);
	return(NIL);
}

load_map()
{
	register char *rr1,*rr2,*rr3;
	int ff, fg, tvec[2];

	if((flags&LS) == 0)
		return;

	time(tvec);
	printf("\n\nLoad map UNIX linker	%s\n",ctime(tvec));
	if(flags & ID)
		printf("I/D space separated\n");
	else if((flags&P1)|| (txtsize==0))
		printf("No shareable segment\n");

	printf("text limit: %6o",txtsize);
	if((flags & ID) == 0)
		printf(" (%6o)",datstart);
	printf("\n");
	printf("%s%6o\n%s%6o\n\n",
		"data limit: ",bssstart,
		"bss  limit: ",bssstart+bsssize);


	for(rr1 = modhead; rr1 != NIL; rr1 = rr1->mpnt) 
	if(((flags&NL)==0) || (rr1->mislib == 0)) {
		printf("**********\nModule\t");
		radout(rr1->mname);
		putchar('\t');
		radout(rr1->mversion);
		putchar('\n');
		printf("Section\t\tAddress\tSize\n");
		for(rr2 = rr1->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr3 = rr2->plp;
			putchar('<');
			radout(rr3->pname);
			printf(">\t%6o\t%6o\t",rr2->llimlow,rr2->llimhigh - rr2->llimlow);
			rr3 = rr3->pflags;
			printf("%s,%s,%s,%s\n",
				(rr3&SHR) ? "shr" : (rr3&BSS) ? "bss" : "prv" ,
				(rr3&REL) ? "rel" : "abs",
				(rr3&OVR) ? "ovr" : "con",
				(rr3&GBL) ? "gbl" : "lcl");
			ff = 3;
			for(rr3 = rr2->plg; rr3 != NIL; rr3 = rr3->gglp) {
				putchar('\t');
				radout(rr3->glp->gname);
				printf("\t%6o\t",rr3->glp->gvalue);
				if(--ff == 0) {
					ff = 3;
					printf("\n");
				}
			}
			if(ff != 3)
				printf("\n");
		}
	}
}


opn_next()
{
	register char *rp,*rq;
	register int j;
	char c;
	int k;
	char symnmm[6];

	objbuf.fildes = -1;
opn1:	if(wfile == filec)
		return(0);
	rp = rq = filev[wfile++];
	k = 0;
	if(*rq++ == '-') 
	switch(*rq++) {
	
	case 'f':	rp = fortlib;
			break;
	case 'e':	k = 1;
	case 'i':	if(*rq++ == ':') {
				j = 6;
				rp = symnmm;
				while(j && (c = *rq++)) {
					*rp++ = c;
					j--;
				}
				if(j)
					*rp++ = 0;
				radixin(symnmm,gsdent.nm);
				rp = getglo(gsdent.nm);
				if(k)
					rp->gflags =| EXC;
				else
					rp->gflags =& ~EXC;
				goto opn1;
			}
	default:	ferror("Bad switch");

	}

	objbuf.fildes = open(rp,0);
	if(objbuf.fildes == -1) {
		objbuf.fildes = open(ext(rp,".obj"),0);
		if(objbuf.fildes == -1) {
			printf(rp);
			ferror(" : cannot open object file.");
		}
	}
	objbuf.nonused = read(objbuf.fildes,objbuf.buff,512);
	objbuf.nxtfree = objbuf.buff;
	return(1);
}
crefout(name,flag)
int	*name;
{
	register int *r1;
	int crstuff[5];

	if( (flags&CR) && ( ((flags&NL)==0) || (curmod->mislib==0 ))) {
		r1 = crstuff;
		*r1++ = name[0];
		*r1++ = name[1];
		*r1++ = curmod->mname[0];
		*r1++ = curmod->mname[1];
		*r1 = flag;
		write(crfile, crstuff, 10);
	}
}
