/*
 * UNIX FORTRAN/MACRO linker
 *
 * J. N. Rottman, May 1975
 * Extensions and changes, J. Day,  July 1975
 */
#define	BINSIZ	124
#define	GOBBLE	2048

/* flag definitions */

#define	SHR	01
#define	INS	02
#define	BSS	04
#define	DEF	010
#define	REL	040
#define	OVR	020
#define	GBL	0100
#define	COM	0200
#define	EXC	0400
#define	URF	01000
#define	CMX	02000

/* dynamic structures */

struct	global	{
	char	*gname[2];
	int	gflags;
	char	*gvalue;
	struct	global	*gright;
	struct	global	*gleft;
	char	*gpsectl;
};

struct	globall	{
	struct	global	*glp;
	struct	globall	*gglp;
};

struct	psect	{
	char	*pname[2];
	int	pflags;
	char	*plimlow;
	char	*plimhigh;
	struct	psect	*ppnt;
};

struct	psectl	{
	char	*llimlow;
	char	*llimhigh;
	struct	psect	*plp;
	struct	psectl	*pll;
	struct	globall	*plg;
};

struct	module	{
	char	*mname[2];
	char	*mversion[2];
	struct	psectl	*mpsl;
	struct	module	*mpnt;
	int	mislib;
};

struct	gsdent	{
	char	*nm[2];
	char	fbyte;
	char	gtype;
	int	val;
} gsdent;

char	*txtsize;
char	*datstart;
char	*datsize;
char	*bssstart;
char	*bsssize;


#define	SGLOB	14
#define	SGLOBL	4
#define	SPSECT	12
#define	SPSL	10
#define	SMOD	14
#define	NIL	0


char	libuse[512];		/*number of library modules */
char	*libpnt;

/* module information */

struct	psectl	*pcorres[256];
struct	module	*curmod	;
struct	psectl	*cursec	;

/* list heads */

struct	module	*modhead	;
struct	psect	*psecthead	;
struct	psect	*psecttail	;
struct	global	*globalhead	;

/* memory management */

char	*memlow;
char	*memhigh;

/* file stuff */

int	fout;			/*formatted output */
int	crfile;			/* global crossref descriptor */
int	errcnt	;

struct	buf	{
	int	fildes;	
	int	nonused;
	char	*nxtfree;
	char	buff[512];
};
int	filec;
char	**filev;

/* switch word and definitions */

int	flags	;
int	bytflg;
char	*mapyes;
char	*objyes;
char	*fortlib;
char	*firstfile;
char	*crefstr;

#define	LS	01
#define	NO	02
#define	P1	04
#define	NS	010
#define	GO	020
#define CR	040
#define	ID	0100
#define	NL	0200
#define	WR	0400

/* module types */

#define	GSD	01
#define	ESD	02
#define	TXT	03
#define	RLD	04
#define	ISD	05
#define	EMOD	06
#define	LMOD	07
#define	PSD	017
#define	SDR	022
#define	EDR	021


/* gsd types */

#define	MDN	0
#define	CSN	1
#define	ISN	2
#define	TRA	3
#define	GSN	4
#define	PSN	5
#define	PVI	6


struct	buf	objbuf;
int	wfile;
int	bcount;
char	binbuf[BINSIZ];
char	*bpoint;

/*	pass2 - produce UNIX load image from object files.
 */

int	objout;			/* file token*/
int	load_addr;		/* load address from TXT block */
int	rldcount;		/* number of bytes in TXT */
int	text_act;		/* flag that text buffer is full */
struct	psectl	*act_sec;	/* pointer to section where load is active */
int symovr;			/* symbol table has overflowed */

struct	module	*whmod;
char	rldbuf[BINSIZ];
int	symcount;



/* the following code is dedicated to harvard */

int	oprbuf[100];
struct	control	{
	struct	psectl	*consec;
	int	conloc;
	int	cnm[2];
} control;

struct	clcsym	{
	int	raw[2];
	int	symval;
} clcsym;

#define	CCOPR	040
#define	CCNAM	020
#define	CCSEC	010
#define	CCVAL	04
#define	CCDSP	02
#define	RBYTE	0200

