#

/*
 *	WINDOW VIEWPORT MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

viewpin(xc, yc,xs, ys)
	double xc,yc, xs, ys;
	{
	register i, x0, slope;
	int y0;

	if(xc-xs >= Givxmin && xc+xs <= Givxmax && yc-ys >= Givymin
				&& yc+ys <= Givymax)
		{
		if(Gvx_right < Gvy_top)
			{
			y0 = (Gvy_top-Gvx_right)/2;
			x0 = 0;
			slope = Gvx_right;
			}
		   else
			{
			y0 = 0;
			x0 = (Gvx_right-Gvy_top)/2;
			slope = Gvy_top;
			}
		Gvcx = xc*slope+x0;
		Gvcy = yc*slope+y0;
		Gvsx = xs*slope;
		Gvsy = ys*slope;
		Gwv_const();
		}
	   else
		return(Gerror(INVAL_VIEW, (i = xc), (i = yc), (i = xs), (i = ys)));
	GOOD_RETURN;
	}
