#include <gops.h>
#define GT40	GT40	/* stand-alone version */
#define HZ	50	/* line frequency */
#define GRATE	40	/* gate rate */
#define KICKSPEED	4
#define TIME 180
#define BLINK_TIME	100
#define VX0	9
#define VY0	2
#define XMIN	10
#define XMAX	850
#define YMIN	100
#define YMAX	900
int junk[7];	/* used by `define' */ 
int b[][2] { /* Curtesy of Beer-Sheba Univ. */ 
	0, 0, 0, 1, -1, 0, 0, -1, 0, -1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1,
	-1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 1, 0, 1, 0,
	1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, -1, 0, -1, 0, -1, 0, -1, 0,
	-1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 1, 0, 1, 0, 1, 0,
	1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, -2, 1, -1, 0, -1, 0,
	-3, -3, 0, -1, 0, -1, 3, -3, 1, 0, 1, 0, 3, 3, 0, 1, 0, 1 };
int f[5][3] {
	-840, 0, 1, 0, 350, 1, 0, 100, 0, 0, 350, 1, 840, 0, 1 };
int k[4][3] {
	0, -100, 1, 8, 0, 1, 0, 100, 1, -8, 0, 1 };
int kicker[][3] {
	-3, -8, 1, 6, 0, 0, -3, 8, 1, 0, 15, 1, -5, -5, 0,
	10, 0, 1 };
struct point {
	int x;
	int y;
};
int men1, menreset, menstop, g1, g2;
int left, ball, handle, clock, keeper, kick, keepstep;
int gate, easy, endseg;
int player 1;
int hor_move 1;
int aim 1;
int gflag 0;	/* 1 after a score. */ 
char pts[2], cnt[2];
struct point pball, vball, pkeep, vkeep;

int vx0[] { VX0, 8, 10, 14 };
int rvx0[] { VX0, 14, 20, 25 };
int vy0[] { -VY0, -6, -11, -14 };
int rvy0[] { VY0, 6, 11, 14 };
int x0[] { 400, 200, 250, 400 };
int rx0[] { 400, 500, 650, 775 };
int keepv[] { 7, 7, 6, 5 };

main() {
	register tim, sec;
#ifdef GT40
	extern tbuf[2];
	junk[0] = tbuf[0];
#endif
	gsinit(2048);
#ifndef GT40
	time(junk);
#endif
	srand(junk[0]);
	/* init */ 
once_more:

	/* run */ 
	reset();
	gflag = 0;
	sec = TIME;
	score(0);
	for(tim = 0; sec >= 0; tim++) {
		vtwait();
		left = (pball.x < pkeep.x+4);
		if(tim%HZ == 0) {
			chgno(clock, sec--);
		}
		if(tim%GRATE == 0) {
			chgln(g1, 0, --gate);
			chgln(g2, 0, -gate);
		}
		if(menuhit(menreset))
			goto once_more;
		movkeep();
		if(gflag) {
			gflag = (gflag+1)%HZ;
			trans(KICKSPEED, 0, kick);
			if(gflag == 0) {
				invis(kick);
				visibl(ball);
			}
		}
		else
			movbal();
	}
	visibl(endseg);
	while(!menuhit(menreset))
		vtwait();
	goto once_more;
}
reset() {
	register char *m;
	blank();
	handle = square(900, 30, 121, 200, 3, VIS|LPON|INT7);
	m = "very easy\neasy\ndifficult\nvery difficult\nkick\nno kick\n1 dim\n2 dim\naim\nno aim\nstart";
	men1 = menu(m, 200, 800, VIS);
	menreset = menu("RESET", 0, 1000, 0);
	menstop = menu("STOP", 900, 900, VIS);
	clock = number(TIME, YMAX, 970, VIS);
	cnt[0] = -1;
	cnt[1] = 0;
	pts[0] = number(0, 10, 910, VIS);
	pts[1] = number(0, 700, 910, VIS);
	pkeep.x = 800;
	pkeep.y = 450;
	ball = disply(define(junk, 0, 0, b, 61, 0, 0), 0, 0, INV|INT3);
	keeper = disply(define(junk, k, 4, 0, 0, 0, 0), pkeep.x, pkeep.y, VIS);
	disply(define(junk, f, 5, 0, 0, 0, 0), XMAX, YMIN, VIS);
	gate = 360;
	g1 = line(XMAX, YMIN, 0, gate, VIS);
	g2 = line(XMAX, YMAX, 0, -gate, VIS);
	kick = disply(define(junk, kicker, 6, 0, 0, 0), 0, 0, INV);
	endseg = text("E N D", XMAX/2-30, YMAX/2, NOITAL);
noo_kvar:	/* Thats a label in hebrew */
	vtwait();
	if(menuhit(menstop))
		exit();
	switch(m = menuhit(men1)) {
	case 1:
	case 2:
	case 3:
	case 4:
		easy = m-1;
		break;
	case 5:
		player = 1;
		break;
	case 6:
		player = 0;
		break;
	case 7:
		hor_move = 0;
		break;
	case 8:
		hor_move = 1;
		break;
	case 9:
		aim = 1;
		break;
	case 10:
		aim = 0;
		break;
	case 11:
		keepstep = keepv[easy];
		invis(men1);
		invis(menstop);
		visibl(menreset);
		return;
	}
	goto noo_kvar;
}
movkeep() {
	register step, lasty, lastx;
	int lpx, lpy;
	lasty = pkeep.y;
	if(seghit(handle, &lpx, &lpy)) {
		step = (lpy-130)/keepstep;
		pkeep.y =+ step;
		if(pkeep.y > 900)
			pkeep.y = 900;
		else if(pkeep.y < 200)
			pkeep.y = 200;
		vkeep.y = pkeep.y-lasty;
		if(hor_move) {
			step = (lpx-961)/keepstep;
			lastx = pkeep.x;
			if((pkeep.x =+ step) > 800)
				pkeep.x = 800;
			else if(pkeep.x < 100)
				pkeep.x = 100;
			vkeep.x = pkeep.x-lastx;
		}
		moveto(keeper, pkeep.x, pkeep.y);
		return;
	}
	vkeep.x = vkeep.y = 0;
}
movbal() {
	register x, y, lf;
	x = pball.x+vball.x;
	y = pball.y+vball.y;
	if(y <= YMIN) {
		vball.y = -vball.y;
		y = YMIN;
	}
	else if(y >= YMAX) {
		vball.y = -vball.y;
		y = YMAX;
	}
	if(x <= XMIN) {
		if(450 < y && y < 550) {
			score(0);
			return;
		}
		vball.x = -vball.x;
		x = XMIN;
	}
	else if(x > XMAX) {
		if(y > YMIN+gate && y < YMAX-gate) {
			score(1);
			return;
		}
		vball.x = -vball.x;
		x = XMAX;
	}
	lf = (x < pkeep.x+4);
	if(lf != left) {
		if(y <= pkeep.y && y >= pkeep.y-100) {
			x = pkeep.x+4+(2-4*left);
			if(vball.x*vkeep.x <= 0)
				vball.x = -vball.x+vkeep.x/4;
			else if(abs(vkeep.x) > abs(vball.x))
				vball.x = vkeep.x+(vkeep.x < 0?-1:1);
			else
				vball.x = -vball.x+vkeep.x*3/5;
			vball.y =+ (vkeep.y/5);
		}
	}
	moveto(ball, x, y);
	pball.x = x;
	pball.y = y;
}
score(who) {
	register i, r1, r2;
	int j;
	gflag++;
	chgno(pts[who], ++cnt[who]);
	pball.y = random(YMIN+50, YMAX-50);
	i = easy;
	pball.x = random(x0[i], rx0[i]);
	vball.x = random(vx0[i], rvx0[i]);
	if(aim == 0)
		vball.y = random(vy0[i], rvy0[i]);
	else {
		r1 = (vball.x*(YMIN+gate-pball.y))/(XMAX-pball.x);
		r2 = (vball.x*(YMAX-gate-pball.y))/(XMAX-pball.x);
		vball.y = random(r1, r2);
	}
	j = abs(vball.y);
	if(easy == 3 && aim == 0)
		vball.y = (j < 8?8:j)*(vball.y < 0?-1:1);
	if(j > rvy0[i]+4)
		vball.y = (rvy0[i]+4)*(vball.y < 0?-1:1);
	moveto(kick, pball.x-KICKSPEED*HZ, pball.y);
	invis(ball);
	moveto(ball, pball.x, pball.y);
	if(player)
		visibl(kick);
}
#define NHITS 10	/* no. of menu hits required */
menuhit(menid) {
	register i, id;
	if((id = menhit(menid, M_NBLK)) == 0)
		return(0);
	for(i = 0; i < NHITS-2; i++) {
		vtwait();
		if(menhit(menid, M_NBLK) != id)
			return(0);
	}
	vtwait();
	if((i = menhit(menid, 0)) == id)
		sleep(BLINK_TIME/HZ);
	menhit(menid, M_UBLK);
	return(i == id?id:0);
}
random(rmin, rmax) {
	return(rmin+(rand()>>3)%(rmax-rmin+1));
}
