#

	/*
	 *	PLAYBACK COMMAND INTERPRETER
	 *		Accepts commands and shoves them down a pipe
	 *		to the playback program.
	 *	pcomm [-b] [-t] playfilename
	 *		-b gives you large buffer space in the playback process,
	 *		while -t gives you tiny space.
	 */


#define TPLAYBACK "/mnt/bill/play/tplay"
#define LPLAYBACK "/mnt/bill/play/lplay"
#define BPLAYBACK "/mnt/bill/play/bplay"
#define MSIG 15

int comm[2];
int retcomm[2];
char cbuf[30];

main(argc, argv)
	int argc;
	char *argv[];
	{
	register c, nchars;
	register i;
	char c1;
	int pb;
	int little;

	if(argc < 2)
		{
		printf("arg count\n");
		exit();
		}
	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'b' && argv[1][2] == '\0')
		little = 0;
	   else
		if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 't' && argv[1][2] == '\0')
			little = 1;
		   else
			little = 2;
	if(pipe(comm) < 0)
		{
		printf("no pipes\n");
		exit();
		}
	if(pipe(retcomm) < 0)
		{
		printf("no pipes\n");
		exit();
		}
	if((pb = fork()) < 0)
		{
		printf("can't fork\n");
		exit();
		}
	if(pb == 0)
		{
		close(0);
		dup(comm[0]);
		close(comm[0]);
		close(comm[1]);
		close(2);
		dup(retcomm[1]);
		close(retcomm[0]);
		close(retcomm[1]);
		switch(little)
			{
			case 2 :
				execl(LPLAYBACK, "playback", argv[1], 0);
				break;
			case 0 :
				execl(BPLAYBACK, "playback", argv[2], 0);
				break;
			case 1 :
				execl(TPLAYBACK, "playback", argv[2], 0);
			}
		printf("can't exec playback\n");
		exit();
		}
	close(comm[0]);
	close(retcomm[1]);
	if(read(retcomm[0],&retcomm[1],1) < 1) /* just wait for playback */
		{
		printf("PCOMM :PLAY is dead\n");
		exit();
		}
	for(;;)
		{
		c = getchar();
		c1 = getchar();
		nchars = 0;
		switch(c|(c1<<8))
			{
			case 'sf' :
				if((i = getint()) > 0)
					{
					stringf(cbuf, "sf%7d", i);
					nchars = 9;
					}
				break;
			case 'ef' :
				if((i = getint()) > 0)
					{
					stringf(cbuf, "ef%7d", i);
					nchars = 9;
					}
				break;
			case 'fp' :
				if((i = getint()) > 0)
					{
					stringf(cbuf, "fp%2d", i);
					nchars = 4;
					}
				break;
			case 'fi' :
				if((i = getint()) > 0)
					{
					stringf(cbuf, "fi%2d", i);
					nchars = 4;
					}
				break;
			case 'cf' :
			case 'fl' :
				cbuf[0] = c;
				cbuf[1] = c1;
				while((c = getchar()) != '\n')
					if(c == 'o')
						cbuf[2] = 'o';
					   else
						cbuf[2] = 'n';
				nchars = 3;
				break;
			case 'sn' :
			case 'co' :
			case 'st' :
			case 'sp' :
				nchars = 2;
				cbuf[0] = c;
				cbuf[1] = c1;
				while(getchar() != '\n');
				break;
			case 'qu' :
				kill(pb, 9);
				exit();
			default :
				printf("invalid arg - %c%c\n", c, c1);
				continue;
			}
		write(comm[1], cbuf, nchars);
		kill(pb, MSIG);
		if(read(retcomm[0], &retcomm[1], 1) < 1)
			{
			printf("PCOMM: play is dead\n");
			exit();
			}
		}
	}


getint()
	{
	register num;
	register char c;

	num = 0;
	for(;;)
		{
		c = getchar();
		if(!num && c == ' ')
			continue;
		if(c >= '0' && c <= '9')
			num = num*10+c-'0';
		   else
			break;
		}
	while(c != '\n')
		c = getchar();
	return(num);
	}
