#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

ink()
	{
	register err_flag;
	int arg[3];

	TAB_OPEN(ink);
	if(Gtablet.edge_vec != NULL)
		{
		free(Gtablet.edge_vec);
		free(Gtablet.bptr);
		}
	arg[0] = INK;
	arg[1] = GW;
	arg[2] = &Gevent;
	err_flag = 0;
	if(Gstty(Gtablet.fd, arg) < 0)
		err_flag++;
	if(Gdissa_ink() == ERROR)
		ERROR_RETURN;	
	Gevent.x =+ 512;
	Gevent.y =+ 512;
	if(err_flag)
		Gevent.type = -Gevent.type;
	return(&Gevent);
	}


ink_parms(mode, s_i, end, t_i)
	int mode, s_i, end, t_i;
	{

	TAB_OPEN(ink_parms);
	if(mode < EQUAL_SPACE || mode > POINT)
		return(Gerror(INK_PARMSERR, mode, s_i, end, t_i));
	Ginkmode.mode = mode;
	Ginkmode.sample_interval = s_i;
	if(end < BUTTON3 || end > TIMEO)
		return(Gerror(INK_PARMSERR, mode, s_i, end, t_i));
	Ginkmode.end_condition = end;
	if(end == TIMEO)
		Ginkmode.timeout_interval = t_i;
	activate(INKING, 0);
	GOOD_RETURN;
	}


