#


#include "../gpac.h"
#include "../error_codes.h"
#include "cv.h"

int Gfirst;
int Gdaemon;

#define ID_SPACE 0

Ginit(df_size, ink_size, num_segs, font)
	int df_size, ink_size;
	char *font;
	{
	register *addr;
	register i;
	int value;
	int fdes[2];

#ifdef	ID_SPACE
	addr = (df_size-1)<<1;
	if(*addr != 0)
		return(Gerror(INIT_ERR));
	Gfil_start = 0;
#endif
#ifndef	ID_SPACE
	if((i = alloc(df_size*2)) == -1)
	return(Gerror(INIT_ERR));
	Gfil_start = i;
#endif
	if((i = alloc(num_segs+1)) == -1)
		return(Gerror(ALLOC_ERR, "init"));
	Gpda_table = i;
	if((i = alloc((num_segs+1)*2)) == -1)
		return(Gerror(ALLOC_ERR, "init"));
	Gdepth_table = i;
	Gfil_size = df_size;
	if(pipe(fdes) < 0)
		return(Gerror(OPEN_ERR, "init", "pipe"));
	if((Gdaemon = fork()) < 0)
		return(Gerror(FORK_ERR, "init"));
	if(Gdaemon == 0)
		{
		close(0);
		dup(fdes[0]);
		close(fdes[1]);
		execl(CVSCAN, "cvscan", 0);
		}
	close(fdes[0]);
	Gdev_file = fdes[1];
	value = STANDARD_FORMAT_MAGIC_NUMBER;
	write(Gdev_file, &value, 2);
	for(i = 0; font[i] != '\0'; i++);
	i = (i+2)>>1;
	value = SET_FONT | i;
	write(Gdev_file, &value, 2);
	write(Gdev_file, font, i<<1);
	GOOD_RETURN;
	}


Gopenseg()
	{
	register strt;

	if((strt = Gget_blk()) == ERROR)
		ERROR_RETURN;
	Gcodep = Gblkptr = strt+2;
	Gblksize = *(Gcodep-1)-3;
	Ginsert_code(JUMP);
	Gcode_mode = CONTROL;
	Gq_ptr = 0;
	Gfirst++;
	return(strt+2);
	}


Gcloseseg()
	{
	register i;

	Ginsert_code(TERM);
	i = Gfil_start;
	*Gblkptr =| i;
	Gpda_table[Gcur_seg] = 0;
	Gtrimblk(Gblkptr-1, *(Gblkptr-1)-Gblksize-3);
	return(Gblkptr);
	}


Gset_nxtblk(jump_addr, addr)
	int *jump_addr;
	int addr;
	{

	*jump_addr = addr;
	}


Gnxt_seg(jump_addr)
	int *jump_addr;
	{

	return(*jump_addr);
	}


Gnxt_blk(seg_start)
	int *seg_start;
	{

	return(*seg_start);
	}


Gnewblk()
	{
	register int newblk;

	if((newblk = Gget_blk()) == ERROR)
		ERROR_RETURN;
	Ginsert_code(TERM);
	*Gblkptr =| newblk+2;
	Gcodep = Gblkptr = newblk+2;
	Gblksize = *(Gcodep-1)-3;
	Ginsert_code(JUMP);
	GOOD_RETURN;
	}


Gappendseg(this_segp, next_segp)
	struct segment *this_segp, *next_segp;
	{
	register i;

	Ginsert_code(TERM);
	i = next_segp->start_address;
	*Gblkptr =| i;
	Gset_nxtblk(this_segp->end_address, Gcur_start);
	Gtrimblk(Gblkptr-1, *(Gblkptr-1)-Gblksize-3);
	Gpda_table[Gcur_seg] =| UPDATABLE;
	return(Gblkptr);
	}


Gstart()
	{

	}


Gsave_seg()
	{

	}


Gwaitstop()
	{

	}


Gdummy_seg()
	{

	}

Gfinish()
	{
	int arg;

	arg = END_OF_DATA_COMMAND;
	write(Gdev_file, &arg, 2);
	wait(&arg);		/*  Wait for CVSCAN  */
	}


Ggencode(n)
	int n;
	{
	register struct code_queue *p;
	register num_generated;
	register i;

/*
printf("code queue\n");
printf("requested %d\n", n);
for(p = Gcode_queue; p < &Gcode_queue[CODE_Q_LEN]; p++)
	{
	printf(" %o %d %d\n", p->c_type, p->xpos, p->ypos);
	}
*/
	p = Gcode_queue;
	num_generated = 0;
	while(num_generated < n)
		{
		switch(p->c_type)
			{
			case INTENSITY :
				Garg3 = p->xpos;
				Gop = SET_VALUE;
				if(Gnext(p) > VPOINT || Gmoveto)
					Ggen2();
				break;
			case COLOUR :
				Garg4 = p->xpos;
				Gop = SET_THICK_COLOUR;
				if(Gnext(p) != LWIDTH)
					Ggen1();
				break;
			case LWIDTH :
				Gop = SET_THICK_COLOUR;
				Garg5 = p->xpos;
				if(Gnext(p) != COLOUR)
					Ggen1();
				break;
			case FILLBEGIN :
			case FILLEND :
				if(Gmake_room(1) != ERROR)
					Ginsert_code(FILL_COMMAND);
				break;
			case BPOINT :
			case VPOINT :
			case BVECTOR :
			case VECTOR :
				if(!Gfirst && (p->xpos == Gx_abs) && (p->ypos == Gy_abs))
					break;
				switch(p->c_type)
					{
					case BPOINT :
					case VPOINT :
						Gfirst = 0;
						Gmoveto++;
						Garg1 = p->xpos;
						Garg2 = p->ypos;
						if(Gnext(p) != INTENSITY)
							Ggen2();
						break;
					case BVECTOR :
						if(Gnext(p) == BVECTOR 
							&& (((p->xpos == (p+1)->xpos) && (p->xpos == Gx_abs)) 
							|| ((p->ypos == (p+1)->ypos) && (p->ypos == Gy_abs))))
								break;
						if(!Gfill)
							Gmoveto++;
						   else
							if(Gfill == 1)
								Gfill++;
						Garg1 = p->xpos;
						Garg2 = p->ypos;
						Ggen2();
						break;
					case VECTOR :
						if(Gfill == 1)
							Gfill++;
						Garg1 = p->xpos;
						Garg2 = p->ypos;
						Ggen2();
					}
			}
		num_generated++;
		p++;
		}
/*
printf("generated %d\n", num_generated);
*/
	return(num_generated);
	}


Gnext(p)
	struct code_queue *p;
	{

	if(++p >= &Gcode_queue[Gq_ptr])
		return(DUMMY_BIG_NUMBER);
	return(p->c_type);
	}


Ggen2()
	{

	if(Gmake_room(2) != ERROR)
		{
		Ginsert_code((Gmoveto<<15) | (Gop<<12) | (Garg1<<4));
		Ginsert_code((Garg3<<12) | (Garg2<<4));
		}
	Gop = NOP;
	Gx_abs = Garg1;
	Gy_abs = Garg2;
	Garg3 = 0;
	Gmoveto = 0;
	}


Ggen1()
	{

	if(Gmake_room(1) != ERROR)
		Ginsert_code((Gop<<12) | (Garg5<<8) | Garg4);
	Gop = NOP;
	}




Gsidein(code, x, y, mode)
	int code, mode;
	double x, y;
	{
	register c;
	register ix, iy;

	c = code;
	Gwv_trans(&x, &y);
	ix = x+.5;
	iy = y+.5;
	if(c&01)
		ix = Gvcx-Gvsx;
	   else
		if(c&02)
			ix = Gvcx+Gvsx;
	if(c&04)
		iy = Gvcy-Gvsy;
	   else
		if(c&010)
			iy = Gvcy+Gvsy;
/*
printf("Gsidein adds %d %d %d with code %d\n", mode, ix, iy, c);
*/
	Gadd_queue(mode, ix, iy);
	}


Gclosefill(x, y)
	double x, y;
	{

	if(Gfill++ > 1)	/*  If only one just started  */
		{
		lineto(Gfillx, Gfilly);
		Gsidein(Gregion(Gtransx_beg, Gtransy_beg), Gtransx_beg, Gtransy_beg, BVECTOR);
		}
	Gfillx = x;
	Gfilly = y;
	}
