/*
* This program plays the game of pool on the vt screen.
*
* Variables: l,l2 - lines arrays for table & balls,resp.,m - no. of balls,
*  x,y,vx,vy - locations & speeds arrays for balls (*32 for accuracy),
*  flags - bit j of flags[i] shows if balls i&j can collide.
* Graphic segments numbers: n - balls array,trk - tracker,pole - billiard
*  rod,shoot - lp sense line for trigger.
*/
int l[9][3]{-10,24,0,20,0,1,14,-14,1,0,-20,1,-14,-14,1,-20,0,1,
-14,14,1,0,20,1,14,14,1},l2[12][3]{50,0,1,0,50,1,923,0,1,0,-50,1,
50,0,1,0,-923,1,-50,0,1,0,-50,1,-923,0,1,0,50,1,-50,0,1,0,923,1},
x0[7]{512,512,464,560,416,512,608},
y0[7]{200,649,736,736,823,823,823},
x[7],y[7],vx[7],vy[7],v[7];
main(){
char flags[7];
register int i,j,m;
int ch,n[7],k,dx,dy,dx2,dy2,dxy,vxi,vxj,vyi,vyj,d2,trk,
shoot,pole,points,npoint,kg[7],km[7];
/* display graphic segments. pole,trk & shoot still invisible */
disply(define(kg,l2,12,0,0,0,0,0),0,973,063000);
define(km,l,9,0,0,&ch,3,-34);
ch = '1';
trk = disply(km,0,0,03740);
shoot = menu("STOP\nRESET\nSHOOT",60,940,03740);
pole = line(0,0,0,0,03000);
npoint = number(0,100,980,063000);
/* each ball has a different digit in ch */
for(i=0;i<7;i++){
n[i] = disply(km,x0[i],y0[i],063000);
ch++;
}
reset: for(i=0;i<7;i++){
x[i] = x0[i]<<5; y[i] = y0[i]<<5;
moveto(n[i] = n[0]+i,x0[i],y0[i]);
visibl(n[i]);
}
chgno(npoint,0);
points = 0;
for(m=7;;){/* loop until all balls are gone */
for(i=0;i<m;i++){/* reinitiate speeds  flags */
vx[i] = vy[i] = v[i] = 0;
flags[i] = 0377;
}
/* move tracker to ball 0 */
dx2 = x[0]>>5; dy2 = y[0]>>5;
moveto(trk,dx2,dy2);
moveto(pole,dx2,dy2);
moveto(shoot,dx2>512?60:820,940);
chgln(pole,0,0);
visibl(trk);
visibl(pole);
visibl(shoot);
while(lphit() == shoot);
/* move tracker,extending pole as a rubber band */
while((i = lphit(&dx,&dy))!=shoot) {
vtwait();
if(i == trk){
dx2 =+ (dx-dx2)>>3;
dy2 =+ (dy-dy2)>>3;
moveto(trk,dx2,dy2);
chgln(pole,dx2-(x[0]>>5),dy2-(y[0]>>5));
} }
while((i = menhit(shoot,-1))<3){
vtwait();
if(i && i==menhit(shoot,100))switch(i){
case 1: exit();
case 2: goto reset;
}}
invis(trk);
invis(pole);
invis(shoot);
/* ball 0 is shot relative to length & direction of pole */
vset(0,((x[0]>>5)-dx2)>>2,((y[0]>>5)-dy2)>>2);
/* loop until all balls stop */
do{ k = 0;
vtwait();
for(i=0;i<m;i++)if(v[i]){/* move all non-stationary balls  */
x[i] =+ (hmul(v[i],vx[i])<<2)+((v[i]*vx[i]>>14)&3);
y[i] =+ (hmul(v[i],vy[i])<<2)+((v[i]*vy[i]>>14)&3);
moveto(n[i],x[i]>>5,y[i]>>5);
v[i]--;
k = 1;
}
for(i=0;i<m;i++){
/* check if ball bumps in walls */
if(x[i]<768 && vx[i]<0 || (x[i]>31968 || x[i]<0) && vx[i]>0)vx[i] = -vx[i];
if(y[i]<768 && vy[i]<0 || (y[i]>31968 || y[i]<0) && vy[i]>0)vy[i] = -vy[i];
for(j = m-1;j>i;j--){
/* check distances: if balls are close,a collison; else enable flags */
dx = (x[i]-x[j])>>5;
dy = (y[i]-y[j])>>5;
if(abs(dx)<49 && abs(dy)<49 && dx*dx+dy*dy<2401){
if(flags[i]&(1<<j)||flags[j]&(1<<i)){
dx2 = dx*dx; dy2 = dy*dy;
d2 = dx2+dy2;
dxy = dx*dy;
vxi = hmul(v[i],vx[i])>>3;
vyi = hmul(v[i],vy[i])>>3;
vxj = hmul(v[j],vx[j])>>3;
vyj = hmul(v[j],vy[j])>>3;
vx[i] = dx2*vxj/d2+dy2*vxi/d2-(vyi-vyj)*dxy/d2;
vy[i] = dy2*vyj/d2+dx2*vyi/d2-(vxi-vxj)*dxy/d2;
vx[j] = dx2*vxi/d2+dy2*vxj/d2-(vyj-vyi)*dxy/d2;
vy[j] = dy2*vyi/d2+dx2*vyj/d2-(vxj-vxi)*dxy/d2;
vset(i,vx[i],vy[i]);
vset(j,vx[j],vy[j]);
flags[i] =& ~(1<<j);/* disable collison flags */
flags[j] =& ~(1<<i);
}}
else{
flags[i] =| (1<<j);
flags[j] =| (1<<i);
}}
/* check if ball enters a hole */
if((x[i]<1600 || x[i]>31136) && (y[i]<1600 || y[i]>31136)){
/* if ball is not 0, delete it & increment points */
if(i){ m--;
invis(n[i]);
points =+ n[i]-n[0]+1;
for(j=i;j<6;j++){
n[j] = n[j+1];
x[j] = x[j+1];
y[j] = y[j+1];
v[j] = v[j+1];
vx[j] = vx[j+1];
vy[j] = vy[j+1];
flags[j] = flags[j+1];
}}
else {/* if ball 0,return it to game & decrement points */
x[0] = 16384; y[0] = 6400;
vx[0] = vy[0] = v[0] = 0;
moveto(n[0],x[0]>>5,y[0]>>5);
points =- 1;
}
chgno(npoint,points);/* update points counter */
}}}
while(k);
}
}
isqr(aa){
register a,t1,t2;
a = aa;
t2 = a/2;
if(t2<1)return(a);
do{ t1 = t2;
t2 = (t1+a/t1+1)/2;
}while(t1!=t2);
return(t1);
}
vset(i,vxi,vyi){
register j,vxj,vyj;
j = i;vxj = vxi;vyj = vyi;
v[j] = isqr(vxj*vxj+vyj*vyj);
if(v[j]){
vx[j] = vxj?ldiv(vxj/4,vxj<<14,v[j]):0;
vy[j] = vyj?ldiv(vyj/4,vyj<<14,v[j]):0;
v[j] =<< 5;
}else vx[j] = vy[j] = 0;
}
