#
/*
 * idle and activate system calls
 */

#include "../param.h"
#include "../user.h"
#include "../reg.h"
#include "../inode.h"
#include "../systm.h"
#include "../proc.h"

/*
 | activate sys call.	db 12/july/78
 */
activate() {
	register struct proc *p;
	register a;

	a = u.u_ar0[R0];
	if(a != u.u_procp->p_pid)
	for(p = &proc[0]; p < &proc[NPROC]; p++)
		if(a == p->p_pid) {
			if(p->p_stat == SWAIT && p->p_wchan == 0)
				setrun(p);
			return;
		}
	u.u_error = ESRCH;
}

/*
 | idle system call.	db 12/july/78
 */
sidle() {
	register struct proc *p;
	register s;

	p = u.u_procp;
	s = PS->integ;
	spl6();
	p->p_stat = SWAIT;
	p->p_wchan = 0;
	swtch();
	PS->integ = s;
}
