%token DIGIT LETTER    /* these are token names */
%left '|'             /* declarations of operator precedences */
%left '&'
%left '+' '-'
%left '*' '/' '%'
%left UMINUS   /* supplies precedence for unary minus */
%{               /* declarations used by the actions */
  int base;
  int regs[26] { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
%}

%%   /* beginning of rules section */

list   :  /* empty */
       |  list stat '\n'
       |  list error '\n'
              ={  yyerrok ; }
       ;

stat   :  expr
              ={  printf("%d\n", $1) ; }
       | LETTER '=' expr
              ={  regs[$1] = $3;}
       ;

expr   :  '(' expr ')'
              ={  $$ = $2;}
       | expr '+' expr
              ={  $$ = $1 + $3;}
       | expr '-' expr
              ={  $$ = $1 - $3;}
       | expr '*' expr
              ={  $$ = $1 * $3;}
       | expr '/' expr
              ={  $$ = $1 / $3;}
       | expr '%' expr
              ={  $$ = $1 % $3;}
       | expr '&' expr
              ={  $$ = $1 & $3;}
       | expr '|' expr
              ={  $$ = $1 | $3;}
       | '-' expr  %prec UMINUS
              ={ $$ = - $2; }
       | LETTER
              ={  $$ = regs[$1];}
       | number     
       ;

number :  DIGIT
              ={ $$ = $1;  base = ( $1==0) ? 8 : 10 ; }
       | number DIGIT
              ={ $$ = base*$1 + $2; }
       ;

%%   /* start of programs */

yylex(){ /* lexical analysis routine */
       /* returns LETTER for a lower case letter, yylval = 0 through 25 */
       /* return DIGIT for a digit, yylval = 0 through 9 */
       /* all other characters are returned immediately */

       char c;

       while( (c=getchar()) == ' ' ) ;
              /* c is now nonblank */

       if( c >= 'a' && c <= 'z' ){
              yylval = c - 'a' ;
              return ( LETTER );
              }
       if( c >= '0' && c <= '9' ){
              yylval = c-'0';
              return( DIGIT );
              }
       return( c );
       }
