/*
 *	This creation just reads raw tape file specified as
 *	first argument.  It then reports on record size etc.
 *	On double tapemark it stops.
 */ 

#include	<local-system>
#include	<stat.h>

#define	NERR	10	/* NERR consecutive errors ==> give up */

char buf[44*512];
int flag;
int err;

catch()
{
	signal(2, 1);
	flag = 1;
}

main(argc, argv)
int argc;
char **argv;
{
	register unsigned iold, i, nrec;
	int infd;
	struct statb statb;

	if(signal(2, 1) == 0)
		signal(2, catch);
	signal(3, 1);
#ifdef	BASSER
	nice(10);
#endif	BASSER
	if(argc != 2)
	{
		printf("Usage: taprd file\n");
		exit(-1);
	}
	if((infd = open(argv[1], 0)) < 0)
	{
		perror(argv[1]);
		exit(-1);
	}
	fstat(infd, &statb);
	if((statb.i_mode & IFMT) != IFCHR)
	{
		printf("%s not a raw device !!\n", argv[1]);
		exit(-1);
	}
	nrec = 0;
	iold = read(infd, buf, sizeof buf);
	for(;;)
	{
		nrec++;
		i = read(infd, buf, sizeof buf);
		if(i == iold && i == 0)
		{
			printf("\tEOT\n");
			exit(err);
		}
		if((i == iold) && (i==-1) && (nrec==NERR) )
		{
			printf("%d consecutive errors: EOT assumed\n",NERR);
			exit(-1);
		}
		if((i == iold) && !flag)
			continue;
		if(iold)
		{
			if(iold != -1)
			{
				printf("%6d. * %6o(%6d.)\n",
					nrec, iold, iold);
			}
			else
			{
				printf("%6d. *  ERR  \n", nrec);
				err++;
			}
		}
		else
		{
			printf("\tTM\n");
		}
		nrec = 0;
		iold = i;
		if(flag)
		{
			printf("Interrupted\n");
			exit(-1);
		}
	}
}
