#

/*
 * Memory allocation routines
 */

#include "gtl.h"

insert(adr, cnt)
char	*adr, *cnt;
{
	register char	*hiadr;
	register struct seg	*mp;
	char	*tmp;

	hiadr = adr + cnt;
	for (mp = &seg[0]; mp < &seg[SEGS]; mp++) {
		if (mp->m_hiadr == 0) {
			/* there is a hole sitting there waiting */
			mp->m_loadr = adr;
			mp->m_hiadr = hiadr;
			return;
		}
		if (hiadr < mp->m_loadr) {
			/* swap descriptors */
			tmp = mp->m_loadr;
			mp->m_loadr = adr;
			adr = tmp;
			tmp = mp->m_hiadr;
			mp->m_hiadr = hiadr;
			hiadr = tmp;
			continue;
		}
		if (mp->m_hiadr >= adr) {
			if (adr < mp->m_loadr)
				mp->m_loadr = adr;
			if (hiadr > mp->m_hiadr)
				/* now slide any overlapping entries down */
				mp->m_hiadr = slide(hiadr, mp);
			return;
		}
	}
	fputs("Insertion failure\n", stderr);
	exit(2);
	abort();
}

/*
 * Merge any entries if possible; and slide higher
 * entries down appropriately.
 */
slide(hi, ptr)
register char	*hi;
struct seg	*ptr;
{
	register struct seg	*mp, *mp1;

	ptr++;
	for (mp = ptr; mp < &seg[SEGS]; mp++) {
		if (mp->m_hiadr == 0)
			break;
		if (mp->m_loadr > hi)
			break;

		/* does this segment get merged? */
		if (mp->m_hiadr > hi)
			hi = mp->m_hiadr;
	}
	for (mp1 = ptr; mp < &seg[SEGS]; mp++, mp1++) {
		if (mp->m_hiadr == 0)
			break;
		/* move useful stuff down memory */
		mp1->m_loadr = mp->m_loadr;
		mp1->m_hiadr = mp->m_hiadr;
	}

	/* now clear out dropped fields */
	for (; mp1 < mp; mp1++) {
		mp1->m_loadr = 0;
		mp1->m_hiadr = 0;
	}
	return(hi);
}
