.TH XFD 1 "1 January 1986" "X Version 10"
.SH NAME
xfd - X window system font displayer
.SH SYNOPSIS
.B xfd
[ =\fIgeometry\fP ] [ \fIhost\fP:\fInumber\fP ] [ options ] fontname
.SH DESCRIPTION
.I Xfd
creates a window which displays all characters in the named font.  The
characters are displayed in increasing ASCII order, 8 to a line, from
the first to the last character defined in the font.
.PP
The font name is interpreted by the X server.  On a VAX, if the name
does not begin with ``/'', the X server adds the suffix ``.onx'' to it and
looks up the font file in the directory \fI/usr/new/lib/X/font/\fP.  If
the name does begin with ``/'', the X server treats it as an absolute
pathname of a file containing a font.
.PP
If no font name is given on the command line, 
.I xfd
displays the font ``vtsingle''.
.PP
The window stays around until the xfd process is killed  or a mouse button is pressed on the window.
.SH "OPTIONS"
.PP
.TP 8
.B \fIhost\fP:\fIdisplay\fP
Normally,
.I xfd
gets the host and display number to use from the environment
variable ``DISPLAY''.  One can, however specify them explicitly.
The
.I host
specifies which machine to create the window on, and
the
.I display
argument specifies the display number.
For example,
``orpheus:1'' creates a shell window on display one on the machine
orpheus.
.PP
.TP 8
.B \-bw \fIborderwidth\fP
Allows you to specify the width of the window border in pixels.
.TP 8
.B \-rv
The screen will be displayed with black characters on a white background,
rather than the default white on black.
.PP
.TP 8
.B \-fg \fIcolor\fP
On color displays, determines the color of the text.
.PP
.TP 8
.B \-bg \fIcolor\fP
On color displays, determines the color of the background.
.PP
.TP 8
.B \-bd \fIcolor\fP
On color displays, determines the color of the border.
.PP
.TP 8
.B \=\fIgeometry\fP
.I Xfd
will also take a standard geometry specification (see X(1)).
.SH "X DEFAULTS"
.I Xfd
uses a number of standard default values.
.PP
.TP 8
.B BorderWidth
Set the border width of the window.
.PP
.TP 8
.B BorderColor
Set the border color of the window.
.PP
.TP 8
.B ReverseVideo
If ``on'', reverse the definition of foreground and background color.
.PP
.TP 8
.B Foreground
Set the text color.
.PP
.TP 8
.B Background
Set the background color.
.SH FILES
/usr/new/lib/X/font/*.onx
.SH "SEE ALSO"
X(1), X(8C), xterm(1)
.SH ENVIRONMENT
DISPLAY	-	To find out which X you are using.
.SH BUGS
It should display the name of the font somewhere.
.SH AUTHORS
Ron Newman, MIT Project Athena,
Jim Gettys, DEC, MIT Project Athena
.br
Copyright (c) 1984, 1985 by Massachusetts Institute of Technology.
.br
See X(1) for a complete copyright notice.
