.TH XCLOCK 1 "18 August 1985" "X Version 10"
.SH NAME
xclock - X Window System, analog / digital clock
.SH SYNOPSIS
.B xclock
[ option ] ...
.SH DESCRIPTION
.I Xclock 
is the
.I X
window system clock.
.I Xclock
Continuously  displays  the  current  time of day.  The user is given a
choice of either an analog or a digital display (of  course  there  is
nothing  precluding  the  user  from  having more than one clock).  It
creates a window and displays the time in the chosen format.
.SH ARGUMENTS
.PP
.TP 10
.B \-analog 
Use analog display mode.  Draw a conventional 12 hour clock face with ``ticks''
for each minute and stroke marks on each hour.  The default is digital mode.
.PP
.TP 10
.B \-bg \fIcolor\fP
Determines the color of the background.
.PP
.TP 10
.B \-bd \fIcolor\fP
Determines the color of the border.
.PP
.TP 10
.B \-bw \fIpixels\fP
Specify the width in pixels of the border around the
.I xclock
window.
.PP
.TP 10
.B \-digital
Use  digital  display  mode  (default).   Display the date and time in
digital format.
.PP
.TP 10
.B \-fg \fIcolor\fP
Determines the color of the text in digital mode and the
tick marks in analog mode.
.PP
.TP 10
.B \-fn \fIfont\fP
The specified
.I font
will be used as the output font
in digital mode. Any fixed width font may be used, the default is ``6x10''.
.PP
.TP 10
.B \-help
Display a brief summary of
.I xclock's
calling syntax and options.
.PP
.TP 10
.B \-hl \fIcolor\fP
Determines the color of the hands in analog mode.
.PP
.TP 10
.B \-padding \fIpixels\fP
Specify the width in pixels of the padding ``white space''
between the window border and anything
.I xclock
displays.  The default padding is 10 in digital mode and 8 in analog mode.
.PP
.TP 10
.B \-rv
Cause
.I xclock
to produce all output in white-on-black instead of black-on-white.  This
is only useful on Black and White displays.
.PP
.TP 10
.B \-update \fIseconds\fP
Specify the frequency in seconds with which
.I xclock
updates its display.  If the
.I xclock
window is obscured and then exposed,
.I xclock
will override this setting  and  redisplay  immediately.   The  default
update  frequency  is  60  seconds.   The  specification  of an update
frequency greater than 30 seconds disables the display of  the  second
hand in analog mode.
.PP
.TP 8
.B =\fIgeometry\fP
The clock window is created with the specified
size according to the geometry specification.
See \fIX(1)\fP for details.
In digital mode if you do not specify either height and width they are
determined  by  the font in use.  In analog mode if you do not specify
either width or height they default to 164.  The  default  offset  for
any unspecified offset is -0.  All values are in pixels.
.PP
.TP 10
.B \fIhost\fP:\fIdisplay\fP
Normally,
.I xclock
gets  the host and display number to use from the environment variable
``DISPLAY''.  One can, however specify them explicitly.
The
.I host
specifies which machine to create the
.I xclock
window on, and
the
.I display
argument specifies the display number.
For example,
``mit-frobozz:1'' creates an
.I xclock
on display one on the machine mit-frobozz.  If the host is omitted the
local  host  is  assumed.   If  the  display  is omitted, display 0 is
assumed, the ``:'' is necessary in either case.
.SH X DEFAULTS
.PP
.PP
.TP 8
.B Background
To determine the background color.
.PP
.TP 8
.B Border
To determine the border color.
.PP
.TP 8
.B BorderWidth
To determine the border width.
.PP
.TP 8
.B BodyFont
To determine digital clock display font.
.PP
.TP 8
.B Foreground
To determine the foreground color.
.PP
.TP 8
.B Highlight
To determine the highlight color.
.PP
.TP 8
.B InternalBorder
To determine the internal padding value.
.PP
.TP 8
.B Mode
To determine if ``analog'' or ``digital'' mode is the default.
.PP
.TP 8
.B ReverseVideo
If ``on'', the clock should be white on black instead of black on white.
This is only useful on Black and White displays.
.PP
.TP 8
.B Update
To determine the update rate.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get the default host and display number.
.SH SEE ALSO
X(1), xwm(1), X(1), time(3C), select(2)
.SH AUTHORS
.PP
Copyright 1985, Massachusetts Institute of Technology.
.PP
Tony Della Fera (MIT-Athena, DEC)
.PP
Dave Mankins (MIT-Athena, BBN)
.SH BUGS
.I Xclock
believes the Unix clock.  When specifying the window size manually  in
digital  mode  the  string should be centered automatically, currently
you have to fiddle with the padding parameter to get it right.
