.TH PSCAT 1 "12 Oct 1985" "Adobe Systems"
\" RCSID: $Header: pscat.1p,v 2.1 85/11/24 12:39:12 shore Rel $
.ds PS P\s-2OST\s+2S\s-2CRIPT\s+2
.SH NAME
pscat \- convert C/A/T files to P\s-2OST\s+2S\s-2CRIPT\s+2 format
.SH SYNOPSIS
.B pscat
[
.BI \-F fonttable
] [
.BI \-i prologuefile
] [
.BI \-l paperlength
] [
.BI \-x xoffset
] [
.BI \-y yoffset
] [
.I file
]
.SH DESCRIPTION
.I pscat
converts C/A/T format
.IR file 
(i.e., as produced by the original
.RI [ o ] troff (1)),
to \*(PS format on the standard output.  If no
.I file
argument is given, the standard input is used.
The average user will probably be happy using 
.IR ptroff (1),
but explicit use of 
.I pscat
gives more control.
Page offset distances and the page length 
are specified by giving a fixed-point real number optionally 
followed by a units measure.  For example, 1in means one inch, 15mm means 
fifteen millimeters.  If no units are indicated, points (72 to the inch) 
are used.
The options are:
.TP
.BI \-F " fonttable"
specifies a font correspondence table for use by the converter.
(The default is usually
.I Times.ct
where the mounted fonts are:
.BR R =Times-Roman, 
.BR I =Times-Italic, 
.BR B =Times-Bold, 
and
.BR S =Symbol.
Note that 
.I troff
should be invoked with an appropriate 
.B \-F 
switch and explicit ``.fp''
commands.)
.TP
.BI \-i " prologuefile"
specifies a file to be incorporated as the \*(PS prologue, otherwise
the default prologue will be used (see below).
.TP
.BI \-l " pagelength"
specifies the page length to use when splitting the
C/A/T file into \*(PS pages.  The default is 11in.
.TP
.BI \-x " xoffset"
moves the output 
.I xoffset
to the right on the paper.  The default is 0.
.TP
.BI \-y " yoffset"
moves the output
.I yoffset
downward on the paper.  The default is 0.  Different versions of 
.I troff
seem to have different notions of where 
the top edge of the paper really is, so careful setting of the 
.B \-y 
switch may be necessary.
.SH ENVIRONMENT
.TP
PSLIBDIR
path name of a directory to use instead of
/usr/misc/lib/ps for pscat prologue and font metric files.
.SH FILES
.TP 2.2i
/usr/misc/lib/ps/troff.font/*.ct
character correspondence tables (built by 
.IR pscatmap (8))
mapping C/A/T codes to \*(PS fonts and characters or other actions.
.TP
/usr/misc/lib/ps/pscat.pro
default \*(PS prologue.
.SH "SEE ALSO"
ptroff(1), pscatmap(8).
.br
4.2bsd: troff(1).
.br
System V: otroff(1), \fIDocumenter's Workbench\fP.
.SH AUTHOR
Adobe Systems Incorporated
.SH BUGS
Because of the character mapping tables used, arbitrary
use of the ``.fp'' troff directive in will usually produce the
wrong results.  The 
.I family.head
files which 
.I ptroff
feeds to 
.I troff
contain ``.fp'' commands appropriate for a given font family.
Users must build and reference correct tables with
.IR pscatmap (8)
for non-standard ``.fp'' combinations to work.

Distance computations are not checked for overflow.

The mapping from the default troff fonts to 
Adobe's Times-Roman will not look good.  \*(PS font width 
tables (and ``.fp'' commands) should be used explicitly in troff.

.I pscat
determines where page breaks occur by assuming that each page is exactly
the specified length.  There is no indication of page boundaries
in the C/A/T file, so improper use of the 
.B \-l 
option will lead to undesirable results.  Some 
.IR troff 
macro packages 
generate cut-marks at logical edges of the page which may or
may not get imaged on a \*(PS device.
Careful use of the 
.B \-x 
and 
.B \-y 
options may help.
.SH NOTES
\*(PS is a trademark of Adobe Systems Incorporated.
.br
Times is a registered trademark of Allied Corporation.
.br
Documenter's Workbench is a trademark of AT&T Technologies.
