


RCS(1)              UNIX Programmer's Manual               RCS(1)



NAME
     rcs - change RCS file attributes

SYNOPSIS
     rcs [ options ] file ...

DESCRIPTION
     _R_c_s creates new RCS files or changes attributes of existing
     ones.  An RCS file contains multiple revisions of text, an
     access list, a change log, descriptive text, and some con-
     trol attributes.  For _r_c_s to work, the caller's login name
     must be on the access list, except if the access list is
     empty, the caller is the owner of the file or the superuser,
     or the -i option is present.

     Files ending in `,v' are RCS files, all others are working
     files. If a working file is given, _r_c_s tries to find the
     corresponding RCS file first in directory ./RCS and then in
     the current directory, as explained in _c_o (1).

     -i         creates and initializes a new RCS file, but does
                not deposit any revision.  If the RCS file has no
                path prefix, _r_c_s tries to place it first into the
                subdirectory ./RCS, and then into the current
                directory.  If the RCS file already exists, an
                error message is printed.

     -a_l_o_g_i_n_s   appends the login names appearing in the comma-
                separated list _l_o_g_i_n_s to the access list of the
                RCS file.

     -A_o_l_d_f_i_l_e  appends the access list of _o_l_d_f_i_l_e to the access
                list of the RCS file.

     -e[_l_o_g_i_n_s] erases the login names appearing in the comma-
                separated list _l_o_g_i_n_s from the access list of the
                RCS file.  If _l_o_g_i_n_s is omitted, the entire
                access list is erased.

     -c_s_t_r_i_n_g   sets the comment leader to _s_t_r_i_n_g. The comment
                leader is printed before every log message line
                generated by the keyword $Log$  during checkout
                (see _c_o). This is useful for programming
                languages without multi-line comments. During _r_c_s
                -_i or initial _c_i, the comment leader is guessed
                from the suffix of the working file.

     -l[_r_e_v]    locks the revision with number _r_e_v.  If a branch
                is given, the latest revision on that branch is
                locked.  If _r_e_v is omitted, the latest revision
                on the trunk is locked.  Locking prevents over-
                lapping changes.  A lock is removed with _c_i or



Printed 1/10/87              6/29/83                            1






RCS(1)              UNIX Programmer's Manual               RCS(1)



                _r_c_s -_u (see below).

     -u[_r_e_v]    unlocks the revision with number _r_e_v.  If a
                branch is given, the latest revision on that
                branch is unlocked.  If _r_e_v is omitted, the
                latest lock held by the caller is removed.  Nor-
                mally, only the locker of a revision may unlock
                it.  Somebody else unlocking a revision breaks
                the lock. This causes a mail message to be sent
                to the original locker.  The message contains a
                commentary solicited from the breaker.  The com-
                mentary is terminated with a line containing a
                single `.' or control-D.

     -L         sets locking to _s_t_r_i_c_t. Strict locking means that
                the owner of an RCS file is not exempt from lock-
                ing for checkin.  This option should be used for
                files that are shared.

     -U         sets locking to non-strict. Non-strict locking
                means that the owner of a file need not lock a
                revision for checkin. This option should NOT be
                used for files that are shared.  The default (-L
                or -U) is determined by your system administra-
                tor.

     -n_n_a_m_e[:_r_e_v]
                associates the symbolic name _n_a_m_e with the branch
                or revision _r_e_v. _R_c_s prints an error message if
                _n_a_m_e is already associated with another number.
                If _r_e_v is omitted, the symbolic name is deleted.

     -N_n_a_m_e[:_r_e_v]
                same as -n, except that it overrides a previous
                assignment of _n_a_m_e.

     -o_r_a_n_g_e    deletes ("outdates") the revisions given by
                _r_a_n_g_e.  A range consisting of a single revision
                number means that revision.  A range consisting
                of a branch number means the latest revision on
                that branch.  A range of the form _r_e_v_1-_r_e_v_2 means
                revisions _r_e_v_1 to _r_e_v_2 on the same branch, -_r_e_v
                means from the beginning of the branch containing
                _r_e_v up to and including _r_e_v, and _r_e_v- means from
                revision _r_e_v to the end of the branch containing
                _r_e_v.  None of the outdated revisions may have
                branches or locks.

     -q         quiet mode; diagnostics are not printed.

     -s_s_t_a_t_e[:_r_e_v]
                sets the state attribute of the revision _r_e_v to



Printed 1/10/87              6/29/83                            2






RCS(1)              UNIX Programmer's Manual               RCS(1)



                _s_t_a_t_e. If _r_e_v is omitted, the latest revision on
                the trunk is assumed; If _r_e_v is a branch number,
                the latest revision on that branch is assumed.
                Any identifier is acceptable for _s_t_a_t_e.  A useful
                set of states is _E_x_p (for experimental), _S_t_a_b
                (for stable), and _R_e_l (for released).  By
                default, _c_i sets the state of a revision to _E_x_p.

     -t[_t_x_t_f_i_l_e]
                writes descriptive text into the RCS file
                (deletes the existing text).  If _t_x_t_f_i_l_e is omit-
                ted, _r_c_s prompts the user for text supplied from
                the std. input, terminated with a line containing
                a single `.' or control-D.  Otherwise, the
                descriptive text is copied from the file _t_x_t_f_i_l_e.
                If the -i option is present, descriptive text is
                requested even if -t is not given.  The prompt is
                suppressed if the std. input is not a terminal.

DIAGNOSTICS
     The RCS file name and the revisions outdated are written to
     the diagnostic output.  The exit status always refers to the
     last RCS file operated upon, and is 0 if the operation was
     successful, 1 otherwise.

FILES
     The caller of the command must have read/write permission
     for the directory containing the RCS file and read permis-
     sion for the RCS file itself.  _R_c_s creates a semaphore file
     in the same directory as the RCS file to prevent simultane-
     ous update.  For changes, _r_c_s always creates a new file. On
     successful completion, _r_c_s deletes the old one and renames
     the new one.  This strategy makes links to RCS files use-
     less.

IDENTIFICATION
     Author: Walter F. Tichy, Purdue University, West Lafayette,
     IN, 47907.
     Revision Number: 3.1 ; Release Date: 83/04/04 .
     Copyright 8c9 1982 by Walter F. Tichy.

SEE ALSO
     co (1), ci (1), ident(1), rcsdiff (1), rcsintro (1),
     rcsmerge (1), rlog (1), rcsfile (5), sccstorcs (8).
     Walter F. Tichy, "Design, Implementation, and Evaluation of
     a Revision Control System," in _P_r_o_c_e_e_d_i_n_g_s _o_f _t_h_e _6_t_h _I_n_t_e_r_-
     _n_a_t_i_o_n_a_l _C_o_n_f_e_r_e_n_c_e _o_n _S_o_f_t_w_a_r_e _E_n_g_i_n_e_e_r_i_n_g, IEEE, Tokyo,
     Sept. 1982.

BUGS


Printed 1/10/87              6/29/83                            3






