
/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *  
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */
#include "gremlin.h"
#include "grem2.h"
#include <ctype.h>

extern short point_icons[2][114];
extern short brush_icons[7][114];
extern short adjust_icons[4][114];
extern icon_light[];
extern OpaqueFrame FrameList[];

extern char input_buffer[];

/* imports from graphics files */

extern GRVector(), GRArc(), GRPutText();
extern GRDisplayPoint(), GRDeletePoint(), GRBlankPoints();
extern charxsize, charysize;
extern artmode;   /* indication of point display size */

/* imports from display.c */

extern DISScreenAdd(), DISScreenErase();
extern DISDisplaySet(), DISEraseSet(), DISClearSetDisplay();

/* imports from database files */

extern ELT *DBInit(), *DBCreateElt(), *DBRead();
extern DBDelete(), DBSetGravitate(), DBGravitate(), DBClearElt();
extern ELT *DBCopy();
extern DBXform(), DBChangeBrush();
extern DBAddSet(), DBClearSet();
extern POINT *PTInit(), *PTMakePoint();
extern PTDeletePoint();

/* imports from undodb.c */

extern UNELT *unlist, *unback;
extern UNRembMod();

/* imports from short.c */

extern SHUpdate();

/* imports from c */

extern char *malloc();
extern char *strcpy(), *sprintf();

/* imports from main.c */

extern ELT *PICTURE;                /* current PICTURE database      */
extern ELT *cset;                   /* current set database          */
extern CBRUSH, CSIZE, CFONT;        /* current brush, size, font     */
extern CJUST;                       /* current text justification    */
extern Gridon;                      /* grid mode flag                */
extern Orientation;                 /* orientation of workspace      */
extern Alignment;                   /* point alignment indicator     */
extern float PX, PY;                /* cursor coordinates            */
extern float Lastx, Lasty;          /* previous cursor coordinates   */
extern SEQ;                         /* point sequence number         */
extern char *Editfile;              /* current edit file             */
extern POINT *POINTLIST, *BACKPOINT;/* accumulated point list        */
extern Adjustment;                  /* point adjustment mode         */
extern GravityOn;                   /* gravity mode flag             */
extern Consume;                     /* point clear flag              */
extern CHANGED;                     /* PICTURE changed flag          */
extern ELT *MEN[];                  /* pointers for user symbols     */
extern POINT MENPOINT[];            /* pointers used fo user symbols */
extern cmdbuf[];                    /* line buffer for commands      */
extern char *lines[], *fonts[];     /* line and character styles     */
extern int lnum[], fnum[];

extern int XChangeGrid();
/*      The following is available to the outside world */

int bang;


/*      The following are defined to allow creation of the command
 * lookup table.
 */

extern LGAlign(), LGBrush(), LGClearPoints(),  LGGripe(), LGLittlePoint(),
       LGDeletePoint(), LGEdit(), LGFont(), LGIncludeSet(), LGSize(), LGSave(),
       LGJust(), LGMenu(), LGPoint(), LGPath(), LGQuit(), LGRead(), LGHAdjust(),
       LGMBrush(), LGMFont(), LGMSize(), LGMText(), LGMPoint(), LGMirror(),
       LGVAdjust(), LGText(), LGUndo(), LGWrite(), LGOpoint(),
       LGShowPoints(), LGCSetPoints();

/* The following two arrays define the long commands and the routines
 * that process them.
 */
char *lcmds[] = {
    "align",
    "brush",
    "buffer",
    "clearpoints",
    "deletepoint",
    "edit",
    "font",
	"grid",
    "hadjust",
	"halftone",
    "includeset",
    "justificaion",
    "littlepoint",
    "mbrush",
    "mfont",
    "mirror",
    "mpoint",
    "msize",
    "mtext",
    "path",
    "point",
    "quit",
    "read",
    "size",
    "saveset",
    "showpoints",
    "text",
    "undo",
    "vadjust",
    "write",
    "zpoint",
    NULL};
(*(lrtns[]))() = {
    LGAlign,			/* align */
    LGBrush,			/* set brush */
    LGMenu,			/* select user set buffer */
    LGClearPoints,		/* clear points */
    LGDeletePoint,		/* delete a point */
    LGEdit,			/* edit new file */
    LGFont,			/* set font */
	XChangeGrid,    /* change grid size */
    LGHAdjust,                  /* horizontal adjust */
	LGCSetPoints,		/* cset halftoning */
    LGIncludeSet,		/* add to set */
    LGJust,			/* text justification */
    LGLittlePoint,		/* point size */
    LGMBrush,			/* modify brush */
    LGMFont,			/* modify font */
    LGMirror,			/* mirror current set */
    LGMPoint,			/* move point */
    LGMSize,			/* modify size */
    LGMText,			/* modify text string */
    LGPath,			/* set path or toggle search mode */
    LGOpoint,			/* obtain point from terminal */
    LGQuit,			/* quit */
    LGRead,			/* read user sysmbol */
    LGSize,                     /* character size */
    LGSave,			/* save current set in file */
    LGShowPoints,		/* display reference points in set */
    LGText,			/* input text */
    LGUndo,			/* undo last command */
    LGVAdjust,                  /* vertical adjust */
    LGWrite,			/* write file */
    LGPoint};			/* create point from cursor */
  

int
LGLookup(str, table, next)
char str[];			/* Pointer to a string to be looked up */
char *(table[]);		/* Pointer to an array of string pointers
				 * which are the valid commands.  The strings
				 * must be ordered monotonically (i.e. all
				 * strings whose first characters are identical
				 * must be adjacent in the table).
				 */
int *next;

/*---------------------------------------------------------
 *	LGLookup searches a table of strings to find one that matches a
 *	given string.
 *
 *	Results:
 *	If str is an unambiguous abbreviation for one of the entries
 *	in table, then the index of the matching entry is returned.
 *	If str is an abbreviation for more than one entry in table,
 *	then -1 is returned.  If str doesn't match any entry, then
 *	-2 is returned.
 *
 *	Side Effects:	None.
 *
 * (Modified from software written by John Ousterhout for the caesar
 *  program)
 *---------------------------------------------------------
 */

{
    /* The search is carried out by using two pointers, one which moves
     * forward through table from its start, and one which moves backward
     * through table from its end.  The two pointers mark the range of
     * strings that match the portion of str that we have scanned.  When
     * all of the characters of str have been scanned, then the two
     * pointers better be identical.
     */
    char **bot, **top;
    int match, index;

    /* bang = FALSE; */
    match = 0;
    bot = table;
    for (top = table; *top != NULL; top++);
    if (top == bot) return(-2);
    top--;

    for (index=0; ; index++)
    {
        *next = index;

	/* Check for the end of string */

	if ( (str[index] == '\0')  ||
             (str[index] == ',')   ||
             (str[index] == ' ')       )
	{
	    if (bot == top) return(match);
	    else return(-1);
	}
	if (str[index] == '!') bang = TRUE;
	else
	{

	/* Move bot up until the string it points to matches str in the
	 * index'th position.  Make match refer to the index of bot in table.
	 */
	    while ((*bot)[index] != str[index])
	    {
	        if (bot == top) return(-2);
	        bot++;
	        match++;
	    }
    
	/* Move top down until it matches */
	    while ((*top)[index] != str[index])
	    {
	        if (bot == top) return(-2);
	        top--;
	    }
        }
    }
}


LGCommand(command)
char *command;

/*---------------------------------------------------------
 *	This routine reads in, looks up, and executes a long command.
 *
 *	Results:	None.
 *
 *	Side Effects:
 *	Depends on the command that is invoked.
 *---------------------------------------------------------
 */

{
    int index, next=0;

    if (*command == '\0') 
    {
        Consume = FALSE;
        return; 
    }
    index = LGLookup(command, lcmds, &next);
	next++;
    if (index >= 0)
    {
		strcpy(input_buffer,(command+next));
		(*(lrtns[index]))();
    }
    else
    {
	if (index == -1) error(".gremlinrc: command is ambiguous.");
	if (index == -2) error(".gremlinrc: not a command.");
    }
}

static char badarg[10] = "bad args";
static char noset[15] = "no current set";

#define BADNUM -1
#define NONUM -2
#define Delimiter(c) ((c == '\0') || (c == ' ') || (c == ','))

GetNumParm(linei, index)
char *linei;
int *index;
/*
 *      This routine trys to interpret the string starting at
 * line+index as a positive integeral numeric parameter.  The function
 * returns the numeric equivalent or a negative number it there is some
 * error in interpreting the string.
 */

{
	char num[20];
	int i, result;
	char *line;

	line = linei;
	for (i=0; !Delimiter(*(line + *index)); ++i)
	{
		num[i] = *(line + *index);
		if ( !isdigit(num[i]) ) return (BADNUM);
		++(*index);
	}  /* end for */
	if ( i == 0 ) return(NONUM);
	num[i] = '\0';
	(void) sscanf(num,"%d",&result);
	return(result);
}  /* end GetNumParm */


LGOpoint()
/*
 *      This routine accepts coordinates from the text terminal
 * and creates and displays a point from them by passing them
 * along to LGPoint.
 *
 * NOTE: coordinates from the terminal must be non-negative
 * integers.
 */

{
	int index, xcoord, ycoord;
	char *line;

	line = input_buffer;
	index = 0;
	xcoord = GetNumParm(line, &index);
	if (xcoord < 0)
	{
		error("set point: bad x coordinate.");
		return;
	}
	++index;
	ycoord = GetNumParm(line, &index);
	if (ycoord < 0)
	{
		error("set point: bad y coordinate.");
		return;
	}
	PX = xcoord;
	PY = ycoord;
	LGPoint();
}  /* end LGOpoint */


LGPoint()
/*
 *      This routine accepts cursor coordinates and creates and
 * displays points according to the current adjustment and alignment
 * modes.  Note that alignment and gravity are mutually exclusive
 * and adjustment takes precedence over either.
 */

{
	ELT *temp;
	POINT *p1;

	temp = DBInit();
	if (GravityOn) DBGravitate (PX, PY, &PX, &PY, &p1, &temp, PICTURE);
	if (DBNullelt(temp))     /* no gravity in effect */
	{
		/* Round to nearest alignment boundary */

		PX = (float) (((int) (PX / Alignment + 0.5)) * Alignment);
		PY = (float) (((int) (PY / Alignment + 0.5)) * Alignment);
	}

	if (SEQ > 0)      /* this isn't the first point */
	{
		if (Adjustment == HORZ) PY = Lasty;
		if (Adjustment == VERT) PX = Lastx;
		if (Adjustment == MAN)
			if (fabs(PX - Lastx) > fabs(PY - Lasty)) PY = Lasty;
			else   PX = Lastx;
	}  /* end if SEQ */;
	GRDisplayPoint((int) PX, (int) PY, SEQ, pointstyle);
	(void) PTMakePoint(PX, PY, &POINTLIST);
	Lastx = PX;
	Lasty = PY;
	Consume = FALSE;
	++SEQ;
} /* end Point */

CP()
/*
 *      This routine deletes all points from the POINTLIST and 
 * clears them from the display also.
 */

{
	POINT *temp;

	while ( !Nullpoint(BACKPOINT) )
	{
		temp = PTNextPoint(BACKPOINT);
		free ((char *) BACKPOINT);
		BACKPOINT = temp;
	}
	BACKPOINT = POINTLIST;
	POINTLIST = PTInit();
	SEQ = 0;
}  /* end CP */


LGClearPoints()
{
	GRBlankPoints();
}

LGDeletePoint()
/*
 *      This routine removes the last point from the POINTLIST
 * and erases it from the screen.
 */

{
	POINT *pt1, *pt2, *pt3; 
	float savex, savey;
	int i;

	if (SEQ == 0)
	{
		error("Delete Point:  no point");
		return;
	}
	pt2 = pt3 = POINTLIST;
	while ( !Nullpoint(pt3) )     /* find last point and pointer to it */
	{
		pt1 = pt2;
		pt2 = pt3;
		pt3 = PTNextPoint(pt3);
	};
	SEQ--;
	savex = pt2->x;
	savey = pt2->y;
	GRErasePoint( (int) pt2->x, (int) pt2->y, SEQ);
	PTDeletePoint(pt2);
	if (SEQ > 0)  /* any points left after deleting */
	{             /* then pt1 points to last of them */
		Lastx = pt1->x;
		Lasty = pt1->y;
		pt3 = POINTLIST;   /* redisplay any nearby points */
		for (i=0; i<SEQ; ++i)   /* which may have been clobbered by */
		{                      /* the erase */
			if (fabs(pt3->x - savex) < (2*halfpoint))
				if (fabs(pt3->y - savey) < (2*halfpoint))
					GRDisplayPoint((int) pt3->x,
					               (int) pt3->y,
					               i, pointstyle);
			pt3 = PTNextPoint(pt3);
		}  /* end for */
	}
	Consume = FALSE;
}  /* end DeletePoint */


LGShowPoints()
{
	ELT *elist;
	POINT *p1;
	int pno;

	if (DBNullelt(cset))
	{
		error("Show Points:  no current set.");
		return;
	}
	elist = cset;
	while ( !DBNullelt(elist) )
	{
		p1 = elist->ptlist;
		pno = 0;
		while (!Nullpoint(p1))
		{
			GRDisplayPoint((int)p1->x, (int)p1->y, pno, pointstyle);
			p1 = PTNextPoint(p1);
			pno++;
		}
		elist = DBNextofSet(elist);
	}  /* end while */
	Consume = FALSE;
} /* end ShowPoints */


LGText()
/*      This routine implements the text commands.  It first looks
 * for a justification specification (if not specified, default is
 * centering), and then the text string from the input line.  Text
 * justification requires a point upon which the text is positioned.
 */

{
	ELT *e1;
	POINT pos, ppnt, *p1;
	int i, j;
	char *text, *line;

	if (SEQ == 0)
	{
		error("Text:  not enough points.");
		return;
	}

	if (*input_buffer == '\0') {
		error("Text:  no text.");
		return;   /* no text */
	}

	GRBlankPoints();
	
	text = malloc((unsigned)strlen((char*)input_buffer)+1);
	
	(void) strcpy(text, input_buffer);

	DBClearSet();         /* clear old current set so this can form */
	DISClearSetDisplay();  /* the new one  */
	ppnt.x = POINTLIST->x;
	ppnt.y = POINTLIST->y;
	if (SEQ > 1)
	{
		p1 = PTNextPoint(POINTLIST);
		ppnt.x = (POINTLIST->x + p1->x)/2;
		ppnt.y = (POINTLIST->y + p1->y)/2;
	}

	GRPutText(CJUST, &ppnt, CFONT, CSIZE, text, &pos);
	p1 = PTInit();
	(void) PTMakePoint(ppnt.x, ppnt.y, &p1);
                  /* end extra positioning points */
	(void) PTMakePoint(pos.x, pos.y, &p1);   
	(void) PTMakePoint(pos.x + i * charxsize / 2, pos.y, &p1);
	(void) PTMakePoint(pos.x + i * charxsize, pos.y, &p1);
	e1 = DBCreateElt(CJUST, p1, CFONT, CSIZE, text, &PICTURE);
	DBAddSet(e1);
	CHANGED = TRUE;
}  /* end LGText */

LGBrush()
/*
 *      This routine sets the current brush to that specified in the
 * parameter.
 */

{
	int newbrush, index;
	char string[2];
	char *line;

	line = input_buffer;
	index = 0;
	if (isalpha(*line)) 
        {
              newbrush = LGLookup(line, lines, &index);
              if (newbrush >= 0) newbrush = lnum[newbrush];
              else  newbrush = BADNUM;
        }
	else newbrush = GetNumParm(line, &index);
	if ( (newbrush == BADNUM) || (newbrush > NBRUSHES) || (newbrush<1))
	{
		error("brush: bad arguments.");
		return;
	}
	CBRUSH = newbrush;
	XBitmapBitsPut(FrameList[6].self,0,0,38,38,brush_icons[CBRUSH],BlackPixel,WhitePixel,0,icon_light[6],AllPlanes);
	Consume = FALSE;
}  /* end LGBrush */

LGMBrush()
/*
 *      This routine causes the elements in the current set
 * to be redrawn using the new brush.
 */

{
	ELT *elist;
	int new, index;
	char *line;

	line = input_buffer;
	index = 0;
	if (isalpha(*line)) 
        {
              new = LGLookup(line, lines, &index);
              if (new >= 0) new = lnum[new];
              else  new = BADNUM;
        }
	else new = GetNumParm(line, &index);
	if ( (new <= 0) || (new > NBRUSHES) )
		new = CBRUSH;
	if (DBNullelt(cset))
	{
		error("modify brush: no current set.");
		return;
	}
	elist = cset;
	while ( !DBNullelt(elist) )
	{
		if (!TEXT(elist->type))
		{
			DISScreenErase(elist, (linemask | setmask));
			DBChangeBrush(elist, new, &PICTURE);
			DISScreenAdd(elist, (linemask | setmask));
		}  /* end if */
		elist = DBNextofSet(elist);
	}  /* end while */
	CHANGED = TRUE;
	Consume = FALSE;
} /* end MBrush */


LGMFont()
/*
 *      This routine causes the text elements in the current set
 * to be redrawn using the new font.
 */

{
	ELT *elist;
	int new, index;
	char *line;

	line = input_buffer;
	index = 0;
	if (isalpha(*line)) 
        {
              new = LGLookup(line, fonts, &index);
              if (new >= 0) new = fnum[new];
              else  new = BADNUM;
        }
	else new = GetNumParm(line, &index);
	if ( (new <= 0) || (new > NFONTS) )
		new = CFONT;
	if (DBNullelt(cset))
	{
		error("modify font: no current set");
		return;
	}
	elist = cset;
	while ( !DBNullelt(elist) )
	{
		if (TEXT(elist->type))
		{
			DISScreenErase(elist, (linemask | setmask));
			DBChangeFont(elist, new, elist->size, &PICTURE);
			DISScreenAdd(elist, (linemask | setmask));
		}  /* end if */
		elist = DBNextofSet(elist);
	}  /* end while */
	CHANGED = TRUE;
	Consume = FALSE;
} /* end MFont */

LGMSize()
/*
 *      This routine causes the text elements in the current set
 * to be redrawn using the new size.
 *
 */

{
	POINT *p1, *p2, pos;
	ELT *elist;
	int new, index, i, j;
	char *line;

	line = input_buffer;
	index = 0;
	new = GetNumParm(line, &index);
	if ( (new <= 0) || (new > NSIZES) )
		new = CSIZE;
	if (DBNullelt(cset))
	{
		error("modify size: no current set");
		return;
	}
	elist = cset;
	while ( !DBNullelt(elist) )
	{
		if (TEXT(elist->type))
		{
			DISScreenErase(elist, (linemask | setmask));
			UNRembMod(elist,&PICTURE);
			elist->size = new;
			p1 = elist->ptlist;
			GRPutText(elist->type, p1, elist->brushf,
				  elist->size,elist->textpt, &pos);
			i= strlen(elist->textpt);
			p2 = PTInit();
			(void) PTMakePoint(p1->x, p1->y, &p2);
                   	   /* end extra positioning points */
			(void) PTMakePoint(pos.x, pos.y, &p2);   
			(void) PTMakePoint(pos.x + i * charxsize / 2, 
					   pos.y, &p2);
			(void) PTMakePoint(pos.x + i * charxsize, pos.y, &p2);
			elist->ptlist = p2;
		}  /* end if */
		elist = DBNextofSet(elist);
	}  /* end while */
	CHANGED = TRUE;
	Consume = FALSE;
} /* end MSize */


LGMText()
/*      This routine allows modification of text by replacing 
 * an existing string with a new one, appropriately repositioned
 */

{
    ELT *e1;
    POINT pos, ppnt, *p1;
    int i, j;
    char *text;

	i = strlen(input_buffer);
	if(i==0)
	{
		error("modify text: null text string.");
		return;
	}
	text = malloc((unsigned) i+1);
	(void) strcpy(text,input_buffer);
    e1 = cset;
    while ( !DBNullelt(e1) )
    {
        if (TEXT(e1->type))
        {
            DISScreenErase(e1, (textmask | setmask));
            UNRembMod(e1, &PICTURE);
            ppnt.x = e1->ptlist->x;
            ppnt.y = e1->ptlist->y;
        
            GRPutText(e1->type, &ppnt, e1->brushf, e1->size, text, &pos);
            p1 = PTInit();
            (void) PTMakePoint(ppnt.x, ppnt.y, &p1);
                       /* end extra positioning points */
            (void) PTMakePoint(pos.x, pos.y, &p1);   
            (void) PTMakePoint(pos.x + i * charxsize / 2, pos.y, &p1);
            (void) PTMakePoint(pos.x + i * charxsize, pos.y, &p1);
            e1->textpt = text;
        }  /* end if text */
        e1 = DBNextofSet(e1);
    }  /* end while */
    CHANGED = TRUE;
	Consume = FALSE;
}  /* end LGMText */

LGMPoint(line)
char *line;
/*
 *      This routine modifies the element which contains the point
 * closest to the first of two specified points so that that point
 * coincides with the second of the points (if specified).
 *
 *       Note: it implies knowlege of the database representation by modifying
 *           the element directly.
 */

{
	ELT *e1;
	POINT *p1, *p2, *p3, *p4;
	float x1, y1;

	if (SEQ < 1)     /* no points */
	{
		error("Move Point:  no point specified");
		return;
	}
	GRBlankPoints();
                      /* find point */
	DBSetGravitate(POINTLIST->x, POINTLIST->y, &x1, &y1, &p1, &e1, cset);
	if ( !DBNullelt(e1) )
	{
		DBClearSet();
		DISClearSetDisplay();
		DISScreenErase(e1, (linemask | setmask));
		UNRembMod(e1,&PICTURE);
		if (SEQ > 1)     /* move a point, not delete */
		{
			p2 = PTNextPoint(POINTLIST);
			p1->x = p2->x;
			p1->y = p2->y;
			p2 = PTNextPoint(p2);
			if (!Nullpoint(p2))
			{
				p3 = PTInit();
				while (!Nullpoint(p2))
				{
					p4 = PTMakePoint(p2->x, p2->y, &p3);
					p2 = PTNextPoint(p2);
				}
				p4->nextpt = p1->nextpt;
				p1->nextpt = p3;
			}
		}
		else
		{
			PTDeletePoint(p1);
		}
		DISScreenAdd(e1, (linemask | setmask));
		DBAddSet(e1);
	}  /* end if !DBNullelt */
}  /* end MPOINT */


LGLittlePoint(line)
char *line;
/*
 *      This routine controls the size of the point that is displayed
 * The sizes available are artmode in which a small (3 x 3) point is displayed
 * with no number and regular (non- artmode).
 */

{

	GRBlankPoints();
	if (artmode) artmode = FALSE;
	else artmode = TRUE;
	GRShowPoints();
	XBitmapBitsPut(FrameList[32].self,0,0,38,38,point_icons[artmode],BlackPixel,WhitePixel,0,icon_light[32],AllPlanes);
	Consume = FALSE;
}  /* end Little Point */


LGSave()
/*
 *      This routine writes the current set into the specified filename
 * or to the current Editfile
 */

{
    FILE *fp, *fopen();
    char tname[50], filename[100], string[100], *tn, *fn, *wfile;
    ELT *elist;
    POINT *plist, pos;
    int i, space, stat;
	char *line;

	line = input_buffer;
    space = 100;
    tn = tname;  fn = filename;
    (void) sscanf(line, "%s", tname);
    /* i = strlen(tname); */
    /* if (i == 0)       /* no filename */
	if(*input_buffer == '\0')
    {
        error("Save cset:  write to where?");
        return;
    }
    stat = PConvertTilde(&tn, &fn, &space);
    *fn = '\0';
    if (stat == FALSE)
    {
        sprintf(string, "Save cset:  unknown path %s", tname);
        error(string);
        return;
    }
    if ( !bang )  /* user doesn't insist */
    {
        fp = fopen(filename, "r");
        if ( fp != NULL )
        {
             error("Save cset:  file already exists");
             return;
        }
    }
    fp = fopen(filename, "w");
    wfile = filename;
    if (fp == NULL)      /* file error */
    {
        (void) sprintf(string,"Save cset:  can't open %s", wfile);
        error(string);
        return;
    };
	sprintf(string,"writing '%s'...",filename);
	message(string);
    CHANGED = FALSE;
    if (SEQ > 0)       /* specified a positioning point */
    {
        pos.x = POINTLIST->x;
        pos.y = POINTLIST->y;
    }
    else
    {
        if ( !DBNullelt(PICTURE) )
        {
            pos.x = PICTURE->ptlist->x;
            pos.y = PICTURE->ptlist->y;
        }
        else
        {
            pos.x = pos.y = 0;
        };
    }
    fprintf(fp,"gremlinfile\n");    /* write header */
    fprintf(fp, "%d %1.2f %1.2f\n", Orientation, pos.x, pos.y);
    elist = cset;
    while ( !DBNullelt(elist) )    /* write each element */
    {
        fprintf(fp, "%d\n", elist->type);
        plist = elist->ptlist;
        while ( !Nullpoint(plist) )  /* write each point */
        {
            fprintf(fp, "%1.2f %1.2f\n",plist->x, FrameList[PAGE_WIN].height-plist->y);
            plist = PTNextPoint(plist);
        }  /* end while plist */
        fprintf(fp, "%1.2f %1.2f\n", -1.0, -1.0);  /* end pointlist */
        fprintf(fp, "%d %d\n",elist->brushf, elist->size);
        fprintf(fp,"%d %s\n ", strlen(elist->textpt), elist->textpt);
        elist = DBNextofSet(elist);
    }  /* end while */
    fprintf(fp,"%d\n",-1);   /* end of element list */
	sprintf(string,"done writing '%s'.",filename);
    (void) fclose(fp);
}  /* end LGSave */;
