.Lc System\ Functions 6
.\".ch 6
This chapter describes the functions which one uses to interact
with 
.Fr
running in the UNIX
enviroment.
.Lf allocate "'s_type 'x_pages"
.Wh
s_type is one of the 
.Fr
data types described in \(sc1.3.
.Re
the number of pages actually allocated.
.Se
.Fr
attempts to allocate x_pages of type s_type.
.Lf argv "'x_argnumb"
.Re
a symbol whose pname is the x_argnumb\fIth\fP argument on the command
line which invoked the current lisp.
.No
if x_argnumb is zero or less, a fixnum whose value is the number of arguments
on the command line is returned.
(argv\ 1) returns the name of the lisp you are running which is always
the first argument.
.Lf baktrace 
.Re
nil
.Se
the lisp runtime stack is examined and the name of (most) of the functions
currently in execution are printed, most active first.
.No
this will occasionally miss the names of compiled lisp functions due to
incomplete information on the stack.
See the function showstack for another way of printing the lisp runtime
stack.
.Lf bindstack
.Lf boundp "'s_name"
.Re
nil  if s_name is unbound, that is it has never be given a value.
If x_name has the value g_val, then (nil\ .\ g_val) is returned.
.\".pg
.Lf chdir "'s_path"
.Re
t iff the system call suceeds.
.Se
the current directory set to s_path. 
Among other things, this will affect the default location
where the input/output functions look for and create files.
.No
chdir follows the standard UNIX conventions, if s_path does not begin
with a slash, the default path is changed to the current path with
s_path appended.
.Lf cont
.Eq
return
.No
cont should not be used in compiled code as the compiler does not
believe that return and cont are equivalent.
.Lf dumplisp "s_name"
.Re
nil
.Se
the current lisp is dumped to the disk with the file name s_name.
When s_name is executed, you will be in a lisp in the
same state as when the dumplisp was done.
.No
dumplisp will fail if  one tries to 
write over the current running file. 
UNIX does not allow you to modify the file you are running.
.Lf eval-when "l_time g_exp1 ..."
.Se
l_time may contain any combination of the symbols
.i load ,
.i eval ,
and
.i compile .
The effects of load and compile will is discussed in the section on the
compiler.
If eval is present however, this simply means that the expressions g_exp1
and so on are evaluated from left to right.
If eval is not present, the forms are not evaluated.
.Lf exit "['x_code]"
.Re
nothing (it never returns).
.Se
the lisp system dies with exit code x_code or 0 if x_code is not
specified.
.Lf fake "'x_addr"
.Re
the lisp object at address x_addr.
.No
This is intended to be used by people debugging the lisp system.
.\".pg
.Lf gc
.Re
nil
.Se
this causes a garbage collection.
.No
garbage collection occurs automatically whenever internal free lists
are exhausted.
.Lf gcafter "s_type"
.Wh
s_type is one of the 
.Fr
data types listed in \(sc1.3.
.No
this function is called by the garbage collector
after a garbage collection which was caused by running out of 
data type s_type.
This function should determine if more space need be allocated
and if so should allocate it.
There is a default gcafter function but users who want control over
space allocation can define their own -- but note that it must be
an nlambda.
.Lf getenv "'s_name"
.Re
a symbol whose pname is the value of s_name in the current 
UNIX enviroment.
If s_name doesn't exist in the current enviroment, a symbol with a null pname
is returned.
.Lf include "s_filename"
.Re
nil
.Se
The given filename is 
.i load ed
into the lisp.
.No
this is similar to load except the argument is not evaluated.
Include means something special to the compiler.
.Lf namestack
.Lf opval "'s_arg ['g_newval]"
.Re
the value associated with s_arg before the call.
.Se
If g_newval is specified, the value associated with s_arg is changed to
g_newval.
.No
opval keeps track of storage allocation. If s_arg is one of the data types
then opval will return a list of three fixnums representing the number of
items of that type in use, the number of pages allocated and the number
of items of that type per page.  
You should never try to change the value opval associates
with a data type using
opval.
.br
If s_arg is 
.i pagelimit
then opval will return (and set if g_newval is given)
the maximum amount of lisp data pages
it will allocate.
This limit should remain small unless you know your program requires 
lots of space as this limit will catch programs in infinite loops which
gobble up memory.
.\".pg
.Lf process "s_pgrm [s_frompipe s_topipe]"
.Re
if the optional arguments are
not present a fixnum which is the exit code when s_prgm dies.
If the optional arguments are present, it returns a fixnum which
is the process id of the child.
.Se
If s_frompipe and s_topipe are given, they are bound to 
ports which are pipes which
direct characters from 
.Fr
to the new process
and to
.Fr
from the new process respectively.
this forks a process named s_prgm and waits for it to die iff there
are no pipe arguments given.
.Lf ptime 
.Re
a list of two elements, the first is the amount of processor time used
by the lisp system so far, the 
second is the amount of time used by the garbage collector so far.
.No
the first number includes the second number.
The amount of time used by garbage collection is not recorded
until the first call to ptime.
This is done to prevent overhead when the user is not interested
garbage collection times.
.Lf rematom "'s_symb"
.Re
t
.Se
s_symb is placed on the free list of symbols.
.No
You must not do this unless s_symb is an uninterned atom.
.Lf remob
.Lf reset
.Se
the lisp runtime stack is cleared and the system restarts at the top level 
by executing a (funcall\ top-level\ nil).
.Lf retbrk "['x_level]
.Wh
x_level is a small integer of either sign.
.Se
The default error handler keeps a notion of the current level
of the error caught.  If x_level is negative, control is thrown
to this default error handler whose level is that many less than
the present, or to (top-level) if there aren't enough.
If x_level is non-negative, control is passed to the handler at
that level.  If x_level is not present, the value -1 is taken by
default.
.Lf segment "'s_type 'x_size"
.Wh
s_type is one of the data types given in \(sc1.3
.Re
a segment of contiguous lispvals of type s_type.
.No
this is useful when making arrays.
.Im
what if there is no room.
.\".pg
.Lf shell
.Re
the exit code of the shell when it dies.
.Se
this forks a new shell and returns when the shell dies.
.Lf showstack
.Re
nil
.Se
all forms currently in evaluation are printed, beginning with the most recent.
For compiled code the most that 
showstack will show is the function name and it may not show all of them.
.Lf signal "'x_signum 's_name"
.Re
nil if no previous call to signal has been made, or the previously
installed s_name.
.Se
this declares that the function named s_name 
will handle the signal number x_signum.
If s_name is nil, the signal is ignored.  Presently only
four unix signals are caught: Interrupt, Floating exception, Alarm, and
Hang-up.
.Lf sizeof "'g_arg"
.Re
the number of bytes required to store one object of type g_arg, encoded
as a fixnum.
.Lf sstatus "g_type g_val"
.Re
g_val
.Se
If g_type is not one of the special sstatus codes listed below
this simply sets g_val as the value of status 
type g_type in the system status property list.
.Lf sstatus\ dumpcore "g_val"
.Re
g_val
.Se
If g_val is nil, 
.Fr tells UNIX that a segmentation violation or 
bus error should cause a core dump.
If g_val is non nil then 
.Fr
will catch those errors and print a message advising the user to reset.
.No
The default value for this flag is nil, and only those knowledgeable of
the innards of the lisp system should ever set this flag non nil.
.Lf sstatus\ dumpmode "x_val"
.Re
x_val
.Se
All subsequent 
.i dumplisp 's
will be done in mode x_val.
x_val may be either 413 or 410 (decimal).
.No
the advantage of mode 413 is that the dumped Lisp can be demand paged in when
first started, which will make it start faster and disrupt other users less.
.\".pg
.Lf sstatus\ feature "g_val"
.Re
g_val
.Se
g_val is added to the status features list, 
.Lf sstatus\ nofeature "g_val"
.Re
g_val
.Se
g_val is removed from the status features list if it was present.
.Lf status "g_code"
.Re
the value associated with the status code g_code
if g_code is not one of the special cases given below
.Lf status\ feature "g_val"
.Re
t iff g_val is in the status features list.
.Lf status\ features 
.Re
the value of the features code, which is a list of features which
are present in this system.
You add to this list with (sstatus feature 'g_val) 
and test if feature g_feat is present with (status feature 'g_feat).
.Lf status\ syntax "s_char"
.Re
a fixnum which is the syntax code associated with the character s_char
in the current readtable.
.No
You cannot set the syntax code with with sstatus syntax, you must use
.i setsyntax.
.Lf syscall
.Lf top-level
.Re
nothing (it never returns)
.No
This function is the top-level read-eval-print loop.
It never returns any value.
Its main utility is that if you redefine it, and do a (reset) then the
redefined (top-level) is then invoked.
.\".pg
.Lf what "'g_arg"
.Re
the address of its argument converted into a fixnum. (Cf. fake).
