.ND
.TL
Invitation to a General Access
.UX
Network
.AU
Tom Truscott, Duke University
.SH
Invitation
.PP
A group of
.UX
systems
at Duke University and the University of North Carolina, Chapel Hill,
have established a uucp-based computer communication network.
Admission to the net is open to all
.UX
licensees.
In addition to providing the "uu" services
available in the Seventh Edition of
.UX
(remote mail, file transfer, job execution),
it will provide a network news service.
A prospective node must have a call-in facility,
call-out facility, or some other means
of communication with another
.UX
net system.
The node must have, or be able to legitimately obtain,
uucp and related software.
.PP
Systems which do not call-out to the net
must be polled occasionally.
We will poll any system that so requests,
and will bill the polled system for phone costs.
The phone costs are expected to be $10-20/month.
Requests for an application should be sent to
.DS
James Ellis
Department of Computer Science
Duke University
Durham, NC   27706
Telephone: (919) 684-3048
.DE
.SH
Services
.PP
The initially most significant service
will be to provide a rapid access newsletter.
Any node can submit an article,
which will in due course propagate to all nodes.
A "news" program has been designed
which can perform this service.
The first articles will probably concern bug fixes,
trouble reports,
and general cries for help.
Certain categories of news,
such as "have/want" articles,
may become sufficiently popular
as to warrant separate newsgroups.
(The news program mentioned above supports newsgroups.)
.PP
The mail command provides a convenient means
for responding to intriguing articles.
In general,
small groups of users with common interests
will use mail to communicate.
If the group size grows sufficiently,
they would probably start an additional news group.
.PP
Complete programs and other machine readable text
are inappropriate for transmission via (ordinary) news.
On the other hand,
if a news contributor announces
a new version of "x.c",
he could be innundated with requests
such as "please mail dod!mum a copy of x.c."
To avoid that, he could make his copy of x.c
directly accessible to anyone
via the uucp file copy program.
In order to reduce uucp traffic,
copies could be made
at the more central nodes of the net.
Traffic will be reduced further
by extending news to support "news on demand."
X.c would be submitted to a newsgroup (e.g. "NET.bulk")
to which no one subscribes.
Any node could then request the article by name,
which would generate a sequence of news requests
along the path from the requester to the
contributing system.
Hopefully, only a few requests would locate a copy of x.c.
"News on demand" will require a network routing map
at each node, but that is desirable anyway.
.PP
It is hoped that USENIX will take an active
(indeed central)
role in the network.
There is the problem of members not on the net,
so hardware newsletters should remain
the standard communication method.
However, use of the net for preparation of newsletters
seems like a good idea.
.SH
Implementation
.PP
The hardware and software requirements
for a system to join the net
were mentioned above.
The uucp system has been retrofitted
to run on the Sixth Edition of
.UX ,
so both Sixth and Seventh Edition Systems can join.
Each node must have a unique name,
so all names must be cleared by the network administration.
Duke will provide the initial administrative functions,
and will also provide software
for the network news to function.
.PP
Although we can supply a news program,
individual sites may prefer to adapt
their existing programs.
This requires
the ability to print and receive articles
in the news transfer format.
The format used to transmit an article
between systems
is given below.
The first character of the file
identifies the format
and will be used to simplify
inevitable changes in article formats.
The rest of the first line is a unique system-wide name,
which also identifies the originating node.
The article name is used to prevent
the unlimited duplication of news articles
that might otherwise occur.
It has a side benefit
of simplifying the implementation of a "news on demand" facility.
Support for newsgroups (line 2) is required.
All network newsgroups will have the prefix "NET.".
Support for contributor name (line 3)
and contribution date (line 4)
are recommended.
A `deletion date' is not supported;
it is up to each node to delete ancient news.
Line 5 is the (alphabetic) article title.
.bp
.SH
News Article Format
.LP
.TS
l l lw(20ens).
.sp
line	example	description
=
.sp
1	Aunc.173	T{
Articles begin with the character `A'.
The originating system is `unc',
which gave the article the unique name `unc.173'.
T}
.sp
2	NET.general	T{
Newsgroups to which this article belongs.
T}
.sp
3	duke!unc!smb	T{
The net path to the contributor.
This line changes as the article
passes from system to system.
T}
.sp
4	Thu Jan 24 01:39:20 EST 1980	T{
The date the article was submitted to news
at the originating system.
T}
.sp
5	cron	T{
The title of the article.
T}
.sp
6	T{
.nf
Delete line 221 of cron.c:
	*cp++ = '\en';
Not needed. It confuses ps.
.fi
T}	The text of the news article.
.sp
.TE
.PP
Article names are restricted to 14 or fewer characters.
.bp
.SH
Questions Answered
.IP 1.
Won't this be expensive?
.br
Not at all.
Night time phone costs are perhaps $0.50/3 minutes,
in which time uucp could transfer perhaps
3000 bytes of data (300 baud).
Daily polling would then cost $15.00/Month,
which is half what Duke pays
just for an office phone.
.IP 2.
Could Duke really handle all the phone calls?
.br
Sure.
We have two call-out lines:
at five minutes/call,
we can handle 24 calls/hour.
Other nodes can also volunteer
to perform the call-out function.
.IP 3.
What does Duke get out of this?
.br
We avoid phone charges ourselves,
and we get news sooner than anyone else.
.IP 4.
What about abuse of the network?
.br
In general, it will be straightforward
to detect when abuse has occurred
and who did it.
The uucp system, like
.UX ,
is not designed to prevent abuses
of overconsumption.
Experience will show what uses of the net
are in fact abuses,
and what should be done about them.
.IP
Certain abuses of the net
can be serious indeed.
As with ordinary abuses,
they can be thought about,
looked for,
and even programmed against,
but only experience will show what matters.
Uucp provides some measure of protection.
It runs as an ordinary user,
and has strict access controls.
It is safe to say that it poses no greater threat
than that inherent in a call-in line.
.IP 5.
Who would be responsible when something bad happens?
.br
Not us!
And we do not intend that any innocent bystander
be held liable either.
We are looking into this matter.
Suggestions are solicited.
.IP 6.
This is a sloppy proposal. Let's start a committee.
.br
No thanks!
Yes, there are problems.
Several amateurs collaborated on this plan.
But let's get started
.I now .
Once the net is in place,
we can start a committee.
And they will actually use the net,
so they will know what the real problems are.
.IP 7.
Okay, so a few systems get the net started. What next?
