
#include "gremlin.h"
#include "grem2.h"
#include <ctype.h>

extern char input_buffer[];
extern Font pointfont, text_win_font;
extern int icon_light[];
extern short adjust_icons[4][114];
extern short font_icons[4][114];
extern short just_icons[8][114];
extern short size_icons[5][114];

/* imports from graphics files */

extern GRVector(), GRArc(), GRPutText(), GRClose();
extern GRDisplayPoint(), GRDeletePoint(), GRBlankPoints();
extern charxsize, charysize, GrXMax, GrYMax;

/* import from path.c */

extern int PSetPath(), PConvertTilde();
extern char *PGetPath();
extern char path[];

/* imports from display.c */

extern DISScreenAdd(), DISScreenErase();
extern DISDisplaySet(), DISEraseSet(), DISClearSetDisplay();

/* imports from database files */

extern ELT *DBInit(), *DBCreateElt(), *DBRead();
extern DBDelete(), DBGravitate(), DBClearElt();
extern ELT *DBCopy();
extern DBXform(), DBChangeBrush();
extern DBAddSet(), DBClearSet();
extern POINT *PTInit(), *PTMakePoint();
extern PTDeletePoint();

/* imports from undodb.c */

extern UNELT *unlist, *unback;
extern UNForget();

/* imports from short.c */

extern SHUpdate();
extern int adj[];

/* imports from c */

extern char *malloc();
extern char *strcpy(), *sprintf();

/* imports from main.c */

extern int window_num;
extern OpaqueFrame FrameList[];
extern ELT *PICTURE;                /* current PICTURE database      */
extern ELT *cset;                   /* current set database          */
extern CBRUSH, CSIZE, CFONT;        /* current brush, size, font     */
extern CJUST;                       /* current text justification    */
extern CBUF, CGRID, CSETPOINTS;
extern Gridon;                      /* grid mode flag                */
extern Orientation;                 /* orientation of workspace      */
extern SEARCH;                      /* flag for path search          */
extern Alignment;                   /* point alignment indicator     */
extern float PX, PY;                /* cursor coordinates            */
extern float Lastx, Lasty;          /* previous cursor coordinates   */
extern SEQ;                         /* point sequence number         */
extern POINT *POINTLIST, *BACKPOINT;/* accumulated point list        */
extern Adjustment;                  /* point adjustment mode         */
extern GravityOn;                   /* gravity mode flag             */
extern Consume;                     /* point clear flag              */
extern CHANGED;                     /* PICTURE changed flag          */
extern ELT *MEN[];                  /* pointers for user symbols     */
extern POINT MENPOINT[];            /* pointers used fo user symbols */
extern cmdbuf[];                    /* line buffer for commands      */
extern char *textpos[], *dispmode[];/* text positioning modes        */
extern int textmode[];              /* text positioning              */
extern char *lines[], *fonts[];     /* line and character styles     */
extern int jmodes, lnum[], fnum[];

/*  imports from long1.c         */
extern bang;
extern GetNumParm();
extern LGLookup();

char *Editfile;

#define BADNUM -1
#define NONUM -2
#define Delimiter(c) ((c == '\0') || (c == ' ') || (c == ','))

static char badarg[10] = "bad args";

LGAlign()
/*
 *      This routine sets the point alignment indicator
 */
{
    int newalign, index;
    char string[4], num[5];

    index = 0;
    newalign = GetNumParm(input_buffer, &index);
    if (newalign == NONUM)
        if (Alignment <= CGRID ) Alignment *= 2;
        else Alignment = 1;
    else
    {
        if ((newalign < 1) || (newalign > GrYMax/2) ) 
        {
            error("Align: bad arguments.");
            return;
        }
        Alignment = newalign;
    }
	sprintf(num,"%4d",Alignment);
	XText(FrameList[27].self,1,1,num,strlen(num),pointfont,WhitePixel,BlackPixel);
    Consume = FALSE;
}  /* end LGAlign */

LGIncludeSet()
/*
 *      This routine adds all elements selected by points in POINTLIST
 * to the current set.  It does not remove previously selected elements.
 *
 */

{
    POINT *p1, *p2;
    ELT *e1;
    float n1, n2;

    if (DBNullelt(PICTURE)) return;

	GRBlankPoints();

    if (SEQ == 0)    /* no points: entire picture becomes */
    {                /* current set                       */
        e1 = PICTURE;
        while ( !DBNullelt(e1) )
        {
            DBAddSet(e1);
            DISDisplaySet(e1);
            e1 = DBNextElt(e1);
        }
    }  /* end if */
    else
    {
        p1 = POINTLIST;
        while ( !Nullpoint(p1) )
        {
            DBGravitate(p1->x, p1->y, &n1, &n2, &p2, &e1, PICTURE);
            if ( !DBNullelt(e1) ) 
            {
                DBAddSet(e1);
                DISDisplaySet(e1);
            }
            p1 = PTNextPoint(p1);
        }  /* end while */;
    }  /* end else */
} /* end LGIncludeSet */


LGMenu()
/*
 *      This routine implements the menu command.  The contents of 
 * the specified user menu item is copied into the PICTURE transformed
 * to the positioning point.
 */

{

    ELT *elist, *e1;
    POINT *plist;
    int symbol, index;
    float xmat[3][2];

    if (SEQ < 1) 
    {
        error("Get Buffer:  no positioning point");
        return;
    }
    index = 0;
	if((symbol=GetNumParm(input_buffer,&index))<0)
		symbol = CBUF;
    if ( (symbol <= 0) || (symbol > NUSER) )
    {
        error("Get Buffer: no buffer specified.");
        return;
    }
	GRBlankPoints();
    symbol--;     /* users inputs number between 1 and N, actual
                     symbol number is between 0 and N-1          */
    xmat[0][0] = xmat[1][1] = 1;    /* create transformation matrix */
    xmat[0][1] = xmat[1][0] = 0;    /* for copy into PICTURE        */
    plist = POINTLIST;
    while ( !Nullpoint(plist) )
    {
        DISClearSetDisplay();   /* Clear old current set */
        DBClearSet();
        xmat[2][0] = plist->x - (MENPOINT[symbol]).x;
        xmat[2][1] = plist->y - (MENPOINT[symbol]).y;
        elist = MEN[symbol];
        while ( !DBNullelt(elist) )  /* copy buffer to picture */
        {
            e1 = DBCopy(elist, xmat, &PICTURE);
            DBAddSet(e1);
            DISScreenAdd(e1, (linemask | setmask));
            elist = DBNextElt(elist);
        }  /* end while */
        plist = PTNextPoint(plist);
    }  /* end while */
    CHANGED = TRUE;
}  /* end LGMenu */


LGRead()
/*
 *      This routine reads in the specified filename (command line) to the
 * selected user symbol or current set if no user symbol is selected.  If
 * no filename is specified, the current set is copied to the user symbol;
 */

{
    POINT pos, ppos;
    ELT *elist, *e1;
    char tname[50], filename[100];
    float xmat[3][2];
    int i, orient;

    if ( input_buffer[0] == '\0' )     /* no arguments */
    {
        error("Read: no filename specified.");
        return;
    }
	GRBlankPoints();
    elist = DBRead(&input_buffer[0], &orient, &pos); /* read file */
    UNForget();     /* forget changes registered by DBRead */
    if (SEQ < 1)    /* no positioning point */
    {
        ppos.x = pos.x;
        ppos.y = pos.y;
    }
    else
    {
        ppos.x = POINTLIST->x;
        ppos.y = POINTLIST->y;
    }
    xmat[0][0] = xmat[1][1] = 1;   /* set up matrix to copy to */
    xmat[0][1] = xmat[1][0] = 0;   /* appropriate place in     */
    xmat[2][0] = ppos.x - pos.x;   /* picture as current set   */
    xmat[2][1] = ppos.y - pos.y;
    DBClearSet();
    DISClearSetDisplay();
    while ( !DBNullelt(elist) )
    {
        e1 = DBCopy(elist, xmat, &PICTURE);
        DISScreenAdd(e1, (linemask | setmask));
        DBAddSet(e1);
        e1 = DBNextElt(elist);
        DBClearElt(elist);
        elist = e1;
    }
    CHANGED = TRUE;
}  /* end LGRead */


LGEdit()
/*
 * This routine reads in a new PICTURE for editing
 */

{
    FILE *fp, *POpen();
    POINT pos;
    ELT *e1;
    char *tn, tname[50]; 
    int i;

    if (!bang)     /* no ! */
    {
        if (CHANGED)
        {
            error("Edit:  no write");
            return;
        }
    }  /* end if !bang */;
    DBClearSet();
    while ( !DBNullelt(PICTURE) )   /* clear current PICTURE */
    {
        e1 = DBNextElt(PICTURE);
        DBClearElt(PICTURE);
        PICTURE = e1;
    };
    tn = tname;  
    (void) sscanf(input_buffer, "%s", tname);

    POINTLIST = PTInit();   /* Initialize globals */
    SEQ = 0;
    CHANGED = FALSE;

    i = strlen(tname);
    if (i > 0)        /* filename present */
    {
        fp = POpen(tname, (char **) NULL, SEARCH);
        if (fp == NULL)
        {
            PICTURE = DBInit();
            error(" (creating new file)");
        }
        else     
        {
            PICTURE = DBRead(tname, &Orientation, &pos);
			(void) fclose(fp);
        }
        (void) strcpy (Editfile, tname);
    }
    else
    {
        (void) strcpy(Editfile, "");
    }
    unlist = unback = nullun;
    CP();
    SHUpdate();      /* display new picture */
	RedrawText();
}  /* end LGEdit */

static restorepoints()

/* This routine (re) displays the points in the back-up pointlist
 */
{

    int i;
    POINT *plist, *pl1, *pl2;

    GRBlankPoints();
    plist = BACKPOINT;
    for (i=0; !Nullpoint(plist); ++i)
    {
        Lastx = plist->x;
        Lasty = plist->y;
        GRDisplayPoint( (int) plist->x, (int) plist->y, i, pointstyle );
        plist = PTNextPoint(plist);
    }
    pl1 = POINTLIST;
    POINTLIST = BACKPOINT;
    SEQ = i;
    BACKPOINT = pl1;
}  /* end restorepoints */


LGUndo()
/* 
 *      This routine uses the information in the undo database to reconstruct
 * the PICTURE as it was before the last command.  The undo database is set
 * so that the next undo would nullify this one.
 * An undo of an Add is to delete the new element.
 * Add the old element back to undo a delete.
 * Modified elements are undone by copying the old element into the database
 * in place of the modified element.
 */

{
    UNELT *fix, *temp;
    ELT *(*e1);

    fix = unlist;       /* initialize unlist so that undo-ing can   */
    unlist = nullun;    /* add items to properly undo the undo      */
    if (fix == nullun)
    {
        fix = unback;
        unback = nullun;
    }
    DBClearSet();
    DISClearSetDisplay();
    while (fix != nullun)
    {
        switch (fix->action)
        {
            case ADD: DISScreenErase(fix->newelt, linemask);
                      /* TxMsgOK(); */
                      restorepoints();
                      DBDelete(fix->newelt, fix->dbase);
                      temp = fix->nextun;
                      free((char *) fix);
                      fix = temp;
                      break;

         case DELETE: fix->action = ADD;   /* create undo unelt */
                      fix->newelt = fix->oldelt;
                      fix->oldelt = NULL;
                      fix->newelt->nextelt = PICTURE;
                      restorepoints();
                      DBAddSet(fix->newelt);
                      DISScreenAdd(fix->newelt,(linemask|setmask));
                      PICTURE = fix->newelt;    /* put in database */
                      temp = fix->nextun;
                      fix->nextun = unlist;     /* link into unlist */
                      unlist = fix;
                      fix = temp;
                      break;

            case MOD: DISScreenErase(fix->newelt, linemask);
                      /* TxMsgOK(); */
                      restorepoints();
                      DISScreenAdd(fix->oldelt, (setmask | linemask));
                      DBAddSet(fix->oldelt);
                      e1 = fix->dbase;
                      while ( *e1 != fix->newelt )
                      {                     /* find elt to replace */
                          e1 = &(DBNextElt((*e1)));
                      }
                      fix->oldelt->nextelt = DBNextElt((*e1));
                      *e1 = fix->oldelt;
                      fix->oldelt = fix->newelt;
                      fix->newelt = *e1;     /* create undo unelt */
                      temp = fix->nextun;
                      fix->nextun = unlist;
                      unlist = fix;     /* link into unlist */
                      fix = temp;
                      break;

        }  /* end switch */;
    }  /* end while */
    Consume = FALSE;
}  /* LGUndo */


LGWrite()
/*
 *      This routine writes the current PICTURE into the specified filename
 * or to the current Editfile
 */

{
    FILE *fp, *fopen();
    char tname[50], filename[100], string[100], *tn, *fn, *wfile;
    ELT *elist;
    POINT *plist, pos;
    int i, space, stat;
	char *line;

	line = input_buffer;
    space = 100;
    ++line;
    tn = tname;  fn = filename;
    strcpy(tname,input_buffer);
    i = strlen(tname);
    if (i == 0)       /* no filename */
    {
        if ( *Editfile == '\0' )
        {
            error("Write:  write to where?");
            return;
        }
        fp = fopen(Editfile, "w");
        wfile = Editfile;
    }
    else
    {
    stat = PConvertTilde(&tn, &fn, &space);
    *fn = '\0';
    if (stat == FALSE)
    {
        sprintf(string, "Write:  unknown path %s", tname);
        error(string);
        return;
    }
        if ( !bang )  /* user doesn't insist */
        {
            fp = fopen(filename, "r");
            if ( fp != NULL )
            {
                 error("Write:  file already exists");
                 return;
            }
        }
        fp = fopen(filename, "w");
        wfile = filename;
    };
    if (fp == NULL)      /* file error */
    {
        (void) sprintf(string,"Write:  can't open %s", wfile);
        error(string);
        return;
    };
	sprintf(string,"writing '%s'.",wfile);
	message(string);
	XSync(0);
    CHANGED = FALSE;
    if (SEQ > 0)       /* specified a positioning point */
    {
        pos.x = POINTLIST->x;
        pos.y = POINTLIST->y;
    }
    else
    {
        if ( !DBNullelt(PICTURE) )
        {
            pos.x = PICTURE->ptlist->x;
            pos.y = PICTURE->ptlist->y;
        }
        else
        {
            pos.x = pos.y = 0;
        };
    }
    fprintf(fp,"gremlinfile\n");    /* write header */
    fprintf(fp, "%d %1.2f %1.2f\n", Orientation, pos.x, pos.y);
    elist = PICTURE;
    while ( !DBNullelt(elist) )    /* write each element */
    {
        fprintf(fp, "%d\n", elist->type);
        plist = elist->ptlist;
        while ( !Nullpoint(plist) )  /* write each point */
        {
            fprintf(fp, "%1.2f %1.2f\n",plist->x, ((float)FrameList[PAGE_WIN].height)-plist->y);
            plist = PTNextPoint(plist);
        }  /* end while plist */
        fprintf(fp, "%1.2f %1.2f\n", -1.0, -1.0);  /* end pointlist */
        fprintf(fp, "%d %d\n",elist->brushf, elist->size);
        fprintf(fp,"%d %s\n ", strlen(elist->textpt), elist->textpt);
        elist = DBNextElt(elist);
    }  /* end while */
    fprintf(fp,"%d\n",-1);   /* end of element list */
	sprintf(string,"done writing '%s'.",wfile);
	message(string);
    (void) fclose(fp);
}  /* end LGWrite */;


LGQuit(line)
char *line;
/*
 *      This routine terminates the editor.  The terminal states for the text
 * terminal and the graphics display are restored and an EXIT is performed.
 */

{
    if (!bang)
    {
        if (CHANGED)
        {
            error("Quit:  no write");
            return;
        }
    }  /* end if */;
    GRClose();
    exit(0);
}  /* end LGQuit */

LGHAdjust()
/*
 * Horizontal adjust -
 */

{
	Adjustment = HORZ;
	XBitmapBitsPut(FrameList[10].self,0,0,38,38,adjust_icons[Adjustment],BlackPixel,WhitePixel,0,icon_light[10],AllPlanes);
    Consume = FALSE;
}


LGVAdjust()
/*
 * Vertical adjust -
 */

{
	Adjustment = VERT;
	XBitmapBitsPut(FrameList[10].self,0,0,38,38,adjust_icons[Adjustment],BlackPixel,WhitePixel,0,icon_light[10],AllPlanes);
    Consume = FALSE;
}

LGMAdjust()
/*
 * Manhattan Adjust -
 */

{
	Adjustment = MAN;
	XBitmapBitsPut(FrameList[10].self,0,0,38,38,adjust_icons[Adjustment],BlackPixel,WhitePixel,0,icon_light[10],AllPlanes);
	Consume = FALSE;
}

static sign(x)
float x;
/*
 *      This local routine returns 1 if x >= 0
 * otherwise returns 0;
 */

{
    if (x >= 0) return(1);
    else  return(0);
}

LGMirror()
/*
 *      This routine mirrors the elements in the current set as defined
 * by points.  The mirroring is accomplished by defining a transformation
 * matrix and calling DBXform.
 */

{
    ELT *e1;
    POINT pt, pos, *p1, *p2;
    float xmat[3][2], scalex, scaley;
    int i, j;
	char *line;

	line = input_buffer;
    if (SEQ < 3)        /* not enough points */
    {
        error("Mirror:  not enough points");
        return;
    }
    if (DBNullelt(cset))
    {
        error("Mirror:  no current set");
        return;
    }

	GRBlankPoints();

    p1 = PTNextPoint(POINTLIST);
    p2 = PTNextPoint(p1);
    scalex = scaley = 1;
    if (sign(p1->x - POINTLIST->x) != sign(p2->x - POINTLIST->x))
        scalex = -scalex;
    if (sign(p1->y - POINTLIST->y) != sign(p2->y - POINTLIST->y))
        scaley = -scaley;

    /* create transformation matrix to translate set to origin, 
       performing the mirroring and translating back               */

    xmat[0][0] = scalex;
    xmat[1][1] = scaley;
    xmat[1][0] = xmat[0][1] = 0;
    xmat[2][0] = - POINTLIST->x * (scalex - 1.0);
    xmat[2][1] = - POINTLIST->y * (scaley - 1.0);
    e1 = cset;
    while ( !DBNullelt(e1) )
    {
        DISScreenErase(e1, (linemask | setmask));
        /* TxMsgOK(); */
        DBXform(e1, xmat, &PICTURE);
        if (TEXT(e1->type))
        {
            p1 = e1->ptlist;
            GRPutText(e1->type, p1, e1->brushf, e1->size,e1->textpt, &pos);
            i= strlen(e1->textpt);
            p2 = PTInit();
            (void) PTMakePoint(p1->x, p1->y, &p2);
                       /* add extra positioning points */
            (void) PTMakePoint(pos.x, pos.y, &p2);   
            (void) PTMakePoint(pos.x + i * charxsize / 2, pos.y, &p2);
            (void) PTMakePoint(pos.x + i * charxsize, pos.y, &p2);
            e1->ptlist = p2;
        }  /* end if TEXT */
        else
        {
            if (e1->type == ARC)   /* arcs require special handling */
                if (e1->size > 0)   /* circles are OK */
                    if (scalex * scaley < 0)  /* both directions OK */
                    {          /* swap starting and ending points of arc */
                        p1 = PTNextPoint(e1->ptlist);
                        p2 = PTNextPoint(p1);
                        pt.x = p1->x;
                        pt.y = p1->y;
                        p1->x = p2->x;
                        p1->y = p2->y;
                        p2->x = pt.x;
                        p2->y = pt.y;
                    }
            DISScreenAdd(e1, (linemask | setmask));
        }  /* end else */
        e1 = DBNextofSet(e1);
    }  /* end while */
    CHANGED = TRUE;
}  /* end LGMirror */


LGPath()
/*
 *      This routine looks at the command line for parameters to set
 * the current search path.
 */

{
    char path[100];
	char *line;

	line = input_buffer;
    if ( *line == '\0' ) 	/* no arguments */
		error("Path:  no argument.");
    else
    {
		SEARCH = TRUE;
		(void) sscanf(line, "%s", path);
		PSetPath(path);
    }
    Consume = FALSE;
}  /* end LGPath */

LGPrintPath()
{
	TextPut(path);
}

LGFont()
/*
 *      This routine looks at the command line for parameters to set
 * the current Font.
 */

{
    int new, index;
    char string[2], *line;

    Consume = FALSE;
	line = input_buffer;
    index = 0;
    if (isalpha(*line)) 
    {
        new = LGLookup(line, fonts, &index);
        if ( new >= 0) new = fnum[new];
        else new = BADNUM;
    }
    else new = GetNumParm(line, &index);
    if ( new > NFONTS|| new <= 0)
    {
        error("Font: bad argument.");
        return;
    }
	CFONT = new;
	XBitmapBitsPut(FrameList[7].self,0,0,38,38,font_icons[CFONT],BlackPixel,WhitePixel,0,icon_light[7],AllPlanes);
}  /* end LGFont */


LGJust()
/*
 *      This routine looks at the command line for parameters to set
 * the current text justification mode.
 */

{
    int new, index;
	char *line;

	line = input_buffer;
    Consume = FALSE;
    index = 0;
    if (isalpha(*line)) 
    {
      /* make sure mode is in lower case, and look up in table */
        if (isupper(*line))
        {
            *line = tolower(*line);
            *(line+1) = tolower(*(line+1));
        }
        for (new = 0; (strcmp(line, textpos[new]) != 0); ++new)
            if (new > jmodes)
            {
               error("Justify: no such mode");
               return;
            }
    }
    else new = GetNumParm(line, &index) - 1;
    if ( (new < 0) || (new > jmodes) )
    {
        error("Justify: bad arguments.");
        return;
    }
	new = textmode[new];
	CJUST = new;
	XBitmapBitsPut(FrameList[8].self,0,0,38,38,just_icons[CJUST],BlackPixel,WhitePixel,0,icon_light[8],AllPlanes);
}  /* end LGJust */


LGSize()
/*
 *      This routine changes the current character size.
 */

{
    int new, index;
    char string[2], *line;

	line = input_buffer;
    index = 0;
    new = GetNumParm(line, &index);
    if ( new <= 0 || new > NSIZES )
    {
        error("Size: bad arguments.");
        return;
    }    
	CSIZE = new;
	XBitmapBitsPut(FrameList[9].self,0,0,38,38,size_icons[CSIZE],BlackPixel,WhitePixel,0,icon_light[9],AllPlanes);
    Consume = FALSE;
}  /* end LGSize */

LGCSetPoints()
{
	if(CSETPOINTS)
	{
		MNUnHighLt(33);
		CSETPOINTS = 0;
	}
	else
	{
		MNHighLt(33);
		CSETPOINTS = 1;
	}
	Consume = FALSE;
}

LGDrawPolygon()
{
	ELT *e1;
	char *txt;
	POINT *p1, *p2, *plist;
	int stat;

	if (SEQ < 3)       /* not enough points */
	{
		error("Polygon: need at least 3 points");
		return;
	}
	GRBlankPoints();
	plist = PTInit();
	p1 = POINTLIST;
	(void) PTMakePoint(p1->x, p1->y, &plist);
	p2 = PTNextPoint(p1);
	while ( !Nullpoint(p2) )
	{
		(void) PTMakePoint(p2->x, p2->y, &plist);
		p1 = p2;
		p2 = PTNextPoint(p1);
	}  /* end while */;
	DBClearSet();         /* Clear current set, this element */
	DISClearSetDisplay(); /* the new current set             */
	/* GRsetwmask(linemask | setmask); */
	GRPolygon(plist, CBRUSH);
	txt = malloc(1);
	*txt = '\0';
	e1 = DBCreateElt(POLYGON, plist, CBRUSH, 0, txt, &PICTURE);
	DBAddSet(e1);
	CHANGED = TRUE;
}  /* end LGDrawPolygon */
