/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *  
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */

#include "gremlin.h"

/*
 *  crosshair cursor.
 */
short page_cursor_bits[] = {
   0xfc1f, 0xf367, 0xef7b, 0xdffd,
   0xdffd, 0xbf7e, 0xbf7e, 0x8c18,
   0xbf7e, 0xbf7e, 0xdffd, 0xdffd,
   0xef7b, 0xf367, 0xfc1f, 0xffff};

short page_cursor_mask_bits[] = {
   0x03e0, 0x0c98, 0x1084, 0x2002,
   0x2002, 0x4081, 0x4081, 0x73e7,
   0x4081, 0x4081, 0x2002, 0x2002,
   0x1084, 0x0c98, 0x03e0, 0x0000
};

/*
 *  pencil cursor.
 */
short text_cursor_mask_bits[] = {
   0x0000, 0x0000, 0x1000, 0x3800,
   0x1c00, 0x0a00, 0x0500, 0x0280,
   0x0140, 0x00a0, 0x0050, 0x0028,
   0x0014, 0x000c, 0x0002, 0x0000
};

short text_cursor_bits[] = {
   0xffff, 0xffff, 0xefff, 0xc7ff,
   0xe3ff, 0xf5ff, 0xfaff, 0xfd7f,
   0xfebf, 0xff5f, 0xffaf, 0xffd7,
   0xffeb, 0xfff3, 0xfffd, 0xffff
};

/*
 *  diamond cursor.
 */
short icon_cursor_mask_bits[] = {
   0x0100, 0x0380, 0x07c0, 0x0fe0,
   0x1ff0, 0x3ff8, 0x7ffc, 0xfffe,
   0x7ffc, 0x3ff8, 0x1ff0, 0x0fe0,
   0x07c0, 0x0380, 0x0100, 0x0000
};

short icon_cursor_bits[] = {
   0xfeff, 0xfc7f, 0xf93f, 0xf39f,
   0xe7cf, 0xcee7, 0x9c73, 0x3839,
   0x9c73, 0xcee7, 0xe7cf, 0xf39f,
   0xf93f, 0xfc7f, 0xfeff, 0xffff
};

/*
 *  information about each window.
 */
OpaqueFrame	FrameList[NUM_WINDOWS+1];
Window GremlinBase;
Window HelpWindow;

/*
 *  gremlin fonts for error messages and other trivia.
 */
Font	pointfont;
Font	text_win_font;

/*
 *  cursor junk
 */
Bitmap	Page_Bitmap, Page_Mask_Bitmap;
Bitmap	Text_Bitmap, Text_Mask_Bitmap;
Bitmap  Icon_Bitmap, Icon_Mask_Bitmap;
Cursor	Page_Cursor;
Cursor  Text_Cursor;
Cursor	Icon_Cursor;

/*
 *  X patterns for gremlin brushes.  1--NBRUSHES are used for items not in
 *  the current set, NBURSHES+1--NBRUSHES*2 for current set.
 */
Pattern brush[2*NBRUSHES+1];

extern XButtonPressedEvent	event;
extern float PX, PY;

/*
 *  just in case somebody tries iconifying a window.
 */
char*	WindowNames[NUM_WINDOWS+1] = {
	"vector","arc","spline","box","arrow","text",
	"brush","font","justify","size","adjust","redraw",
	"bang","gravity","grid","define","include","erase",
	"move","copy","scale","rotate","mirror","read",
	"write","quit","undo","align","buffer","clear points",
	"move point","path","point","halftone","help","current set",
	"Gremlin","Text"
};

short grey[16] = {
	0xaaaa, 0x5555, 0xaaaa, 0x5555,
	0xaaaa, 0x5555, 0xaaaa, 0x5555,
	0xaaaa, 0x5555, 0xaaaa, 0x5555,
	0xaaaa, 0x5555, 0xaaaa, 0x5555,
};
Pixmap greypixmap;

/*
 *  Initialize the X windows and events.
 */
XInit()
{
	int	count,numopen;

	/*
	 *  Open the display.
	 */
	
	if(!XOpenDisplay(0)) {
		fprintf(stderr,"Gremlin:  can't open display.\n");
		exit(-1);
	}

	if((pointfont = XGetFont("6x10"))==0)
		fprintf(stderr,"Gremlin:  can't get 6x10 font.\n");
	if((text_win_font = XGetFont("9x15"))==0)
		fprintf(stderr,"Gremlin:  can't get 9x15 font.\n");
	greypixmap = XStorePixmapXY(16,16,grey);

	for(count=0;count<PAGE_WIN;count++) {
		FrameList[count].x=40*(count%3);
		FrameList[count].y=40*(count/3);
		FrameList[count].width=38;
		FrameList[count].height=38;
		FrameList[count].bdrwidth=1;
		FrameList[count].border=BlackPixmap;
		FrameList[count].background=BlackPixmap;
	}
	FrameList[PAGE_WIN].x = 120;
	FrameList[PAGE_WIN].y = 0;
	FrameList[PAGE_WIN].width = 820;
	FrameList[PAGE_WIN].height = 788;
	FrameList[PAGE_WIN].bdrwidth = 1;
	FrameList[PAGE_WIN].border = BlackPixmap;
	FrameList[PAGE_WIN].background = WhitePixmap;

	FrameList[PAGE_WIN+1].x = 120;
	FrameList[PAGE_WIN+1].y = 790;
	FrameList[PAGE_WIN+1].width = 820;
	FrameList[PAGE_WIN+1].height = 50;
	FrameList[PAGE_WIN+1].bdrwidth = 1;
	FrameList[PAGE_WIN+1].border = BlackPixmap;
	FrameList[PAGE_WIN+1].background = WhitePixmap;
	
	GremlinBase = XCreateWindow(RootWindow,
		10, 25, 940, 840, 1,
		BlackPixmap, BlackPixmap);
	XSelectInput(GremlinBase,ExposeWindow);
	if((numopen=XCreateWindows(GremlinBase,FrameList,NUM_WINDOWS+1))!=NUM_WINDOWS+1)
	{
		fprintf(stderr,"Gremlin: only made %d of %d windows.\n",numopen,NUM_WINDOWS);
		exit(-1);
	}

	if((HelpWindow = XCreateWindow(GremlinBase,130,10,800,400,1,BlackPixmap,WhitePixmap))==0)
	{
		TextPut("help! couldn't create help window.");
		exit(-1);
	}
	XSelectInput(HelpWindow,ButtonPressed);
	Icon_Bitmap = XStoreBitmap(16,16,icon_cursor_bits);
	Icon_Mask_Bitmap = XStoreBitmap(16,16,icon_cursor_mask_bits);
	Icon_Cursor = XStoreCursor(Icon_Bitmap,Icon_Mask_Bitmap,7,7,WhitePixel,BlackPixel,GXinvert);
	XMapWindow(GremlinBase);
	for(count=0;count<=PAGE_WIN+1;count++) {
		XSelectInput(FrameList[count].self,ButtonPressed|ExposeWindow|KeyPressed);
		XStoreName(FrameList[count].self,WindowNames[count]);
		XMapWindow(FrameList[count].self);
		XDefineCursor(FrameList[count].self,Icon_Cursor);
	}
	Page_Bitmap = XStoreBitmap(16,16,page_cursor_bits);
	Page_Mask_Bitmap = XStoreBitmap(16,16,page_cursor_mask_bits);
	Text_Bitmap = XStoreBitmap(16,16,text_cursor_bits);
	Text_Mask_Bitmap = XStoreBitmap(16,16,text_cursor_mask_bits);
	Page_Cursor = XStoreCursor(Page_Bitmap,Page_Mask_Bitmap,7,7,WhitePixel,BlackPixel,GXinvert);
	Text_Cursor = XStoreCursor(Text_Bitmap,Text_Mask_Bitmap,1,15,WhitePixel,BlackPixel,GXinvert);
	XDefineCursor(FrameList[PAGE_WIN].self,Page_Cursor);
	XDefineCursor(FrameList[PAGE_WIN+1].self,Text_Cursor);
	
	XFeepControl(3);

	brush[1] = XMakePattern(2,2,3);
	brush[2] = XMakePattern(20,5,3);
	brush[3] = XMakePattern(0,1,1);
	brush[4] = XMakePattern(56,6,3);
	brush[5] = XMakePattern(0,1,1);
	brush[6] = XMakePattern(0,1,1);
	brush[7] = XMakePattern(2,2,1);
	brush[8] = XMakePattern(20,5,2);
	brush[9] = XMakePattern(2,2,1);
	brush[10] = XMakePattern(56,6,1);
	brush[11] = XMakePattern(2,2,1);
	brush[12] = XMakePattern(2,2,1);
	
	XSync(0);
}

/*
 *  This routine moves all windows back to their original positions
 *  and raises them.
 */
XRelocate()
{
	int count;
	for(count=0;count<PAGE_WIN;count++) {
		XMoveWindow(FrameList[count].self,10+40*(count%3),25+40*(count/3));
		XRaiseWindow(FrameList[count].self);
	}
	XMoveWindow(FrameList[PAGE_WIN].self,130,25);
	XRaiseWindow(FrameList[PAGE_WIN].self);
	XMoveWindow(FrameList[PAGE_WIN+1].self,130,815);
	XRaiseWindow(FrameList[PAGE_WIN+1].self);
}
