.TH XWININFO 1 "27 July 1985" "X Version 10"
.SH NAME
xwininfo - X Window System, window information summarizer.
.SH SYNOPSIS
.B "xwininfo"
[ -children ] [ -help ] [ -id \fIid\fP ] [ -int ] [ -root ] [ \fIhost\fP:\fIdisplay\fP ]
.SH DESCRIPTION
.PP
.I Xwininfo
is  a  utility  for  displaying  X  window information summaries.  All
pertinent window  information  is  displayed  in  an  easily  readable
format.   The  user has the option of selecting the target window with
the mouse (by clicking any mouse button in the desired window)  or  by
specifying its' window id on the command line with the \fB-id\fP argument.
There is also a special \fB-root\fP argument to quickly obtain information
on X's root window.  The following is a sample summary taken with
the \fB-children\fP argument specified.

xwininfo ==> Please select the window you wish
         ==> information on by clicking the
         ==> mouse in that window.

xwininfo ==> Window name: ' X Root Window '
         ==> Window id: 0x10031
         ==> Parent window id: 0x0
         ==> Number of children: 13
         ====> Child window id: 0xb00046
         ====> Child window id: 0xb2004f
         ====> Child window id: 0x630051
         ====> Child window id: 0x5f0055
         ====> Child window id: 0x5c0058
         ====> Child window id: 0x55005c
         ====> Child window id: 0x53005e
         ====> Child window id: 0x510060
         ====> Child window id: 0x42000c
         ====> Child window id: 0x43000b
         ====> Child window id: 0x3d0011
         ====> Child window id: 0xa0028
         ====> Child window id: 0x500061
         ==> Associated window id: 0x0
         ==> Window type: IsOpaque
         ==> Window state: IsMapped
         ==> Upper left X: 0
         ==> Upper left Y: 0
         ==> Width: 1088
         ==> Height: 864
         ==> Border width: 0
         ==> Resize base width: 0
         ==> Resize base height: 0
         ==> Resize width increment: 1
         ==> Resize height increment: 1
         ==> Root absolute mouse X Position: 691
         ==> Root absolute mouse Y Position: 261
         ==> Target relative mouse X Position: 691
         ==> Target relative mouse Y Position: 261

.SH ARGUMENT SUMMARY
.PP
.TP 8
.B "-children"
This  argument  specifies that
.I xwininfo
should list the window ids' of
target  window's  children.   Only  the  first  level  of  the  window
hierarchy is shown (i.e., immediate children of the target window).
.PP
.TP 8
.B "-help"
Print out the 'Usage:' command syntax summary.
.PP
.TP 8
.B "-id \fIid\fP"
This argument allows the user to specify a target  window  \fIid\fP  on  the
command  line rather than using the mouse to select the target window.
This is very useful in  debugging  X  applications  where  the  target
window is not mapped to the screen or where the use of the mouse might
be impossible or interfere with the application.
.PP
.TP 8
.B "-int"
This argument specifies that all X window ids should be  displayed  as
integer values.  The default is to display them as hexadecimal values.
.PP
.TP 8
.B "-root"
This  argument  specifies  that  X's root window is the target window.
This is useful in situations  where  the  root  window  is  completely
obscured.
.PP
.TP 8
.B "\fIhost\fP:\fIdisplay\fP"
This  argument  allow  you  to  specify the host and display number on
which to find the target window.  For example `xwininfo orpheus:1'
would specify that the target window is on display `1' on the machine
`orpheus'.  By default,
.I xwininfo
uses  the  host  and display number stored in the environment variable
DISPLAY, and therefore this argument is not normally specified.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get default host and display number.
.SH SEE ALSO
X(1)
.SH FUTURE PLANS
If time ever presents itself...
.PP
.TP 8
.B 1.
Provide a `-geometry' argument that prints out the window's dimensions
in X window geometry format (i.e., =WxH+X+Y)
.PP
.TP 8
.B 2.
Provide a `-depth' argument that allows  recursive  traversal  of  the
window hierarchy to some arbitrary depth.
.SH AUTHOR
.PP
Copyright 1985, Massachusetts Institute of Technology.
.PP
Tony Della Fera, Digital Equipment Corp., MIT Project Athena
