/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)uba.c	7.1 (Berkeley) 6/5/86
 */
/*
#ifndef lint
static char rcs_id[] = {"$Header: uba.c,v 2.1 86/08/13 10:50:20 root Exp $"};
#endif not lint
*/
/*
 * RCS Info
 *	$Locker: root $
 */

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/vm.h"
#include "../h/time.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../ufs/inode.h"
#include "../ufs/fs.h"

#include "../vax/cpu.h"
#include "../vaxuba/ubareg.h"

#include "saio.h"
#include "savax.h"

/*
 * Note... this routine does not
 * really allocate; unless bdp == 2
 * you always get the same space.
 * When bdp == 2 you get some other space.
 */
ubasetup(io, bdp)
	register struct iob *io;
	int bdp;
{
	int npf;
	unsigned v;
	register struct pte *pte;
	int o, temp, reg;
	static int lastreg = 128+64;

	/* Get page number that start of buffer is in. */
	v = btop(io->i_ma);
	/* Get offset within that page. */
	o = (int)io->i_ma & PGOFSET;
	/* Find out how many pages we need to map. */
	npf = btoc(io->i_cc + o) +1;
	/* If we've asked for bdp 2, allocate a new set of registers. */
	if (bdp == 2) {
		reg = lastreg;
		lastreg += npf;
		bdp = 0;
	} else
		reg = 0;
	
	/* Get address of first map register */
	/* (Why the hell it's a pte * is anyone's guess) */
	pte = &ubauba(io->i_unit)->uba_map[reg];

	/* set BDP and valid bits */
	temp = (bdp << 21) | UBAMR_MRV;

	/* If we're using a BDP and it's an odd addr, set offset bit */
	if (bdp && (o & 01))
		temp |= UBAMR_BO;
	/* 21 bits because this might be a bigger vax */
	v &= 0x1fffff;			/* drop to physical addr */

	/* Fill in map entries */
	while (--npf != 0)
		*(int *)pte++ = v++ | temp;

	/* Zero the last entry */
	*(int *)pte++ = 0;

	/* Return enough information to uniquely identify this mapping */
	return ((bdp << 28) | (reg << 9) | o);
}


ubafree(io, mr)
	struct iob *io;
	int mr;
{
	register int bdp;
 
	bdp = (mr >> 28) & 0x0f;
	if (bdp == 0)
		return;
	switch (cpu) {

	case VAX_8600:
	case VAX_780:
		ubauba(io->i_unit)->uba_dpr[bdp] |= UBADPR_BNE;
		break;

	case VAX_750:
		ubauba(io->i_unit)->uba_dpr[bdp] |=
		     UBADPR_PURGE|UBADPR_NXM|UBADPR_UCE;
		break;
	case VAX_730:
		break;
	}
}
