#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/buf.h"
#include "../h/map.h"
#include "../h/vm.h"

#include "../vaxmba/mbavar.h"
#include "../vaxuba/ubavar.h"


#define C (caddr_t)

extern struct uba_driver tmscpdriver;
extern Xtmscpintr0();
int	 (*tmscpint0[])() = { Xtmscpintr0, 0 } ;
extern struct uba_driver udadriver;
extern Xudintr0();
int	 (*udaint0[])() = { Xudintr0, 0 } ;
extern struct uba_driver udadriver;
extern Xudintr1();
int	 (*udaint1[])() = { Xudintr1, 0 } ;
extern struct uba_driver hldriver;
extern Xrlintr0();
int	 (*hlint0[])() = { Xrlintr0, 0 } ;
extern struct uba_driver fxdriver;
extern Xrxintr0();
int	 (*fxint0[])() = { Xrxintr0, 0 } ;
extern struct uba_driver zsdriver;
extern Xtsintr0();
int	 (*zsint0[])() = { Xtsintr0, 0 } ;
extern struct uba_driver dmfdriver;
extern Xdmfsrint0(), Xdmfsxint0(), Xdmfdaint0(), Xdmfdbint0(), Xdmfrint0(), Xdmfxint0(), Xdmflint0();
int	 (*dmfint0[])() = { Xdmfsrint0, Xdmfsxint0, Xdmfdaint0, Xdmfdbint0, Xdmfrint0, Xdmfxint0, Xdmflint0, 0 } ;
extern struct uba_driver dedriver;
extern Xdeintr0();
int	 (*deint0[])() = { Xdeintr0, 0 } ;

struct uba_ctlr ubminit[] = {
/*	 driver,	ctlr,	ubanum,	alive,	intr,	addr */
	{ &tmscpdriver,	0,	'?',	0,	tmscpint0, C 0174500 },
	{ &udadriver,	0,	  0,	0,	udaint0, C 0172150 },
	{ &udadriver,	1,	'?',	0,	udaint1, C 0160334 },
	{ &hldriver,	0,	  0,	0,	hlint0, C 0174400 },
	{ &fxdriver,	0,	  0,	0,	fxint0, C 0177170 },
	{ &zsdriver,	0,	  0,	0,	zsint0, C 0172520 },
	0
};

struct uba_device ubdinit[] = {
	/* driver,  unit, ctlr,  ubanum, slave,   intr,    addr,    dk, flags*/
	{ &tmscpdriver,   0,     0,  '?',     0,        0, C 00     ,  0,  0x0 },
	{ &udadriver,   0,     0,    0,     0,        0, C 00     ,  1,  0x0 },
	{ &udadriver,   1,     0,    0,     1,        0, C 00     ,  1,  0x0 },
	{ &udadriver,   2,     0,    0,     2,        0, C 00     ,  1,  0x0 },
	{ &udadriver,   3,     0,    0,     3,        0, C 00     ,  1,  0x0 },
	{ &udadriver,   4,     1,  '?',     0,        0, C 00     ,  1,  0x0 },
	{ &udadriver,   5,     1,  '?',     1,        0, C 00     ,  1,  0x0 },
	{ &hldriver,   0,     0,    0,     0,        0, C 00     ,  1,  0x0 },
	{ &fxdriver,   0,     0,    0,     0,        0, C 00     ,  1,  0x0 },
	{ &fxdriver,   1,     0,    0,     1,        0, C 00     ,  1,  0x0 },
	{ &zsdriver,   0,     0,    0,     0,        0, C 00     ,  0,  0x0 },
	{ &dmfdriver,   0,    -1,    0,    -1,   dmfint0, C 0160340,  0,  0xfc },
	{ &dedriver,   0,    -1,  '?',    -1,   deint0, C 0174510,  0,  0x0 },
	0
};
