.TH XDEMO 1 "12 December 1985" "X Version 10"
.SH NAME
xdemo - demonstration program for X window system
.SH SYNOPSIS
.B xdemo
[ options ] demo [ =\fIgeometry\fP ] [ \fIhost\fP:\fInumber\fP ]
.SH DESCRIPTION
.I Xdemo
is a demonstration program for the X window system.
By default, the host and display number are extracted from the
environment variable ``DISPLAY''.
One can, however, specify a different display.
.I Host
specifies the host,
and
.I number
specifies the number of the display.  For example, ``xdemo star orpheus:1''
will put the star demo on display one on machine orpheus.
Demo can be any of: balls, bounce, circle, circles, colors, cookie, draw, life,
lines, menulife, motion, plaid, qix, rgb, shades, slide, star, tetra,
wallpaper, web, and xor.
The colors, rgb, and shades demos will only work on color displays.
.PP
The window is created in the usual way using one of the mouse buttons.
Using the center button, depress the button to define one corner of the window,
move the cursor to where the opposite corner of the window should be
and release the button.  Using the right button, depress the button to
define the default size window, move the cursor to position the window,
and release the button.  Using the left button for all demos but colors,
life, and menulife, click the left button to place the default size window
in the upper left corner of the screen.  Using the left button for the
colors, life, and menulife demos, depress the button to define the default
size window, move the cursor to position the window, and release the button.
.PP
The window can also be placed, or given a default size, with the standard
geometry specification:
.br
	\fB=\fP\fIgeometry\fP
.br
The geometry specification can be used to set the size and location of the
window.
See \fIX(1)\fP for details.
.PP
Most of the demos run without user input: balls, bounce, circle, circles,
colors, lines, plaid, qix, slide, star, tetra, wallpaper, web, and xor.
Most of these have random number generators built in, and will produce
different results each time they are run, or each time the window is
resized.
.PP
.SH "MOUSE USAGE"
.PP
Mouse usage only applies on the demos draw, life, menulife, motion, rgb, and
shades.
.PP
In the draw demo, clicking the left button defines points that will
be connected by a spline when the center button is clicked.
If the center button is clicked twice in a row, the window is cleared.
Clicking the right button defines points to be connected by straight lines
when the center button is clicked.
Left and right button clicks can be combined in a single shape.
Clicking any button in one of the selection boxes at the upper left selects
a drawing mode: patterned gray line, solid white line, solid black line, dashed
white line, dashed black line, filled black, filled white, and filled gray.
The drawing function can be selected by placing the cursor over the function
box at the top right and typing a single hexadecimal digit (corresponding
to the characteristic function).  For line drawing, the brush height and width
can be adjusted by placing the cursor over the height or width box and typing
a single hexadecimal digit.  Text can be put into the picture by positioning
the mouse and typing.  The color of the text is determined from the line/fill
color, and the display function is applied.
.PP
The motion demo uses the mouse to define points of a shape just as in the draw
demo, but moves the line drawing around the window, bouncing off the walls,
while randomly changing the points relative to each other.
.PP
The life demo uses the left button to randomly insert occupied cells into the
window and start the life program initially.
Clicking the center button will turn life on and off, so you can look
at interesting intermediate patterns,
and the right button is used to clear the `universe'.
.PP
The menulife demo uses the left button to set/clear individual cells while
the button is held down.  The right button and the space bar can be used
to single step the generations.  The middle button pops up a pull down menu.
Release the middle button on a selection for it to take effect; release outside
of all selections to abort.  Changing rules takes a long time.
.PP
The rgb demo uses button operations in the three boxes at the top of the window
to change color values.  The left button decrements the value, the right
button increments the value.  If you press the middle button and then
move around, the vertical position of the mouse controls the value, with zero
intensity at the top of the box, and full intensity at the bottom of the box;
releasing the mouse button sets the final value.
.PP
The shades demo uses button clicks to change color values.  A matrix of two
primary colors of varying intensity, with a third primary of constant intensity
is displayed.  The right button increments the value of the third primary, the
left button decrements the value, and the middle button switches to a different
pair of initial primaries.
.SH OPTIONS
On color displays, colors can be specified in the command line:
.PP
.nf
	\fB-fg=\fP\fIcolor\fP		foreground (lines, text, etc.)
	\fB-bg=\fP\fIcolor\fP		background
	\fB-bd=\fP\fIcolor\fP		border
	\fB-ms=\fP\fIcolor\fP		mouse
	\fB-fn=\fP\fIfont\fP		font
.fi
.PP
Many demos ignore the foreground color and do random color selection.
.SH X DEFAULTS
.PP
For the following defaults, you can also give a demo-specific default by
prepending the demo name and a separating period, e.g., ``Plaid.Foreground''.
.PP
.TP 8
.B Background
To determine the background color.
.PP
.TP 8
.B Border
To determine the border color.
.PP
.TP 8
.B BorderWidth
To determine the border width.
.PP
.TP 8
.B BodyFont
To determine text font.
.PP
.TP 8
.B Foreground
To determine the foreground color.
.PP
.TP 8
.B Mouse
To determine the mouse cursor color.
.PP
.TP 8
.B MenuBackground
To determine the menu background color in menulife.
.PP
.TP 8
.B MenuForeground
To determine the menu text color in menulife.
.PP
.TP 8
.B MenuFont
To determine menu text font.
.PP
.TP 8
.B MenuMouse
To determine the menu mouse cursor color in menulife.
.SH COOKIE
The cookie monster wants you to give it a ``cookie'', of course.
.SH ENVIRONMENT
DISPLAY	This program gets the display to use by default from this variable.
.SH AUTHOR
Bob Scheifler, MIT Laboratory for Computer Science.
Many of the demos are ripoffs:
balls, bounce, circle, circles, lines, plaid, slide, tetra, wallpaper, and xor
were taken from Lucasfilm,
web was taken from Steve Ward,
and qix from Symbolics.
Menulife written by Paul Johnson, MIT Laboratory for Computer Science.
.br
Copyright (c) 1985, Massachusetts Institute of Technology
.SH "SEE ALSO"
X(1), xterm(1), xwm(1)
