.TH PSDIT 1 "12 Nov 1985" "Adobe Systems"
\" RCSID: $Header: psdit.1p,v 2.1 85/11/24 12:39:23 shore Rel $
.ds PS P\s-2OST\s+2S\s-2CRIPT\s+2
.SH NAME
psdit \- convert ditroff intermediate format to P\s-2OST\s+2S\s-2CRIPT\s+2 format
.SH SYNOPSIS
.B psdit
[
.BI \-F fontdir
] [
.BI \-p prologue
] [
.BI \-o list
] [
.I file
]
.SH DESCRIPTION
.I psdit
translates a
.I file
created by device-independent
.RI [ di ] troff (1)
to \*(PS format for printing on a \*(PS printer.
If no
.I file
is mentioned, the standard input is used.
The \*(PS file is sent to the standard output.
The options are:
.TP
.BI \-F " fontdir"
take font information from
.I fontdir
instead of the default (see below).
.TP
.BI \-p " prologue"
use the contents of
.I prologue
instead of the default \*(PS prologue (see below).
.TP
.BI \-o " list"
prints pages whose numbers are given in the comma-separated
.IR list .
The list contains single numbers
.I N
and ranges
.IB N1 \- N2.
A missing 
.I N1
means the lowest-numbered page, a missing
.I N2
means the highest.
.PP
.B Note:
the input for 
.I psdit
should be prepared with the corresponding
.B \-Tpsc
option of
.RI [ di ] troff , 
.IR pic ,
etc.
.br
.I eqn
should be run with the flags
.B \-r576
and
.BR \-m2
to produce suitable output.  
.br
.I pic
should be run with the 
.B \-D
flag.
With 
.B DWB
.IR pic ,
use
.B \-T576
to set the correct resolution.
.PP
.I psdit
allows for users to cause 
.I troff
to include arbitrary \*(PS code in the generated \*(PS file.
.I psdit 
recognizes the heretofore undefined ``%'' command in the
ditroff intermediate file format to signal the start of raw \*(PS
to be placed 
.I 
as is
in the the output file.  Everthing between (but not including)
the percent sign and a line containing a single period (``.'') will
be placed in the generated \*(PS output.  This \*(PS is not insulated
from the 
.I ditroff
coordinate system or the state of the generated \*(PS. However, two functions
are defined in the prologue so that user's may insulate themselves if they
so desire.  The 
.B PB
function (for \fIpicture begin\fP) will perform a \*(PS 
.B save 
operation, translate the \*(PS coordinate system to 
.I ditroff's
idea of the current position on the page, and change the scale and
orienation of the coordinate system axes to be the standard \*(PS 72 units
per inch.  The
.B PE
macro (for \fIpicture end\fP) will end this protected environment.
.LP
Several methods may be employed to incorporated such included \*(PS
into the ditroff intermediate file.  The ``.cf'' ``.sy'' and ``\\\&!''
.I troff
commands may be useful.
For example, the following sequence may appear in \fItroff\fP input:
.RS
(usual troff input)
.br
\\\&!%PB
.br
\&.cf mypic.ps
.br
\\\&!PE
.br
\\\&!.
.br
(more regular troff input)
.RE
to include 
.I mypic.ps
as an illustration.  This facility is both powerful and useful,
but indiscriminate inclusion of badly-behaving \*(PS code may be
dangerous to your document's health.
.SH ENVIRONMENT
.TP
PSLIBDIR
path name of a directory to use instead of
/usr/misc/lib/ps for psdit prologue.
.SH FILES
.TP 2.2i
/usr/misc/lib/font/devpsc/*
\fIditroff\fR default description files for \*(PS virtual device.
.TP
/usr/misc/lib/ps/psdit.pro
default \*(PS prologue.
.SH "SEE ALSO"
psroff(1).
.br
4.2bsd: ditroff(1), lpr(1).
.br
System V: troff(1), lp(1).
.br
\fIA Typesetter-independent TROFF\fR Brian W. Kernighan, Bell Laboratories 1982
.br
.I
Documenter's Workbench
.SH AUTHOR
Adobe Systems Incorporated
.SH BUGS
The versions of 
.I eqn
and 
.I pic
distributed with ditroff (from AT&T) have the device names compiled in
(so much for device independence!).  They should just read the device
description file for the information they need.  You must be careful
to know which version of 
.I eqn 
you are running or you will get undesirable results.
.br
The B-splines generated by
.I ditroff
are drawn with an approximation.  The functions 
.B D~
and 
.B D~~
in the prologue need a little work.
.SH NOTES
\*(PS is a trademark of Adobe Systems Incorporated.
.br
Documenter's Workbench is a trademark of AT&T Technologies.
