


KEYCOMP(1)          UNIX Programmer's Manual           KEYCOMP(1)



NAME
     keycomp - X window system keyboard mapping file compiler

SYNOPSIS
     keycomp < input_file > output_file

DESCRIPTION
     Programs that use the X window system, such as _x_t_e_r_m(_1),
     need some way to translate the user's key strokes into char-
     acter strings.  Such programs look up this keyboard-to-
     character string mapping in a binary keymap file by calling
     the library routine _X_L_o_o_k_u_p_M_a_p_p_i_n_g.  Initially, this routine
     looks for the file ._X_k_e_y_m_a_p in the user's home directory; if
     this file doesn't exist, uses a built in table.

     The compiled file format produced by _k_e_y_c_o_m_p should be port-
     able across machine architectures.

     The _k_e_y_c_o_m_p program (an abbreviation for ``keymap com-
     piler'') reads in a textual description of this mapping and
     produces a binary keymap file on its standard output.

     Each key may have up to 16 different bindings, depending on
     what combinations of the Shift, Lock, Control, and Meta keys
     are depressed.  For instance, in a conventional QWERTY key-
     board mapping, pressing the ``A'' key produces a capital
     ``A'' when the Shift or Lock key is down, an octal 001 when
     the Control key is down, and a small ``a'' when no other key
     is down.

     The input file to _k_e_y_c_o_m_p consists of one or more lines.
     Each line begins with an octal or decimal number designating
     an X keyboard code.  After the key code, the line should
     contain either 1 or 16 items, each representing the binding
     for a particular combination of the Control, Meta, Shift,
     and Lock keys.  The items should be separated by white
     space; the format of the items is described later.  The
     bindings should be in this order:

     #1   ``unshifted'':  none of Shift, Lock, Control, or Meta
     keys down
     #2   Lock key down
     #3   Shift key down
     #4   Shift and Lock keys down
     #5   Meta key down
     #6   Meta and Lock keys down
     #7   Meta and Shift keys down
     #8   Meta, Shift, and Lock keys down
     #9   Control key down
     #10  Control and Lock keys down
     #11  Control and Shift keys down
     #12  Control, Shift, and Lock keys down



Printed 12/6/86          18 August 1985                         1






KEYCOMP(1)          UNIX Programmer's Manual           KEYCOMP(1)



     #13  Control and Meta keys down
     #14  Control, Meta, and Lock keys down
     #15  Control, Meta, and Shift keys down
     #16  Control, Meta, Shift, and Lock keys down

     If only one item is present on the line, then it represents
     the binding for this key regardless of the positions of the
     Control, Meta, Shift, and Lock keys.

     Each item should be one of the following:

         An octal or decimal number, indicating a character code

         A C character literal, surrounded by single quotes.
     Escape sequences (such as `0 or `252') are allowed, as
     described in the C Reference Manual.

         A C string literal, surrounded by double quotes.  Again,
     standard C escape sequences are allowed within the string.

         The letter U, indicating ``no binding''.  If there is no
     binding, then XLookupMapping will return an empty string for
     this key combination.

     A comma may, but need not, follow each item.  Whether or not
     a comma is present, white space (spaces or tabs) must
     separate the items.  All text to the right of the 16th item
     is ignored; comments may appear here.

     Completely blank lines are ignored, as are lines beginning
     with the '#' character.  Furthermore, all text between a `#'
     character and the following newline is ignored, provided
     that the `#' is not part of a string enclosed in single or
     double quotes.  This allows you to place comments at the end
     of a line that contains only a single item.

     You can look at the file <_X/_X_k_e_y_b_o_a_r_d._h> for a list of key
     codes and key names of function keys.


FILES
     $HOME/.Xkeymap, /usr/lib/Xkeymap.txt, <X/Xkeyboard.h>

SEE ALSO
     X(1), xterm(1)

DIAGNOSTICS
     ``Couldn't fseek output file''
     The standard output must be a file, not a pipe or a termi-
     nal.

     ``Error writing beginning of output file''



Printed 12/6/86          18 August 1985                         2






KEYCOMP(1)          UNIX Programmer's Manual           KEYCOMP(1)



     ``Error writing extension to output file''
     _k_e_y_c_o_m_p couldn't write the output file.  Maybe the file sys-
     tem is out of space.

     ``Parse error at item <number> on line <number>:
          <message>''
     The source file has a syntax error.  Possible <message>s
     include:

     ``Line doesn't begin with key''
     The first few characters in the line, which should be a key
     number, were not recognizable as an octal or decimal number.

     ``Keycode is too big''
     The key at the beginning of the line was greater than 0377
     (octal).

     ``Line doesn't have 1 or 16 entries''
     After the key, more than one but less than 16 items were
     found.  Or no items were found at all.

     ``Number after backslash is too big for a character con-
     stant''
     In a character constant of the form `0n', the octal number
     was greater than 377 (octal).

     ``Closing single quote not found''
     A single quote (') was encountered, but the end of the line
     was reached before finding the matching closing single
     quote.

     ``String is too long''
     More than 80 characters are not allowed between double
     quotes.

     ``Closing double quote not found''
     A double quote (") was encountered, but the end of the line
     was reached before finding the matching closing double
     quote.

     ``Too many characters for single character constant''
     Too many characters appear between single quotes.  If you
     want to bind a key to a multiple-character sequence, use
     double quotes.

     ``Not a U, number, single- or double-quoted string''
     _k_e_y_c_o_m_p can't parse this item; it is neither the letter U,
     nor an octal or decimal number, nor a string enclosed in
     single or double quotes.

AUTHOR
     Ron Newman, MIT Project Athena



Printed 12/6/86          18 August 1985                         3






KEYCOMP(1)          UNIX Programmer's Manual           KEYCOMP(1)



     Copyright 1985, 1986, Massachusetts Institute of Technology.
     See _X(_1) for a full copyright notice.





















































Printed 12/6/86          18 August 1985                         4



