


RLOG(1)             UNIX Programmer's Manual              RLOG(1)



NAME
     rlog - print log messages and other information about RCS
     files

SYNOPSIS
     rlog [ options ] file ...

DESCRIPTION
     _R_l_o_g prints information about RCS files.  Files ending in
     `,v' are RCS files, all others are working files. If a work-
     ing file is given, _r_l_o_g tries to find the corresponding RCS
     file first in directory ./RCS and then in the current direc-
     tory, as explained in _c_o (1).

     _R_l_o_g prints the following information for each RCS file: RCS
     file name, working file name, head (i.e., the number of the
     latest revision on the trunk), access list, locks, symbolic
     names, suffix, total number of revisions, number of revi-
     sions selected for printing, and descriptive text. This is
     followed by entries for the selected revisions in reverse
     chronological order for each branch. For each revision, _r_l_o_g
     prints revision number, author, date/time, state, number of
     lines added/deleted (with respect to the previous revision),
     locker of the revision (if any), and log message.  Without
     options, _r_l_o_g prints complete information.  The options
     below restrict this output.

     -L        ignores RCS files that have no locks set; con-
               venient in combination with -R, -h, or -l.

     -R        only prints the name of the RCS file; convenient
               for translating a working file name into an RCS
               file name.

     -h        prints only RCS file name, working file name,
               head, access list, locks, symbolic names, and suf-
               fix.

     -t        prints the same as -h, plus the descriptive text.

     -d_d_a_t_e_s   prints information about revisions with a checkin
               date/time in the ranges given by the semicolon-
               separated list of _d_a_t_e_s.  A range of the form
               _d_1<_d_2 or _d_2>_d_1 selects the revisions that were
               deposited between _d_1 and _d_2, (inclusive).  A range
               of the form <_d or _d> selects all revisions dated _d
               or earlier.  A range of the form _d< or >_d selects
               all revisions dated _d or later.  A range of the
               form _d selects the single, latest revision dated _d
               or earlier.  The date/time strings _d, _d_1, and _d_2
               are in the free format explained in _c_o (1). Quot-
               ing is normally necessary, especially for < and >.



Printed 1/10/87              6/29/83                            1






RLOG(1)             UNIX Programmer's Manual              RLOG(1)



               Note that the separator is a semicolon.

     -l[_l_o_c_k_e_r_s]
               prints information about locked revisions.  If the
               comma-separated list _l_o_c_k_e_r_s of login names is
               given, only the revisions locked by the given
               login names are printed.  If the list is omitted,
               all locked revisions are printed.

     -r_r_e_v_i_s_i_o_n_s
               prints information about revisions given in the
               comma-separated list _r_e_v_i_s_i_o_n_s of revisions and
               ranges. A range _r_e_v_1-_r_e_v_2 means revisions _r_e_v_1 to
               _r_e_v_2 on the same branch, -_r_e_v means revisions from
               the beginning of the branch up to and including
               _r_e_v, and _r_e_v- means revisions starting with _r_e_v to
               the end of the branch containing _r_e_v. An argument
               that is a branch means all revisions on that
               branch. A range of branches means all revisions on
               the branches in that range.

     -s_s_t_a_t_e_s  prints information about revisions whose state
               attributes match one of the states given in the
               comma-separated list _s_t_a_t_e_s.

     -w[_l_o_g_i_n_s]
               prints information about revisions checked in by
               users with login names appearing in the comma-
               separated list _l_o_g_i_n_s.  If _l_o_g_i_n_s is omitted, the
               user's login is assumed.

     _R_l_o_g prints the intersection of the revisions selected with
     the options -d, -l, -s, -w, intersected with the union of
     the revisions selected by -b and -r.

EXAMPLES
          rlog  -L  -R  RCS/*,v
          rlog  -L  -h  RCS/*,v
          rlog  -L  -l  RCS/*,v
          rlog  RCS/*,v

     The first command prints the names of all RCS files in the
     subdirectory `RCS' which have locks. The second command
     prints the headers of those files, and the third prints the
     headers plus the log messages of the locked revisions.  The
     last command prints complete information.

DIAGNOSTICS
     The exit status always refers to the last RCS file operated
     upon, and is 0 if the operation was successful, 1 otherwise.





Printed 1/10/87              6/29/83                            2






RLOG(1)             UNIX Programmer's Manual              RLOG(1)



IDENTIFICATION
     Author: Walter F. Tichy, Purdue University, West Lafayette,
     IN, 47907.
     Revision Number: 3.2 ; Release Date: 83/05/11 .
     Copyright 8c9 1982 by Walter F. Tichy.

SEE ALSO
     ci (1), co (1), ident(1), rcs (1), rcsdiff (1), rcsintro
     (1), rcsmerge (1), rcsfile (5), sccstorcs (8).
     Walter F. Tichy, "Design, Implementation, and Evaluation of
     a Revision Control System," in _P_r_o_c_e_e_d_i_n_g_s _o_f _t_h_e _6_t_h _I_n_t_e_r_-
     _n_a_t_i_o_n_a_l _C_o_n_f_e_r_e_n_c_e _o_n _S_o_f_t_w_a_r_e _E_n_g_i_n_e_e_r_i_n_g, IEEE, Tokyo,
     Sept. 1982.

BUGS





































Printed 1/10/87              6/29/83                            3






