.TH CLEARINGHOUSESUPPORT 3X Cornell
.SH NAME
CH_StringToName,
CH_LookupAddr,
CH_GetFirstCH,
CH_GetOtherCH,
CH_Enumerate,
CH_EnumerateAliases
\- Clearinghouse support routines.
.SH SYNOPSIS
.PP
.nf
.B "#include <sys/types.h>		/* used by ns.h */"
.B "#include <netns/ns.h>		/* for sockaddr_ns */"
.B "#include <xnscourier/Clearinghouse2.h>"
.B "#include <xnscourier/CH.h>"
.PP
.B "Clearinghouse2_ObjectName CH_StringToName(string, defaults)"
.B "	char *string;"
.B "	Clearinghouse2_ObjectName *defaults;"
.PP
.B "struct xn_addr * CH_LookupAddr(pattern, property)"
.B "	Clearinghouse2_ObjectName pattern;"
.B "	Clearinghouse2_Property property;"
.PP
.B "CourierConnection * CH_GetFirstCH( )"
.PP
.B "CourierConnection * CH_GetOtherCH(conn, hint)"
.B "	CourierConnection *conn;"
.B "	Clearinghouse2_ObjectName hint;"
.PP
.B "int CH_Enumerate(pattern, property, eachName)"
.B "	Clearinghouse2_ObjectName pattern;"
.B "	Clearinghouse2_Property property;"
.B "	int (*eachName)();"
.PP
.B "CH_EnumerateAliases(pattern, eachName)"
.B "	Clearinghouse2_ObjectNamePattern pattern;"
.B "	int (*eachName)();"
.B "int eachName(name)"
.B "	Clearinghouse2_ObjectName name;"
.fi
.PP
Link with
.IR "-lcourier" .
.SH DESCRIPTION
.PP
These functions provide a convenient interface to the XNS Clearinghouse
built on Courier remote procedure calls.  They all require the Maryland
XNS kernel.
.PP
Given a string in standard format (e.g. 
``jqj:Computer\ Science:cornell-univ''),
.I CH_StringToName
translates a string in standard format, e.g.
``jqj:computer science:cornell-univ'' into a Clearinghouse ObjectName struct.
The storage for the resulting 3 fields is dynamically allocated via malloc().
If the argument string is incomplete, e.g. ``jqj'' or 
``::cornell-univ'', the unspecified values are filled in from
.IR defaults .
.I Defaults
may be NULL, in which case 0-length strings are used as defaults.
.PP
Given a Clearinghouse three part name (possibly containing wild cards
in the local object part)
designating an addressable resouce on the net,
and the property number on which a NetworkAddressList is expected to occur,
.I CH_LookupAddr
returns a pointer to an xn_addr structure associated with that name.
Note that the xn_addr structure is statically allocated!
If
.I property
is given as 0, then the ``addressList'' property (actually 4) is used;
this is the property typically used for storing Clearinghouse addresses of
objects.  Returns 0 if any error occurs, if the name given is not
registered, or if the name does not have the specified property.
If a name has several network addresses (e.g. a gateway machine), only
the first or primary address is returned; to obtain all addresses use
the remote procedure
.IR Clearinghouse2_RetrieveAddresses .
Users who require greater control than is provided by
.I CH_LookupAddress
should call
.I Clearinghouse2_RetrieveItem
directly.  Example:
.PP
.nf
struct xn_addr * pvaxaddr;
static struct Clearinghouse2_ObjectName pvaxname =
        {"cornell-univ", "computer science", "pvax"};
pvaxaddr = CH_LookupAddr(pvaxname, 0);
.fi
.PP
The routine
.I CH_GetFirstCH
returns an XNS Courier connection to a nearby clearinghouse, useful
for Clearinghouse remote procedure calls.  Since the Clearinghouse is
distributed, that instance of the CH may not contain the data desired;
in such cases, a remote CH procedure call will return the error
``WrongServer'' with a hint as to the correct server, and the user
may retry the operation after connecting (using 
.IR CH_GetOtherCH )
to the clearinghouse specified by the hint.  For example:
.PP
.nf
conn = CH_GetFirstCH();
DURING objectname = Clearinghouse2_LookupObject(name, agent);
HANDLER {
    if (Exception.Code == Clearinghouse2_WrongServer) {
       hint = CourierErrArgs(Clearinghouse2_WrongServerArgs, hint);
       ch2conn = CH_GetOtherCH(conn, hint);
       CourierClose(conn);
       objectname = Clearinghouse2_LookupObject(name, agent);
    } else exit(1);
} END_HANDLER
.fi
.PP
.I CH_Enumerate
and
.I CH_EnumerateAliases
each accept a pointer to a user-supplied function 
.IR eachProc .
This function is called once for each name in the local Clearinghouse
satisfying the 
.I pattern
(which may contain wildcards in its local object part only) supplied;
.I eachProc
is called with a single argument, the name of the current object.
.I CH_Enumerate
enumerates over all distinguished objects (i.e. no aliases) matching
the specified pattern and having the specified
.IR property .
To enumerate everything in a domain which
has a given property, use ``*'' in the object portion
of the pattern.  To enumerate all names in a domain which match a
given pattern, use the property value 0.  Other useful property values
are specified in
.IR <courier/CHEntries.h> .
.PP
.I CH_EnumerateAliases
is similar to
.I CH_Enumerate ,
except that
.I eachProc
is called once for each alias in the clearinghouse
matching the specified pattern.
.SH NOTES
.PP
A CourierConnection is an anonymous data structure used by the
runtimes.  Users should not dereference pointers to CourierConnection
themselves.
.PP
Some useful definitions equivalent to those in the include file
.I "<courier/Clearinghouse2.h>"
include:
.PP
.nf
typedef struct {
	char *organization;
	char *domain;
	char *object;
} Clearinghouse2_ObjectName;
.PP
typedef unsigned long Clearinghouse2_Property;
.fi
.SH FILES
/usr/local/lib/libcourier.a		-lcourier library.
.br
/usr/new/lib/xnscourier/clearinghouse.addresses	local clearinghouse address.
.SH SEE ALSO
clearinghouse(3X)
.br
``XNS Courier Under Unix''.
.br
``Clearinghouse Protocol,'' XSIS 078404 (April 1984).
.SH DIAGNOSTICS
.SH BUGS
Probably lots of them.  This is an \(*d -test version of Courier support
routines and is guaranteed to have bugs.  Please report them to 
.BR jqj@cornell .
.PP
In particular, since Packet Exchange is not yet working in the kernel,
.I CH_GetFirstCH
looks up the local clearinghouse address in a file rather than doing
an expanding ring broadcast.  This will be fixed soon.
.PP
.I CH_LookupAddr
returns a pointer to a static data structure.  The other routines use
.I malloc()
to dynamically allocate their data (you may use the routine
.I clear_Clearinghouse2_ObjectName
to free the strings allocated by
.IR CH_StringToName ).
.SH AUTHOR
J.Q. Johnson
