.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)chb.n	6.1 (Berkeley) 4/29/86
.\"
." $Header: /na/franz/doc/RCS/chb.n,v 1.1 83/01/31 07:11:40 jkf Exp $
.Ap 2 Special\ Symbols
.pp
The values of these symbols  have a predefined meaning.
Some values are counters 
while others are simply flags whose value the user can change to affect
the operation of lisp system.
In all cases, only the value cell of the symbol is important, the function
cell is not.
The value of some of the symbols (like \fBER%misc\fP) 
are functions - what this means is that the value cell of those symbols
either contains a lambda expression,
a binary object,
or symbol with a function binding.
.pp 
The values of the special symbols are:
.in .5i
.de Sa
.sp 1v
.ti -.5i
\fB\\$1\fP\ \-\ \\
..
.Sa $gccount$
The number of garbage collections which have occurred.
.Sa $gcprint
If bound to  a non nil value, then after each garbage collection and 
subsequent storage allocation a summary of storage allocation will
be printed.
.Sa $ldprint
If bound to a non nil value, then during each 
.i fasl
or 
.i cfasl
a diagnostic message will be printed.
.Sa ER%all
The function which is the error handler for all errors (see \(sc10)
.Sa ER%brk
The function which is the handler for the 
error signal generated by the evaluation of the 
.i break 
function (see \(sc10).
.Sa ER%err
The function which is the handler for the error 
signal generated by the evaluation of the
.i err
function (see \(sc10).
.Sa ER%misc
The function which is the handler of the error 
signal generated by one of the unclassified errors (see \(sc10).
Most errors are unclassified at this point.
.Sa ER%tpl
The function which is the handler to be called
when an error has occurred which 
has not been handled (see \(sc10). 
.Sa ER%undef
The function which is the handler for the 
error signal generated when a call to an undefined function
is made.
.Sa ^w
When bound to a non nil value this will prevent output to the standard
output port (poport) from reaching the standard output (usually a terminal).
Note that ^w is a two character symbol and should not be confused
with ^W which is how we would denote control-w.
The value of ^w is checked when the standard output buffer is flushed
which occurs after a 
.i terpr , 
.i drain 
or when the buffer overflows.
This is most useful in conjunction with ptport described below.
System error handlers rebind ^w to nil when they are invoked to assure
that error messages are not lost.
(This was introduced for Maclisp compatibility).
.Sa defmacro-for-compiling
The has an effect during compilation.  
If non-nil it causes macros defined by defmacro to be 
compiled and included in the
object file.
.Sa environment
The UNIX environment in assoc list form.
.Sa errlist
When a 
.i reset
is done, the value of errlist is saved away and control is thrown to
the top level.
\fIEval\fP
is then mapped over the saved away 
value of this list.
.Sa errport
This port is initially bound to the standard error file.
.Sa evalhook
The value of this symbol, if bound, is the name of a function to handle
evalhook traps (see \(sc14.4)
.Sa float-format
The value of this symbol is a string which is the format to be used
by print to print flonums.
See the documentation on the UNIX function printf for a list
of allowable formats.
.Sa funcallhook
The value of this symbol, if bound, is the name of a function to handle
funcallhook traps (see \(sc14.4).
.Sa gcdisable
If non nil, then garbage collections will not be done automatically when
a collectable data type runs out.
.Sa ibase
This is the input radix used by the lisp reader.
It may be either eight or ten. 
Numbers followed by a decimal point are assumed to be decimal regardless
of what ibase is.
.Sa linel
The line length used by the pretty printer, pp.
This should be used by 
.i print 
but it is not at this time.
.Sa nil
This symbol represents the null list and thus can be written ().
Its value is always nil.
Any attempt to change the value will result in an error.
.Sa piport
Initially bound to the standard input (usually the keyboard).
A read with no arguments reads from piport.
.Sa poport
Initially bound to the standard output (usually the terminal console).
A print with no second argument writes to poport.
See also: ^w and ptport.
.Sa prinlength
If this is a positive fixnum, then the \fIprint\fP function will print
no more than prinlength elements of a list or hunk and further elements
abbreviated as `...'.
The initial value of prinlength is nil.
.Sa prinlevel
If this is a positive fixnum, then the \fIprint\fP function will print
only prinlevel levels of nested lists or hunks.
Lists below this level will be abbreviated by `&' and hunks below this 
level will be abbreviated by a `%'.
The initial value of prinlevel is nil.
.Sa ptport
Initially bound to nil.
If bound to a port, then all output sent to the standard output will
also be sent to this port as long as this port is not also 
the standard output (as this would cause a loop).
Note that ptport will not get a copy of whatever is sent to poport
if poport is not bound to the standard output.
.Sa readtable
The value of this is the current readtable.
It is an array but you should NOT try to change the value of the elements
of the array using the array functions.
This is because the readtable is an array of bytes and the smallest 
unit the array functions work with is a full word (4 bytes).
You can use 
.i setsyntax 
to change the values and
.i "(status syntax ...)"
to read the values.
.Sa t
This symbol always has the value t.
It is possible to change the value of this symbol for short
periods of time but you are strongly advised against it.
.Sa top-level
In a lisp system without /usr/lib/lisp/toplevel.l loaded, after a 
.i reset
is done, the lisp system will 
.i funcall 
the value of top-level if it is
non nil.
This provides a way for the user to introduce his own top level interpreter.
When /usr/lib/lisp/toplevel.l is loaded, it sets top-level to franz-top-level
and changes the 
.i reset 
function so that once franz-top-level starts, it cannot
be replaced by changing top-level.
Franz-top-level  does provide a way of changing 
the top level however, and that is 
through user-top-level.
.Sa user-top-level
If this is bound then after a 
.i reset ,
the top level function will
.i funcall 
the value of this symbol rather than go through a read eval print
loop.
