/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * 		@(#)qfont.c	1.2  Berkeley  6/6/88
 */
/*
 *	@(#)qfont.c	1.1 (ULTRIX) 8/21/85
 *
 * The following tables are used to translate LK201 key strokes
 * into ascii characters. The tables also support the special
 * function keys.
 */

char q_key[]={
	 0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   0 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   8 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00	/*  16 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  24 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  32 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  40 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  48 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  56 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  64 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  72 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x82 /*  80 */
	,0x83 ,0x84 ,0x85 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  88 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x86 ,0x87 ,0x88 ,0x89 /*  96 */
	,0x8a ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 104 */ 
	,0x00 ,0x1b ,0x08 ,0x0a ,0x8b ,0x00 ,0x00 ,0x00 /* 112 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8c ,0x8d ,0x00 ,0x00 /* 120 */
	,0x8e ,0x8f ,0x90 ,0x91 ,0x00 ,0x00 ,0x00 ,0x00 /* 128 */
	,0x00 ,0x00 ,0x92 ,0x93 ,0x94 ,0x95 ,0x96 ,0x97 /* 136 */
	,0x00 ,0x00 ,0xa0 ,0x00 ,0xa1 ,0xa2 ,0xa3 ,0xa4 /* 144 */
	,0xa5 ,0xa6 ,0xa7 ,0xa8 ,0xa9 ,0xaa ,0xab ,0xac /* 152 */
	,0xad ,0x98 ,0x99 ,0x9a ,0x9b ,0x00 ,0x00 ,0x9c /* 160 */
	,0x9d ,0x9e ,0x9f ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 168 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 176 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x7f ,'\r' ,0x09 ,'`'  /* 184 */
	,'1'  ,'q'  ,'a'  ,'z'  ,0x00 ,'2'  ,'w'  ,'s'  /* 192 */
	,'x'  ,'<'  ,0x00 ,'3'  ,'e'  ,'d'  ,'c'  ,0x00 /* 200 */
	,'4'  ,'r'  ,'f'  ,'v'  ,' '  ,0x00 ,'5'  ,'t'  /* 208 */
	,'g'  ,'b'  ,0x00 ,'6'  ,'y'  ,'h'  ,'n'  ,0x00 /* 216 */
	,'7'  ,'u'  ,'j'  ,'m'  ,0x00 ,'8'  ,'i'  ,'k'  /* 224 */
	,','  ,0x00 ,'9'  ,'o'  ,'l'  ,'.'  ,0x00 ,'0'  /* 232 */
	,'p'  ,0x00 ,';'  ,'/'  ,0x00 ,'='  ,']'  ,'\\' /* 240 */
	,0x00 ,'-'  ,'['  ,'\'' ,0x00 ,0x00 ,0x00 ,0x00 /* 248 */
};

char q_shift_key[]={
	 0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   0 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   8 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00	/*  16 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  24 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  32 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  40 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  48 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  56 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  64 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  72 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x82 /*  80 */
	,0x83 ,0x84 ,0x85 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  88 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x86 ,0x87 ,0x88 ,0x89 /*  96 */
	,0x8a ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 104 */ 
	,0x00 ,0x1b ,0x08 ,0x0a ,0x8b ,0x00 ,0x00 ,0x00 /* 112 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8c ,0x8d ,0x00 ,0x00 /* 120 */
	,0x8e ,0x8f ,0x90 ,0x91 ,0x00 ,0x00 ,0x00 ,0x00 /* 128 */
	,0x00 ,0x00 ,0x92 ,0x93 ,0x94 ,0x95 ,0x96 ,0x97 /* 136 */
	,0x00 ,0x00 ,0xa0 ,0x00 ,0xa1 ,0xa2 ,0xa3 ,0xa4 /* 144 */
	,0xa5 ,0xa6 ,0xa7 ,0xa8 ,0xa9 ,0xaa ,0xab ,0xac /* 152 */
	,0xad ,0x98 ,0x99 ,0x9a ,0x9b ,0x00 ,0x00 ,0x9c /* 160 */
	,0x9d ,0x9e ,0x9f ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 168 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 176 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x7f ,'\r' ,0x09 ,'~'  /* 184 */
	,'!'  ,'Q'  ,'A'  ,'Z'  ,0x00 ,'@'  ,'W'  ,'S'  /* 192 */
	,'X'  ,'>'  ,0x00 ,'#'  ,'E'  ,'D'  ,'C'  ,0x00 /* 200 */
	,'$'  ,'R'  ,'F'  ,'V'  ,' '  ,0x00 ,'%'  ,'T'  /* 208 */
	,'G'  ,'B'  ,0x00 ,'^'  ,'Y'  ,'H'  ,'N'  ,0x00 /* 216 */
	,'&'  ,'U'  ,'J'  ,'M'  ,0x00 ,'*'  ,'I'  ,'K'  /* 224 */
	,','  ,0x00 ,'('  ,'O'  ,'L'  ,'.'  ,0x00 ,')'  /* 232 */
	,'P'  ,0x00 ,':'  ,'?'  ,0x00 ,'+'  ,'}'  ,'|'  /* 240 */
	,0x00 ,'_'  ,'{'  ,'"'  ,0x00 ,0x00 ,0x00 ,0x00 /* 248 */
};

/*
 * LK201 special purpose keys. Translations from the tables above
 * includes codes for the function keys and other goodies. They can
 * be determined by the presence of the 8th bit being set.  The 
 * following table is accessed by removing that bit and using the 
 * result as the index to the following table. Note that table begins
 * a null entry.
 */
char	*q_special[]={ 0,
	"\33[11~",			/* f1 */
	"\33[12~",			/* f2 */
	"\33[13~",			/* f3 */
	"\33[14~",			/* f4 */
	"\33[15~",			/* f5 */
	"\33[17~",			/* f6 */
	"\33[18~",			/* f7 */
	"\33[19~",			/* f8 */
	"\33[20~",			/* f9 */
	"\33[21~",			/* f10 */
	"\33[26~",			/* f14 */
	"\33[28~",			/* f15 */
	"\33[29~",			/* f16 */
	"\33[31~",			/* f17 */
	"\33[32~",			/* f18 */
	"\33[33~",			/* f19 */
	"\33[34~",			/* f20 */
	"\33[1~",			/* find */
	"\33[2~",			/* insert */
	"\33[3~",			/* remove */
	"\33[4~",			/* select */
	"\33[5~",			/* prev */
	"\33[6~",			/* next */
	"\33OP",			/* pf1 */
	"\33OQ",			/* pf2 */
	"\33OR",			/* pf3 */
	"\33OS",			/* pf4 */
	"\33[D",			/* left */
	"\33[C",			/* right */
	"\33[B",			/* down */
	"\33[A",			/* up */
	"\33Op",			/* key pad 0 */
	"\33On",			/* key pad . */
	"\33OM",			/* key pad enter */
	"\33Oq",			/* key pad 1 */
	"\33Or",			/* key pad 2 */
	"\33Os",			/* key pad 3 */
	"\33Ot",			/* key pad 4 */
	"\33Ou",			/* key pad 5 */
	"\33Ov",			/* key pad 6 */
	"\33O/*",			/* key pad , */
	"\33Ow",			/* key pad 7 */
	"\33Ox",			/* key pad 8 */
	"\33Oy",			/* key pad 9 */
	"\33Om",			/* key pad - */
	/*
	 * The following strings are to allow a numeric keypad
	 * mode and still use the same translation tables
	 */
	"0",
	".",
	"\r",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	",",
	"7",
	"8",
	"9",
	"-"
};


/*
 * QVSS font table of displayable characters.
 */
char  q_font[]={
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
/* */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
/* */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
/* */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
/* */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x08, /* 0x00001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x09, /* 0x00001001	  $ */
	0x09, /* 0x00001001	  $ */
	0x3e, /* 0x00111110	  $ */
	0x48, /* 0x01001000	  $ */
	0x48, /* 0x01001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x08, /* 0x00001000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
/* */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x42, /* 0x01000010	  % */
	0x25, /* 0x00100101	  % */
	0x25, /* 0x00100101	  % */
	0x12, /* 0x00010010	  % */
	0x08, /* 0x00001000	  % */
	0x08, /* 0x00001000	  % */
	0x24, /* 0x00100100	  % */
	0x52, /* 0x01010010	  % */
	0x52, /* 0x01010010	  % */
	0x21, /* 0x00100001	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
/* */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x51, /* 0x01010001	  & */
	0x21, /* 0x00100001	  & */
	0x31, /* 0x00110001	  & */
	0x4e, /* 0x01001110	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
/* */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x38, /* 0x00111000	  ' */
	0x18, /* 0x00011000	  ' */
	0x04, /* 0x00000100	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
/* */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x10, /* 0x00010000	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x10, /* 0x00010000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
/* */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x04, /* 0x00000100	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x04, /* 0x00000100	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
/* */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x22, /* 0x00100010	  * */
	0x14, /* 0x00010100	  * */
	0x7f, /* 0x01111111	  * */
	0x14, /* 0x00010100	  * */
	0x22, /* 0x00100010	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
/* */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x7f, /* 0x01111111	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
/* */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x1c, /* 0x00011100	  , */
	0x0c, /* 0x00001100	  , */
	0x02, /* 0x00000010	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
/* */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x7f, /* 0x01111111	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
/* */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x08, /* 0x00001000	  . */
	0x1c, /* 0x00011100	  . */
	0x08, /* 0x00001000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
/* */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x40, /* 0x01000000	  / */
	0x40, /* 0x01000000	  / */
	0x20, /* 0x00100000	  / */
	0x10, /* 0x00010000	  / */
	0x08, /* 0x00001000	  / */
	0x04, /* 0x00000100	  / */
	0x02, /* 0x00000010	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
/* */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x0c, /* 0x00001100	  0 */
	0x12, /* 0x00010010	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x12, /* 0x00010010	  0 */
	0x0c, /* 0x00001100	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
/* */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x08, /* 0x00001000	  1 */
	0x0c, /* 0x00001100	  1 */
	0x0a, /* 0x00001010	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x3e, /* 0x00111110	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
/* */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x3e, /* 0x00111110	  2 */
	0x41, /* 0x01000001	  2 */
	0x41, /* 0x01000001	  2 */
	0x40, /* 0x01000000	  2 */
	0x20, /* 0x00100000	  2 */
	0x10, /* 0x00010000	  2 */
	0x0c, /* 0x00001100	  2 */
	0x02, /* 0x00000010	  2 */
	0x01, /* 0x00000001	  2 */
	0x7f, /* 0x01111111	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
/* */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x7f, /* 0x01111111	  3 */
	0x40, /* 0x01000000	  3 */
	0x20, /* 0x00100000	  3 */
	0x10, /* 0x00010000	  3 */
	0x38, /* 0x00111000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x41, /* 0x01000001	  3 */
	0x3e, /* 0x00111110	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
/* */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x20, /* 0x00100000	  4 */
	0x30, /* 0x00110000	  4 */
	0x28, /* 0x00101000	  4 */
	0x24, /* 0x00100100	  4 */
	0x22, /* 0x00100010	  4 */
	0x21, /* 0x00100001	  4 */
	0x7f, /* 0x01111111	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
/* */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x7f, /* 0x01111111	  5 */
	0x01, /* 0x00000001	  5 */
	0x01, /* 0x00000001	  5 */
	0x3d, /* 0x00111101	  5 */
	0x43, /* 0x01000011	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x41, /* 0x01000001	  5 */
	0x3e, /* 0x00111110	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
/* */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x3c, /* 0x00111100	  6 */
	0x02, /* 0x00000010	  6 */
	0x01, /* 0x00000001	  6 */
	0x01, /* 0x00000001	  6 */
	0x3d, /* 0x00111101	  6 */
	0x43, /* 0x01000011	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x3e, /* 0x00111110	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
/* */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x7f, /* 0x01111111	  7 */
	0x40, /* 0x01000000	  7 */
	0x40, /* 0x01000000	  7 */
	0x20, /* 0x00100000	  7 */
	0x10, /* 0x00010000	  7 */
	0x08, /* 0x00001000	  7 */
	0x04, /* 0x00000100	  7 */
	0x04, /* 0x00000100	  7 */
	0x02, /* 0x00000010	  7 */
	0x02, /* 0x00000010	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
/* */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
/* */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x3e, /* 0x00111110	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x61, /* 0x01100001	  9 */
	0x5e, /* 0x01011110	  9 */
	0x40, /* 0x01000000	  9 */
	0x40, /* 0x01000000	  9 */
	0x20, /* 0x00100000	  9 */
	0x1e, /* 0x00011110	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
/* */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
/* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
	0x08, /* 0x00001000	  /* */
	0x1c, /* 0x00011100	  /* */
	0x08, /* 0x00001000	  /* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
	0x1c, /* 0x00011100	  /* */
	0x0c, /* 0x00001100	  /* */
	0x02, /* 0x00000010	  /* */
	0x00, /* 0x00000000	  /* */
	0x00, /* 0x00000000	  /* */
/* */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x20, /* 0x00100000	  < */
	0x10, /* 0x00010000	  < */
	0x08, /* 0x00001000	  < */
	0x04, /* 0x00000100	  < */
	0x02, /* 0x00000010	  < */
	0x02, /* 0x00000010	  < */
	0x04, /* 0x00000100	  < */
	0x08, /* 0x00001000	  < */
	0x10, /* 0x00010000	  < */
	0x20, /* 0x00100000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
/* */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
/* */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x02, /* 0x00000010	  > */
	0x04, /* 0x00000100	  > */
	0x08, /* 0x00001000	  > */
	0x10, /* 0x00010000	  > */
	0x20, /* 0x00100000	  > */
	0x20, /* 0x00100000	  > */
	0x10, /* 0x00010000	  > */
	0x08, /* 0x00001000	  > */
	0x04, /* 0x00000100	  > */
	0x02, /* 0x00000010	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
/* */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x3e, /* 0x00111110	  ? */
	0x41, /* 0x01000001	  ? */
	0x41, /* 0x01000001	  ? */
	0x40, /* 0x01000000	  ? */
	0x20, /* 0x00100000	  ? */
	0x10, /* 0x00010000	  ? */
	0x08, /* 0x00001000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
/* */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x3e, /* 0x00111110	  @ */
	0x41, /* 0x01000001	  @ */
	0x41, /* 0x01000001	  @ */
	0x79, /* 0x01111001	  @ */
	0x45, /* 0x01000101	  @ */
	0x65, /* 0x01100101	  @ */
	0x59, /* 0x01011001	  @ */
	0x01, /* 0x00000001	  @ */
	0x01, /* 0x00000001	  @ */
	0x3e, /* 0x00111110	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
/* */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x08, /* 0x00001000	  A */
	0x14, /* 0x00010100	  A */
	0x22, /* 0x00100010	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x7f, /* 0x01111111	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
/* */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x3f, /* 0x00111111	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3e, /* 0x00111110	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3f, /* 0x00111111	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
/* */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x3e, /* 0x00111110	  C */
	0x41, /* 0x01000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x41, /* 0x01000001	  C */
	0x3e, /* 0x00111110	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
/* */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x3f, /* 0x00111111	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x3f, /* 0x00111111	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
/* */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x7e, /* 0x01111110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x1e, /* 0x00011110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x7e, /* 0x01111110	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
/* */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x7e, /* 0x01111110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x1e, /* 0x00011110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
/* */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x3e, /* 0x00111110	  G */
	0x41, /* 0x01000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x71, /* 0x01110001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x3e, /* 0x00111110	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
/* */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x7f, /* 0x01111111	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
/* */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x3e, /* 0x00111110	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x3e, /* 0x00111110	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
/* */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x78, /* 0x01111000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x21, /* 0x00100001	  J */
	0x1e, /* 0x00011110	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
/* */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x41, /* 0x01000001	  K */
	0x21, /* 0x00100001	  K */
	0x11, /* 0x00010001	  K */
	0x09, /* 0x00001001	  K */
	0x07, /* 0x00000111	  K */
	0x05, /* 0x00000101	  K */
	0x09, /* 0x00001001	  K */
	0x11, /* 0x00010001	  K */
	0x21, /* 0x00100001	  K */
	0x41, /* 0x01000001	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
/* */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x7f, /* 0x01111111	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
/* */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x63, /* 0x01100011	  M */
	0x55, /* 0x01010101	  M */
	0x55, /* 0x01010101	  M */
	0x49, /* 0x01001001	  M */
	0x49, /* 0x01001001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
/* */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x43, /* 0x01000011	  N */
	0x45, /* 0x01000101	  N */
	0x49, /* 0x01001001	  N */
	0x51, /* 0x01010001	  N */
	0x61, /* 0x01100001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
/* */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x3e, /* 0x00111110	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x3e, /* 0x00111110	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
/* */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x3f, /* 0x00111111	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x3f, /* 0x00111111	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
/* */
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x3e, /* 0x00111110	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x49, /* 0x01001001	  Q */
	0x51, /* 0x01010001	  Q */
	0x3e, /* 0x00111110	  Q */
	0x40, /* 0x01000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
/* */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x3f, /* 0x00111111	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x3f, /* 0x00111111	  R */
	0x09, /* 0x00001001	  R */
	0x11, /* 0x00010001	  R */
	0x21, /* 0x00100001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
/* */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x3e, /* 0x00111110	  S */
	0x41, /* 0x01000001	  S */
	0x01, /* 0x00000001	  S */
	0x01, /* 0x00000001	  S */
	0x3e, /* 0x00111110	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x41, /* 0x01000001	  S */
	0x3e, /* 0x00111110	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
/* */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x7f, /* 0x01111111	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
/* */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x3e, /* 0x00111110	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
/* */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x08, /* 0x00001000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
/* */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x55, /* 0x01010101	  W */
	0x22, /* 0x00100010	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
/* */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x22, /* 0x00100010	  X */
	0x14, /* 0x00010100	  X */
	0x08, /* 0x00001000	  X */
	0x08, /* 0x00001000	  X */
	0x14, /* 0x00010100	  X */
	0x22, /* 0x00100010	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
/* */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x41, /* 0x01000001	  Y */
	0x41, /* 0x01000001	  Y */
	0x22, /* 0x00100010	  Y */
	0x14, /* 0x00010100	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
/* */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x7f, /* 0x01111111	  Z */
	0x40, /* 0x01000000	  Z */
	0x20, /* 0x00100000	  Z */
	0x10, /* 0x00010000	  Z */
	0x08, /* 0x00001000	  Z */
	0x04, /* 0x00000100	  Z */
	0x02, /* 0x00000010	  Z */
	0x01, /* 0x00000001	  Z */
	0x01, /* 0x00000001	  Z */
	0x7f, /* 0x01111111	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
/* */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x3c, /* 0x00111100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x3c, /* 0x00111100	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
/* */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x01, /* 0x00000001	  \ */
	0x02, /* 0x00000010	  \ */
	0x02, /* 0x00000010	  \ */
	0x04, /* 0x00000100	  \ */
	0x08, /* 0x00001000	  \ */
	0x08, /* 0x00001000	  \ */
	0x10, /* 0x00010000	  \ */
	0x20, /* 0x00100000	  \ */
	0x20, /* 0x00100000	  \ */
	0x40, /* 0x01000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
/* */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
/* */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x08, /* 0x00001000	  ^ */
	0x14, /* 0x00010100	  ^ */
	0x22, /* 0x00100010	  ^ */
	0x41, /* 0x01000001	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
/* */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x7f, /* 0x01111111	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
/* */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x0e, /* 0x00001110	  ` */
	0x0c, /* 0x00001100	  ` */
	0x10, /* 0x00010000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
/* */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x3e, /* 0x00111110	  a */
	0x40, /* 0x01000000	  a */
	0x40, /* 0x01000000	  a */
	0x7e, /* 0x01111110	  a */
	0x41, /* 0x01000001	  a */
	0x61, /* 0x01100001	  a */
	0x5e, /* 0x01011110	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
/* */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x3d, /* 0x00111101	  b */
	0x43, /* 0x01000011	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x43, /* 0x01000011	  b */
	0x3d, /* 0x00111101	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
/* */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x3e, /* 0x00111110	  c */
	0x41, /* 0x01000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x41, /* 0x01000001	  c */
	0x3e, /* 0x00111110	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
/* */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x5e, /* 0x01011110	  d */
	0x61, /* 0x01100001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x61, /* 0x01100001	  d */
	0x5e, /* 0x01011110	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
/* */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x3e, /* 0x00111110	  e */
	0x41, /* 0x01000001	  e */
	0x41, /* 0x01000001	  e */
	0x7f, /* 0x01111111	  e */
	0x01, /* 0x00000001	  e */
	0x01, /* 0x00000001	  e */
	0x3e, /* 0x00111110	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
/* */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x38, /* 0x00111000	  f */
	0x44, /* 0x01000100	  f */
	0x44, /* 0x01000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x1f, /* 0x00011111	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
/* */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x5e, /* 0x01011110	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x1e, /* 0x00011110	  g */
	0x01, /* 0x00000001	  g */
	0x3e, /* 0x00111110	  g */
	0x41, /* 0x01000001	  g */
	0x41, /* 0x01000001	  g */
	0x3e, /* 0x00111110	  g */
/* */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x3d, /* 0x00111101	  h */
	0x43, /* 0x01000011	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
/* */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x08, /* 0x00001000	  i */
	0x00, /* 0x00000000	  i */
	0x0c, /* 0x00001100	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x3e, /* 0x00111110	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
/* */
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x20, /* 0x00100000	  j */
	0x00, /* 0x00000000	  j */
	0x38, /* 0x00111000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x1e, /* 0x00011110	  j */
/* */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x41, /* 0x01000001	  k */
	0x31, /* 0x00110001	  k */
	0x0d, /* 0x00001101	  k */
	0x03, /* 0x00000011	  k */
	0x0d, /* 0x00001101	  k */
	0x31, /* 0x00110001	  k */
	0x41, /* 0x01000001	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
/* */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x0c, /* 0x00001100	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x3e, /* 0x00111110	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
/* */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x37, /* 0x00110111	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x41, /* 0x01000001	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
/* */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x3d, /* 0x00111101	  n */
	0x43, /* 0x01000011	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
/* */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x3e, /* 0x00111110	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x3e, /* 0x00111110	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
/* */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x3d, /* 0x00111101	  p */
	0x43, /* 0x01000011	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x43, /* 0x01000011	  p */
	0x3d, /* 0x00111101	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
/* */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x5e, /* 0x01011110	  q */
	0x61, /* 0x01100001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x61, /* 0x01100001	  q */
	0x5e, /* 0x01011110	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
/* */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x39, /* 0x00111001	  r */
	0x46, /* 0x01000110	  r */
	0x42, /* 0x01000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
/* */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x3e, /* 0x00111110	  s */
	0x41, /* 0x01000001	  s */
	0x01, /* 0x00000001	  s */
	0x3e, /* 0x00111110	  s */
	0x40, /* 0x01000000	  s */
	0x41, /* 0x01000001	  s */
	0x3e, /* 0x00111110	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
/* */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x3f, /* 0x00111111	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x44, /* 0x01000100	  t */
	0x38, /* 0x00111000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
/* */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x5e, /* 0x01011110	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
/* */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x41, /* 0x01000001	  v */
	0x41, /* 0x01000001	  v */
	0x22, /* 0x00100010	  v */
	0x22, /* 0x00100010	  v */
	0x14, /* 0x00010100	  v */
	0x14, /* 0x00010100	  v */
	0x08, /* 0x00001000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
/* */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x41, /* 0x01000001	  w */
	0x41, /* 0x01000001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x55, /* 0x01010101	  w */
	0x22, /* 0x00100010	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
/* */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x41, /* 0x01000001	  x */
	0x22, /* 0x00100010	  x */
	0x14, /* 0x00010100	  x */
	0x08, /* 0x00001000	  x */
	0x14, /* 0x00010100	  x */
	0x22, /* 0x00100010	  x */
	0x41, /* 0x01000001	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
/* */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x31, /* 0x00110001	  y */
	0x2e, /* 0x00101110	  y */
	0x20, /* 0x00100000	  y */
	0x21, /* 0x00100001	  y */
	0x1e, /* 0x00011110	  y */
/* */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x7f, /* 0x01111111	  z */
	0x20, /* 0x00100000	  z */
	0x10, /* 0x00010000	  z */
	0x08, /* 0x00001000	  z */
	0x04, /* 0x00000100	  z */
	0x02, /* 0x00000010	  z */
	0x7f, /* 0x01111111	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
/* */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x70, /* 0x01110000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x10, /* 0x00010000	  { */
	0x0c, /* 0x00001100	  { */
	0x0c, /* 0x00001100	  { */
	0x10, /* 0x00010000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x70, /* 0x01110000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
/* */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
/* */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x07, /* 0x00000111	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x04, /* 0x00000100	  } */
	0x18, /* 0x00011000	  } */
	0x18, /* 0x00011000	  } */
	0x04, /* 0x00000100	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x07, /* 0x00000111	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
/* */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x46, /* 0x01000110	  ~ */
	0x49, /* 0x01001001	  ~ */
	0x31, /* 0x00110001	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
};

/*
 *	Default Cursor
 */
unsigned short q_cursor[] = {
	0x0000,
	0x0000,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x00ff,
	0x0000,
	0x0000,
	0x0000
};

