.TH CLEARINGHOUSESUPPORT 3 Cornell
.\" $Header: clearinghousesupport.n,v 1.2 86/12/15 11:26:07 jqj Exp $
.SH NAME
CH_StringToName,
CH_NameDefault,
CH_LookupAddr,
CH_LookupAddrDN,
CH_GetFirstCH,
CH_GetOtherCH,
CH_Enumerate,
CH_EnumerateAliases
\- Clearinghouse support routines.
.SH SYNOPSIS
.PP
.nf
.B "#include <sys/types.h>		/* used by ns.h */"
.B "#include <netns/ns.h>		/* for ns_addr */"
.B "#include <xnscourier/Clearinghouse2.h>"
.B "#include <xnscourier/CH.h>"
.PP
.B "Clearinghouse2_ObjectName CH_StringToName(string, defaults)"
.B "	char *string;"
.B "	Clearinghouse2_ObjectName *defaults;"
.PP
.B "CH_NameDefault(defaults)"
.B "	Clearinghouse2_ObjectName *defaults;"
.PP
.B "struct ns_addr * CH_LookupAddr(pattern, property)"
.B "	Clearinghouse2_ObjectName pattern;"
.B "	Clearinghouse2_Property property;"
.PP
.B "struct ns_addr * CH_LookupAddrDN(pattern, property, name, namelen)"
.B "	Clearinghouse2_ObjectName pattern;"
.B "	Clearinghouse2_Property property;"
.B "	char name[namelen];"
.B "	int namelen;"
.PP
.B "CourierConnection * CH_GetFirstCH()"
.PP
.B "CourierConnection * CH_GetOtherCH(conn, hint)"
.B "	CourierConnection *conn;"
.B "	Clearinghouse2_ObjectName hint;"
.PP
.B "int CH_Enumerate(pattern, property, eachName)"
.B "	Clearinghouse2_ObjectName pattern;"
.B "	Clearinghouse2_Property property;"
.B "	int (*eachName)();"
.PP
.B "CH_EnumerateAliases(pattern,eachName)"
.B "	Clearinghouse2_ObjectNamePattern pattern;"
.B "	int (*eachName)();"
.B "int eachName(name)"
.B "	Clearinghouse2_ObjectName name;"
.fi
.PP
Link with
.IR "-lcourier" .
.SH DESCRIPTION
.PP
Given a string in standard format (e.g. 
``jqj:Computer\ Science:cornell-univ''),
.I CH_StringToName
returns an ObjectName containing broken out fields for object, domain, and
organization.  If the string is incomplete, e.g. ``jqj'' or 
``::cornell-univ'', the unspecified values are filled in from
.IR defaults .
.I Defaults
may be NULL, in which case 0-length strings are used as defaults.
.PP
.I CH_NameDefault
sets its argument to default domain and organization based on data from
the file
.IR /usr/new/lib/xnscourier/CH.default .
The strings pointed to by the argument are statically allocated.
.PP
Given a Clearinghouse three part name (possibly containing wild cards
in the local object part)
and the property number on which a NetworkAddressList is expected to occur,
.I CH_LookupAddr
returns a pointer to an ns_addr structure associated with that name.
Note that the ns_addr structure is statically allocated!
If
.I property
is given as 0, then the addressList property (actually 4) is used;
this is the property typically used for storing Clearinghouse addresses of
objects.  Returns 0 if any error occurs, if the name given is not
registered, or if the name does not have the specified property.
If a name has several network addresses (e.g. a gateway machine), only
the first or primary address is returned; to obtain all addresses use
the remote procedure
.IR Clearinghouse2_RetrieveAddresses .
.PP
The routine 
.I CH_LookupAddrDN
is identical with 
.IR CH_LookupAddr ,
except that it accepts additional parameters of
.IR namestring ,
a caller-allocated buffer of length
.IR namelen ,
which on return is set to the distinguished name of the object found.
Users who require greater control than is provided by
.I CH_LookupAddress
should call
.I Clearinghouse2_RetrieveItem
directly.
.PP
The routine
.I CH_GetFirstCH
returns an XNS Courier connection to a nearby clearinghouse, useful
for Clearinghouse remote procedure calls.  Since the Clearinghouse is
distributed, that instance of the CH may not contain the data desired;
in such cases, a remote CH procedure call will return the error
``WrongServer'' with a hint as to the correct server, and the user
may retry the operation after connecting (using 
.IR CH_GetOtherCH )
to the clearinghouse specified by the hint.  For example:
.PP
.nf
CH_NameDefault(&default);
name = CH_StringToName(argv[1], &default);
conn = CH_GetFirstCH();
for (tries = 5; tries > 0; tries--) {
    DURING {
	objectname = Clearinghouse2_LookupObject(conn, NULL, name, agent);
	tries = -1;	/* done.  Note break is illegal inside DURING */
    }
    HANDLER {
        if (Exception.Code == Clearinghouse2_WrongServer) {
            hint = CourierErrArgs(Clearinghouse2_WrongServerArgs, hint);
            ch2conn = CH_GetOtherCH(conn, hint);
            CourierClose(conn);
            conn = ch2conn;
        } else exit(1);
    } END_HANDLER
}
.fi
.PP
.I CH_Enumerate
and
.I CH_EnumerateAliases
each accept a pointer to a user-supplied function 
.IR eachProc .
This function is called once for each name in the local Clearinghouse
satisfying the 
.I pattern
(which may contain wildcards in its local object part only) supplied;
.I eachProc
is called with a single argument, the name of the current object.
.I CH_Enumerate
enumerates over all distinguished objects (i.e. no aliases) matching
the specified pattern and having the specified
.IR property .
If no specific property is desired, 0 should be used to obtain all
names.
.I CH_EnumerateAliases
is similar, except that
.I eachProc
is called once for each alias matching the specified pattern.
.SH NOTES
.PP
A CourierConnection is an anonymous data structure used by the
runtimes.  Users should not dereference pointers to CourierConnection
themselves.
.PP
Some useful definitions equivalent to those in the include file
.I "<courier/Clearinghouse2.h>"
include:
.PP
.nf
typedef struct {
	char *organization;
	char *domain;
	char *object;
} Clearinghouse2_ObjectName;

typedef unsigned long Clearinghouse2_Property;
.fi
.SH FILES
.nf
/usr/local/lib/libcourier.a		-lcourier library.
/usr/new/lib/xnscourier/CH.addrs	local clearinghouse address.
/usr/new/lib/xnscourier/CH.default	defaults for clearinghouse names.
.fi
.SH SEE ALSO
xnscourier(3)
.br
``XNS Courier Under Unix.''
.br
``Clearinghouse Protocol,'' XSIS 078404 (April 1984).
.SH DIAGNOSTICS
.SH BUGS
Probably lots of them.
.PP
In particular, since Packet Exchange is not yet working in the kernel,
.I CH_GetFirstCH
looks up the local clearinghouse address in a file rather than doing
an expanding ring broadcast.  This will be fixed soon.
.SH AUTHOR
J.Q. Johnson

