.TH "Viewpointfiles" 5 "16-Feb-87" "Xerox (WRC)"
.\" $Header: Viewpointfiles.n,v 1.1 87/04/01 13:55:09 ed Exp $
.SH NAME
Viewpoint files - format of Viewpoint files as stored on Unix
.SH DESCRIPTION
Viewpoint  related files may be stored on a Unix system through retrieval
from an NS file server via \fIxnsftp\fR or storage to the Unix file services
\fIFiling4d\fR, \fIFiling5d\fR, \fIFiling6d\fR or \fIFilingSubset1d\fR. 
Viewpoint files actually consist of two critical parts, attributes and content.
To maintain the ability to use these files within Viewpoint, both parts must be
retained on the Unix file system. Currently that is done in one of several ways 
depending upon the file \fItype\fR and \fIisDirectory\fR attributes.
.PP
A certain class of files are generally transferred for content only. The file
types \fItDirectory\fR, \fItText\fR, \fIInterpress\fR and \fIViewpoint
Canvases (RES)\fR are retained as \(n'content-only\(n' files; the only attributes
maintained are those which can be saved in or implied from the file structure
itself
(\fIcreatedOn\fR, \fIdataSize\fR, \fIisDirectory\fR, \fImodifiedOn\fR, \fIname\fR,
\fIpathname\fR, \fItype\fR and \fIversion\fR).
.PP
The remainder of file types are stored on the Unix system with both attributes
and content in a single file. Files of this type are specific to Xerox
applications, such as Viewpoint, network services, 860, etc.. 
Examples of these files are Viewpoint 
documents, books, spreadsheets, applications, 860 documents and printer fonts.
.PP
These files are retained on Unix in a file having the following format: a header
\*(lqviewpoint-files/xerox\*(rq followed by a Cardinal (16 bits) containing 
the size in bytes of the maintained attributes, a Sequence of Attributes which
contains the relevant file attributes followed by the file content.
The Unix tools will determine the file type by looking through the attribute 
sequence for the \fItype\fR attribute.
.PP
Some of the above file types are in fact \(n'directories\(n' of other files which are
treated as a single entity; in this case, the \fIisDirectory\fR attribute is
TRUE. For these files, the \fISerialize\fR/\fIDeserialize\fR procedures are used and the file
content saved is the actual serialized stream of file and descendant's attributes
and content.    
.SH NOTES
The scheme is obviously not foolproof but provides a simple mechanism to deal
with the files deemed most useful to casual users of the tools. No attempt has
been made to provide a \(n'full\(n' file service since there are cases where only the 
file content is desired to provide interchangability with Unix tools.
.PP
Although this scheme allows a large set of attributes to be retained with the
file, not all of these attributes may be available and/or returned to 
interested clients.
.SH "SEE ALSO"
xnsftp(1N), Filing4d(1N), Filing5d(1N), Filing6d(1N), FilingSubset1d(1N)
.br
Filing Protocol, \s8XSIS\s0 108605 (May 1986)
.SH AUTHORS
Ed Flint
