.TH DIST 1 "3 August 1983"
.UC 4
.SH NAME
dist \- redistribute a message to additional addresses
.SH SYNOPSIS
.B dist
[ +folder ] [ msg ] [ \-form formfile ] [ \-editor editor ]
[ \-annotate ] [ \-noannotate ]
[ \-inplace ] [ \-noinplace ] [ \-help ]
.SH DESCRIPTION
\fIDist\fR is similar to \fIforw\fR.
It prepares the specified
message for redistribution to addresses that (presumably) are
not on the original address list.
The file \*(lqdistcomps\*(rq in the
user's MH directory, or a standard form, or the file specified by
`\-form formfile' will be used as the blank components file to
be prepended to the message being distributed.
The standard form
has the components \*(lqDistribute-to:\*(rq and \*(lqDistribute-cc:\*(rq.
When
the message is sent, \*(lqDistribution-Date:\0date\*(rq,
\*(lqDistribution-From:\0name\*(rq, and
\*(lqDistribution-Id:\0id\*(rq (if `\-msgid' is
specified to \fIsend\fR;) will be prepended to the outgoing message.
Only those addresses in \*(lqDistribute-To\*(rq, \*(lqDistribute-cc\*(rq, and
\*(lqDistribute-Bcc\*(rq will be sent.
Also, a \*(lqDistribute-Fcc:\0folder\*(rq
will be honored (see \fIsend;\fR).
.PP
\fISend\fR recognizes a message as a redistribution message by the
existence of the field \*(lqDistribute-To:\*(rq, so don't try to
redistribute a message with only a \*(lqDistribute-cc:\*(rq.
.PP
If the `\-annotate' switch is given, each message being
distributed will be annotated with the lines:
.nf

     Distributed:\0\*(<<date\*(>>
     Distributed:\0Distribute-to: names

.fi
where each \*(lqto\*(rq list contains as many lines as required.
This annotation
will be done only if the message is sent directly from \fIdist\fR.
If the
message is not sent immediately from \fIdist\fR (i.e., if it is sent later
via \fIsend;\fR),
\*(lqcomp \-use\*(rq may be used to re-edit and send the constructed message,
but the annotations won't take place.
The '\-inplace' switch causes annotation to
be done in place in order to preserve links to the annotated message.
.PP
See \fIcomp\fR for a description of the `\-editor' switch and for options
upon exiting from the editor.
.PP
If a +folder is specified, it will become the current
folder, and the current message will be set to the message
being redistributed.
.SH FILES
.nf
.ta \w'or <mh-dir>/components    'u
/etc/mh/components	The message skeleton
or <mh-dir>/components	Rather than the standard skeleton
$HOME/\*.mh\(ruprofile	The user profile
<mh-dir>/draft	The default message file
/usr/bin/send	To send the composed message
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'<lasteditor>\-next:     'u
Path:	To determine the user's MH directory
Editor:	To override the use of /bin/ned as the default editor
<lasteditor>\-next:	editor to be used after exit from <lasteditor>
.fi
.SH DEFAULTS
.nf
`+folder' defaults to the current folder
`msg' defaults to cur
`\-editor' defaults to /bin/ned
`\-noannotate'
`\-noinplace'
.fi
