#
# include	"../../ingres.h"
# include	"../../symbol.h"
# include	"../../pipes.h"
# include	"IIglobals.h"

/*
**  IIn_get -- Routine to check if there is a next
**	tuple coming up the data pipe in a retrieve.
**	Loads IIr_sym with the length and type of
**	the next domain. 
**
**	Returns:
**		0 -- on error or end of tuple
**		1 -- otherwise
**
*/


IIn_get(file_name, line_no)
char		*file_name;
int		line_no;
{
	register struct retsym	*ret;

	if (IIproc_name = file_name)
		IIline_no = line_no;

#	ifdef xATR1
	if (IIdebug)
	{
		printf("%s ent ", IIproc_name ? IIproc_name : "");
		printf("IIn_get : IIdomains %d IIr_sym type, len %d %d IIerrflag %d\n",
		IIdomains, IIr_sym.type, IIr_sym.len, IIerrflag);
	}
#	endif


	IIdomains = 0;
	/* in case of overflow error, a tuple has been skipped */
	if (IIerrflag == 1001)
		IIerrflag = 0;
	if (IIerrflag)
		return (0);
	
	ret = &IIr_sym;
	if (ret->type && ret->type != EOTUP)
		IIsyserr("bad type in IIn_get : %d", ret->type);
	
	/* read next type, length pair */
	if (IIrdpipe(P_NORM, &IIeinpipe, IIr_front, ret, 2) != 2)
		IIsyserr("IIrdpipe error in IIn_get");

	if (ret->type == EXIT)
		return (0);

	return (1);
}

/*
**  IIerrtest -- Test if an error occurred within a retrieve.
**
**	Returns:
**		1 -- if so
**		0 -- if not
**
**	Called By:
**		USER -- used to skip over C_CODE in a retrieve {}
**			when an error ocurred in getting the tuple.
**			A call to this routine is generated by equel,
**			because IIerrflag should not nedd to be vi-
**			sible from inside a users program.
**
*/

IIerrtest()
{
	return (IIerrflag ? 1 : 0);
}
