|environment(reference_placement;
	verbatim on,
	ref_ieee_begin,
	ref_ieee_end,
	ref_ieee_init,

	ref_ieee_other,
	ref_ieee_journal,
	ref_ieee_book,
	ref_ieee_article,
	ref_ieee_report,
	ref_ieee_tm,

	reference placement;)
	|comment<summary: reference_placement (produce references here)>

|environment(ref_ieee_begin;
	divert.input on reference_begin_definition,
	blank.lines, incr reference_counter,
	indent 0.3i, indent.line -0.3i,
	text "[", string reference_mark, text "]",
	horizontal.motion "|0.3i", concatenate,
	if else macro_argument_eq(1, 0),
		macro reference_other_definition,
	if else,
	 if else macro_argument_eq(1, 1),
		 macro reference_journal_definition,
	 if else,
	  if else macro_argument_eq(1, 2),
		  macro reference_book_definition,
	  if else,
	   if else macro_argument_eq(1, 3),
		   macro reference_article_definition,
	   if else,
	    if else macro_argument_eq(1, 4),
		    macro reference_report_definition,
	    if else,
	     if else macro_argument_eq(1, 5),
		     macro reference_tm_definition,
	     if else,
		      error "Bad argument passed to reference_begin_definition",
	new.line;)

|environment(ref_ieee_end;
	divert.input on reference_end_definition,
	clear string reference_author reference_book reference_location
	reference_date reference_editor reference_government
	reference_institution reference_journal reference_keyword reference_tm
	reference_number reference_other reference_page reference_report
	reference_title reference_volume,
	clear reference_authors reference_others reference_pages reference_titles;)

|environment(ref_ieee_init;
	new.page, blank.lines 4, center on, font.size +1, font bold,
	text "REFERENCES", blank.lines 4,
	macro reference_end_definition,
	blank.lines;)

|environment(ref_ieee_other;
	divert.input on reference_other_definition,
	if begin not_null_string(reference_author),
		string reference_author, text ",",
	if end,
	set punctation_string ".",
	if not_null_string(reference_other),
		set string punctation_string ",",
	if begin not_null_string(reference_title),
		text "\& ", temporary.font italics, string reference_title,
		temporary.font, string punctation_string,
	if end,
	if begin not_null_string(reference_other),
		text "\& ", string reference_other,
	if end,
	if begin not_null_string(reference_date),
		text "\& (", string reference_date, text ").",
	if end,
	new.line;)

|environment(ref_ieee_journal;
	divert.input on reference_journal_definition,
	string reference_author, text ",",
	if begin not_null_string(reference_title),
		string open_double_quote, string reference_title, text ",",
		string close_double_quote,
	if end,
	clear string punctation_string,
	if null_string(reference_volume),
		set string punctation_string ",",
	text "\& ", temporary.font italics, string reference_journal,
	temporary.font, string punctation_string,
	if begin not_null_string(reference_volume),
		temporary.font bold, string reference_volume,
		temporary.font,
	if end,
	if begin not_null_string(reference_number),
		string punctation_string,
		text "(", string reference_number, text ")",
	if end,
	if begin not_null_string(reference_page),
		if else begin gt(reference_pages, 0),
			text "\& pp. ",
		if end,
		if else begin,
			text "\& p. ",
		if end,
		string reference_page,
	if end,
	if not_null_string(reference_institution),
		if begin null_string(reference_report),
			text "\& ", string reference_institution, text ",",
		if end,
	text "\& (", string reference_date, text ").",
	if not_null_string(reference_other),
		string reference_other,
	new.line;)

|environment(ref_ieee_book;
	divert.input on reference_book_definition,
	string reference_author, text ", ",
	temporary.font italics, string reference_title, temporary.font, text ",",
	if begin not_null_string(reference_volume),
		string reference_volume, text ",",
	if end,
	clear string punctation_string,
	if not_null_string(reference_location),
		set string punctation_string ",",
	text "\& ", string reference_institution, string punctation_string,
	if begin not_null_string(reference_location),
		string reference_location,
	if end,
	text "\& (", string reference_date, text ").",
	if begin not_null_string(reference_government),
		text "\& Gov't. ordering no. ", string reference_government,
	if end,
	if not_null_string(reference_other),
		string reference_other,
	new.line;)

|environment(ref_ieee_article;
	divert.input on reference_article_definition,
	string reference_author, text ", ",
	string open_double_quote, string reference_title, text ",",
	string close_double_quote,
	if begin not_null_string(reference_page),
		if else begin gt(reference_pages, 0),
			text "\& pp. ",
		if end,
		if else begin,
			text "\& p. ",
		if end,
		string reference_page,
	if end,
	text "\& in ", temporary.font italics, string reference_book,
	temporary.font, text ",",
	if begin not_null_string(reference_editor),
		text "\& ed. ", string reference_editor, text ",",
	if end,
	clear string punctation_string,
	if not_null_string(reference_location),
		set string punctation_string ",",
	if begin not_null_string(reference_institution),
		text "\& ", string reference_institution, string punctation_string,
	if end,
	if begin not_null_string(reference_location),
		text "\& ", string reference_location,
	if end,
	text "\& (", string reference_date, text ").",
	if not_null_string(reference_other),
		string reference_other,
	new.line;)

|environment(ref_ieee_report;
	divert.input on reference_report_definition,
	string reference_author, text ", ",
	string open_double_quote, string reference_title, text ",",
	string close_double_quote,
	clear string punctation_string,
	if not_null_string(reference_institution),
		set string punctation_string ",",
	if not_null_string(reference_location),
		set string punctation_string ",",
	string reference_report, string reference_government,
	string punctation_string,
	if begin not_null_string(reference_institution),
		clear string punctation_string,
		if not_null_string(reference_location),
			set string punctation_string ",",
		string reference_institution, string punctation_string,
	if end,
	if begin not_null_string(reference_location),
		string reference_location,
	if end,
	text "\& (", string reference_date, text ").",
	if not_null_string(reference_other),
		string reference_other,
	new.line;)

|environment(ref_ieee_tm;
	divert.input on reference_tm_definition,
	string reference_author, text ", ",
	temporary.font italics, string reference_title,
	temporary.font, text ", ",
	string reference_tm, text ".",
	new.line;)
