      LOGICAL FUNCTION D8XTRD(E,NX,M,MMAX,KMAX,LOGN,BETA,GAMMA,
     1                        DELTA,F,POW,LDONE,ILDONE,KOPTO)
C
C  RETURN LDONE = THE LEVEL WHERE CONVERGENCE IS EXPECTED.
C
C  IF M=KOPTO+1, RETURN ILDONE=LDONE.
C  IF M.GT.KOPTO+1, DO NOT LET LDONE.GT.ILDONE+1 HAPPEN IN THE FIRST
C  KOPTO COLUMNS.
C
C  D8XTRD = .TRUE. IF WILL NOT CONVERGE IN THIS LOZENGE.
C  D8XTRD = .FALSE. IF WILL CONVERGE.
C
      DOUBLE PRECISION LOGN(MMAX),BETA,GAMMA,DELTA
      REAL E(NX,KMAX),F(KMAX),POW(KMAX)
C
      DOUBLE PRECISION TEMP
C
C ... INITIALLY, FLAG NOT CONVERGENT.
C
      D8XTRD=.TRUE.
      LDONE=0
C
      LMAX=MMAX
      IF (M.GT.KOPTO+1) LMAX=MIN0(ILDONE+1,MMAX)
      MP1=M+1
      IF (MP1.GT.LMAX) GO TO 60
C
      DO 50 L=MP1,LMAX
C
C ...... IF M.LE.KOPTO+1, CHECK FOR CONVERGENCE AT LEVEL L ONLY IF NOT
C ...... ALREADY ACHIEVED. OTHERWISE, CHECK AT L IF NOT ALREADY DONE
C ...... OR L=LMAX=ILDONE+1.
C
         IF (LDONE.GT.0.AND.(L.LT.LMAX.OR.M.LE.KOPTO+1)) GO TO 50
C
C ...... LDONEO DETERMINES IF WILL CONVERGE IN THE FIRST KOPTO
C ...... COLUMNS.
C
         LDONEO=L
         JHI=MIN0(M-1,KMAX)
C
C ...... COMPUTE THE FACTORS NEEDED TO CHECK FOR CONVERGENCE.
C
         DO 20 J=1,JHI
C
            MMA=M
            LMA=L
            TEMP=0.0E0
C
            DO 10 I=1,J
C
               LMA=LMA-1
               MMA=MMA-1
 10            TEMP=TEMP+(LOGN(MMA)-LOGN(LMA))
C
 20         F(J)=POW(J)*GAMMA*TEMP
C
C ...... SEE IF THE I-TH VARIABLE WILL CONVERGE AT M=L.
C
         DO 40 I=1,NX
C
C ......... CHECK EACH COLUMN FOR CONVERGENCE.
C
            DO 30 J=1,JHI
C
               JSAVE=J
C
               IF (E(I,J).GE.F(J)) GO TO 40
C
 30            CONTINUE
C
C ......... NO CONVERGENCE HERE.
C
            GO TO 50
C
C ......... IF WILL NOT CONVERGE IN THE FIRST KOPTO COLUMNS,
C ......... FLAG LDONEO.
C
 40         IF (JSAVE.GT.KOPTO) LDONEO=0
C
C ...... HAVE CONVERGENCE HERE.
C
         IF (LDONE.EQ.0) LDONE=L
C
 50      CONTINUE
C
 60   IF (LDONE.EQ.0.OR.LDONEO.EQ.0) GO TO 70
C
      IF (M.EQ.KOPTO+1) ILDONE=LDONE
C
      D8XTRD=.FALSE.
C
 70   RETURN
C
      END
