#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

/* stuff for faces */
#define ICONSIZE 48
#define ICONBYTES (ICONSIZE*(ICONSIZE/8))
#define ICONROOT "/n/face/"
#define UNKNOWNMACH "misc."
#define UNKNOWNUSER "unknown"
#define RESOLUTION "/48x48x1"
short blankface[]={
#ifdef	LITTLEENDIAN
	0x0000,0x1FA0,0x0000, 0x0000,0x7FFC,0x0000,
	0x0000,0xFEFF,0x0000, 0x0001,0xBFBF,0xC000,
	0x0001,0xEFFA,0xE000, 0x0002,0x00FF,0xF800,
	0x0002,0x007F,0xFF80, 0x0000,0x001F,0x7E00,
	0x000C,0x001F,0xFFC0, 0x0000,0x0015,0xFFC0,
	0x0030,0x001F,0xFFF0, 0x0070,0x000F,0xFEB0,
	0x00C0,0x0007,0xFFF8, 0x00E0,0x0007,0xFFE8,
	0x01E0,0x0003,0xFFF8, 0x03C0,0x0001,0xFFF8,
	0x03E0,0x0001,0xFFF8, 0x07D0,0x0000,0xFFF0,
	0x0FF0,0x0000,0x3FF8, 0x0FE0,0x0000,0x7FF8,
	0x1FF0,0x0000,0x7FF8, 0x1FF0,0x0000,0x7FF8,
	0x1FF0,0x0000,0x7FF8, 0x1FD0,0x0000,0x7FF0,
	0x0FE0,0x0000,0xFFF0, 0x1FA0,0x0000,0x3FF0,
	0x0320,0x0000,0x1FE0, 0x0B80,0x0000,0x1F80,
	0x0180,0x0000,0x1780, 0x0080,0x0000,0x1F00,
	0x0000,0x0000,0x1F00, 0x0180,0x0000,0x0E00,
	0x0380,0x0000,0x1E00, 0x0180,0x0000,0x0FC0,
	0x0080,0x0000,0x0F80, 0x01C0,0x0000,0x0F80,
	0x00C0,0x0000,0x3F80, 0x0040,0x0000,0x7F00,
	0x0060,0x0000,0xCE00, 0x0004,0x0000,0x6000,
	0x0000,0x0001,0xF800, 0x0002,0x0001,0xA000,
	0x0000,0x0003,0xC000, 0x0002,0x000F,0x4000,
	0x0000,0x804B,0xC000, 0x0002,0xBBFE,0x8000,
	0x0000,0x8FFB,0xC000, 0x0001,0x7ABF,0xC000,
#else
	0x0000,0xA01F,0x0000, 0x0000,0xFC7F,0x0000,
	0x0000,0xFFFE,0x0000, 0x0100,0xBFBF,0x00C0,
	0x0100,0xFAEF,0x00E0, 0x0200,0xFF00,0x00F8,
	0x0200,0x7F00,0x80FF, 0x0000,0x1F00,0x007E,
	0x0C00,0x1F00,0xC0FF, 0x0000,0x1500,0xC0FF,
	0x3000,0x1F00,0xF0FF, 0x7000,0x0F00,0xB0FE,
	0xC000,0x0700,0xF8FF, 0xE000,0x0700,0xE8FF,
	0xE001,0x0300,0xF8FF, 0xC003,0x0100,0xF8FF,
	0xE003,0x0100,0xF8FF, 0xD007,0x0000,0xF0FF,
	0xF00F,0x0000,0xF83F, 0xE00F,0x0000,0xF87F,
	0xF01F,0x0000,0xF87F, 0xF01F,0x0000,0xF87F,
	0xF01F,0x0000,0xF87F, 0xD01F,0x0000,0xF07F,
	0xE00F,0x0000,0xF0FF, 0xA01F,0x0000,0xF03F,
	0x2003,0x0000,0xE01F, 0x800B,0x0000,0x801F,
	0x8001,0x0000,0x8017, 0x8000,0x0000,0x001F,
	0x0000,0x0000,0x001F, 0x8001,0x0000,0x000E,
	0x8003,0x0000,0x001E, 0x8001,0x0000,0xC00F,
	0x8000,0x0000,0x800F, 0xC001,0x0000,0x800F,
	0xC000,0x0000,0x803F, 0x4000,0x0000,0x007F,
	0x6000,0x0000,0x00CE, 0x0400,0x0000,0x0060,
	0x0000,0x0100,0x00F8, 0x0200,0x0100,0x00A0,
	0x0000,0x0300,0x00C0, 0x0200,0x0F00,0x0040,
	0x0000,0x4B80,0x00C0, 0x0200,0xFEBB,0x0080,
	0x0000,0xFB8F,0x00C0, 0x0100,0xBF7A,0x00C0,
#endif
};
/* imported */
extern char *thissys;
extern int sendjerq();

/*
 *	send an icon to the jerq 
 */
static int
HexToDec(Hex)
int Hex;
{
	if ((Hex>='0') && (Hex<='9')) return(Hex-'0');
	if ((Hex>='A') && (Hex<='F')) return(10+Hex-'A');
	if ((Hex>='a') && (Hex<='f')) return(10+Hex-'a');
	return(-1);
}

static char *
greypath(machine, user)
	char *machine, *user;
{
	static char filename[128];
	if (*machine == '\0')
		machine = thissys;
	strcpy(filename, ICONROOT);
	strncat(filename, machine, DIRSIZ);
	strcat(filename, "/");
	strcat(filename, user);
	strcat(filename, "/48x48x2");
	return filename;
}

static char *
iconpath(machine, user)
	char *machine, *user;
{
	static char filename[128];

	if (*machine == '\0')
		machine = thissys;
	strcpy(filename, ICONROOT);
	strncat(filename, machine, DIRSIZ);
	strcat(filename, "/");
	strcat(filename, user);
	strcat(filename, RESOLUTION);
	return filename;
}

FILE*
domainopen(machine, user)
	char *machine, *user;
{
	FILE *icon = NULL;
	char *strchr();
	char *m;
	extern greyicon;

	for(m = machine;;m++) {
		if(greyicon && (icon = fopen(greypath(m, user), "r")) != NULL)
			break;
		if((icon = fopen(iconpath(m, user), "r")) != NULL)
			break;
		if((m = strchr(m, '.')) == NULL) {
			if((m = strchr(machine, '.')) != NULL) {
				/* if all else fails, try stripping domain */
				*m = '\0';
				icon = fopen(iconpath(machine, user), "r");
				*m = '.';
			}
			break;
		}
	}

	return icon;
}

extern int
sendicon(machine, user)
	char *machine, *user;
{
	FILE *icon;
	struct stat statbuf;
	char *iconp;
	char buf[6], IconBuf[2*ICONBYTES+8];
	int i=0,val,c=0;
	extern debug;

	if ((icon = domainopen(machine, user)) == NULL &&
	    (icon = fopen(iconpath(UNKNOWNMACH, user), "r")) == NULL &&
	    (icon = domainopen(machine, UNKNOWNUSER)) == NULL &&
	    (icon = fopen(iconpath(UNKNOWNMACH, UNKNOWNUSER), "r")) == NULL)
		iconp=(char *)blankface;
	else{
		iconp=IconBuf;
		for (i=0; i<sizeof(IconBuf) && c!=EOF;) {
			while ((c=getc(icon))!='x' && c!=EOF)
					;
			while ((val = HexToDec(getc(icon))) != -1) {
				val = (val<<4) | HexToDec(c=getc(icon));
				IconBuf[i++] = val;
			}
		}
		fclose(icon);
	}
	if (debug) fprintf(stderr,"sending %d\n",i);
	if (i != 2*ICONBYTES)
		i = ICONBYTES;
	sendjerq((i == ICONBYTES) ? 'I' : 'G', iconp, i);
}
