.so ../ADM/mac
.XX 33 549 "The UNIX Circuit Design System"
.TL
The
.UX
Circuit Design System
.AU
A. G. Hume
.AU
T. J. Killian
.AB
.SM UCDS
is a system for the design and prototyping of digital systems.
At the front end
it provides hierarchical schematic entry,
.SM PAL
design and board layout; at the back end it
produces data for various manufacturing technologies, in particular
wire-wrap and multiwire.
.AE
.NH
Introduction.
.LP
A design has a logical part and a physical part.
The logical part consists of circuit schematics, generally
supplemented by 
.SM PAL
equations.  The physical part includes board layout and routing.
.LP
A circuit contains
.I chips
each identified by
.I name
(which is arbitrary, and of mnemonic value to the designer) and
.I type
(which is generic, e.g.,
.CW 74LS74 ")."
Schematics can be hierarchical; what appears syntactically as
a chip is in fact an instance of a
.I macro ,
(i.e., another drawing) if the file
.I "type\c"
.CW ".w"
.R
exists.
Real chips have
.I pins ,
each identified by a
.I "pin name"
and
.I "pin number" ","
and a
.I "package type" "."
Pin names and their mapping onto pin numbers are a property of
the chip type; the mapping from pin numbers to physical coordinates
is a property of the package type.
.LP
Pins are connected by
.I nets ","
which have unique
.I "net names"
(assigned by the drawing package if
omitted by the user).  It is an error for a pin to
be connected to more than one net.
Nets such as
.CW VCC
and
.CW GND
generally need different routing algorithms from ordinary nets;
these are called
.I "special-signal nets"
in cases where the distinction is important.
.LP
A
.I board
is a physical mounting for packages.  It is mostly characterized by its
.I "pin holes"
(available for package insertion) and
.I "special-signal pins"
(connected to special-signal nets).  An
.I
.SM I/O
.R
.I connector ","
where signals enter or leave the board, is simply a special case
of a chip.
.NH
Methodology.
.LP
These are the conventional steps in a design.  Many are necessary simply to
maintain consistency between ``source'' and ``object'' files.
We will collect all of this into a
.CW mkfile
in a later section.
.nr P 0 1
.IP (\n+P)
The interactive program
.I jraw
is used to construct schematics, kept in files
whose names end with
.CW ".j" "."
The semantics of a circuit diagram (its
.CW ".w"
file) are derived from the
.CW ".j"
file by running
.I "jraw -w" "."
.IP (\n+P)
Any editor may be used to create files in
.CW lde
format for logic that is to be implemented with
.SM PAL "'s."
These filenames end with
.CW ".e" "."
Pin information resides in a corresponding
.CW ".p"
file, generated by
.I "lde -W" "."
.IP (\n+P)
A
.CW ".pins"
file, that matches pin names with numbers for each chip type, must
be constructed.  Most pin information comes from standard libraries,
but the user must generally supply some of it, usually for
.SM I/O
connectors (\c
.CW io.pins ")"
or non-standard chips (\c
.CW my.pins ")."
.I Mkpins
reads
.CW ".w"
files,
.CW ".p"
files, and pin libraries to produce the
.CW ".pins"
file.
.IP (\n+P)
.I "Cdmglob -f -v"
reads the
.CW ".w"
and
.CW ".pins"
files to produce a
.CW ".wx"
file, in which all macros are expanded, and nets are described in terms of
pin numbers.
.IP (\n+P)
At this point one may do static circuit checks with
.I smoke "."
.IP (\n+P)
Most files discussed so far have to do with the logical part of the design, and,
except for
.CW ".e"
files, are in
.SM CDL
(Circuit Design Language).  The remainder of the physical design files are in
.SM FIZZ
format.  So, at this point, one uses
.I "fizz cvt"
to turn the
.CW ".wx"
file into a
.CW ".fx"
file.
.IP (\n+P)
As with the
.CW ".pins"
file, one creates a
.CW ".pkg"
file with geometric descriptions of each package type.
.IP (\n+P)
A geometric description of the board (\c
.CW ".brd"
file) is made.
.IP (\n+P)
Chip positioning information (\c
.CW ".pos"
file) is generated.  This is usually done interactively with
.I "fizz place" "."
.IP (\n+P)
The wrap list (\c
.CW ".wr"
file) is now made, and one can physically wrap the board.
.IP (\n+P)
To make changes, one generates a new
.CW ".wr"
file;
.I rework
then compares the new and old wrap files and generates separate lists
for unwrapping and rewrapping.
.NH
Using
.BI jraw .
.LP
.NH
Signal Bundles and Macros.
.LP
Consider this buffer between two 8-bit busses:
.PS <fig1.pic
It illustrates several
.I jraw
conventions.  The
.I chip
is indicated by a box; its
.I name
is
.CW buffer ;
its
.I type
is
.CW 74F244 .
These are simply unattached text strings that appear stacked inside the
box.
.I "Pin names"
(e.g.,
.CW D0 )
are strings that appear on the inside edge of the box.
.I Nets
are lines that end on a pin.
.I "Net names"
are strings that are placed on nets.  A trailing
.CW "-"
conventionally indicates an active-low signal.
.LP
Even this trivial example involves repeated patterns.
A much more succint equivalent is:
.PS <fig2.pic
The
.I generator
.CW "x<0:7>"
expands into the ordered list
.CW x0 ,
.CW x1 ,...
.CW x7 .
The
.I pattern
.CW "D?\&"
matches two-character pin names that begin with
.CW D .
(The space of possible names comes from the
.CW .pins
file entry for the chip type.)
The names that match the pattern are
.I "sorted alphabetically"
and put into correspondance with the nets.
.LP
If connected sets of nets and pins do not have the same cardinality,
the smaller set is reused until the larger is exhausted.  Thus in the
example, the
.CW drive-
net gets connected to both
.CW OE0-
and
.CW OE1- ,
as desired.
.LP
Frequently one has a group of chips that will be used or replicated as
a unit.  In such a case it makes sense to define a
.I macro
that may be instantiated as required.  A macro lives in its own file.
Here is an example,
.CW opm.j :
.PS <opm.pic
The dotted box (produced by selecting
.CW macro
in
.I jraw ")"
identifies the circuit as a macro.  Strings outside of this box
(conventionally in upper case) are ``pin names'' visible to the
outside world.  Most names inside the box will be made local to
each instantiation.  Net names beginning with
.CW "/"
are ``globals,'' i.e., they represent the same signal throughout
the design.
.CW "/VCC"
and
.CW "/GND"
are the most common global signals.
.LP
Now we use generators to make several instances of
.CW opm.j :
.PS <opmcall.pic
Sixteen copies of the
.CW opm
circuit are made.  The pattern
.CW "D?\&"
is at a lower, i.e., ``faster running,'' level than
.CW "opm<00:15>" ,
with the effect that all the
.CW D0 "'s"
are connected to
.CW "bd0" ,
all the
.CW D1 "'s"
are connected to
.CW "bd1" ,
etc; similarly, all the
.CW A0 "'s"
are connected to
.CW ba0 .
On the other hand, all the
.CW "CS-" "'s"
are separate:
.CW "opm00/CS-"
(the instance of
.CW CS-
in
.CW opm00 )
is connected to
.CW "ops00-" ,
.CW "opm01/CS-"
is connected to
.CW "ops01-" ,
etc.  The manual entries for
.I cdm
and
.I cdmglob
should be consulted for all the details.
.NH
A Toy Example.
.LP
In this section we present a complete example.  The design consists of
two
.SM I/O
connectors that route signals from a ribbon cable to a backplane.
Here is the schematic, followed by the
.CW ".w"
file:
.PS <toy.pic
.nr dP 2	\" delta point size for program
.nr dV 2p	\" delta vertical for programs
.P1
.so toy.w.l
.P2
.LP
The comments (introduced by
.CW % )
are coordinates from the
.CW .j
file that can be used later to annotate the drawing with pin numbers.
Otherwise the
.CW .w
file is mostly just a compendium of the text strings in the
.CW .j
file.
In order to proceed further, we need a
.CW .pins
file:
.P1
.so toy.pins.l
.P2
.LP
It should be fairly obvious what is going on here.  Note the appearance of the
.I "package type"
on the
.CW .t
lines.
Now the
.CW .wx
file can be made:
.P1
.so toy.wx.l
.P2
.LP
This is basically a listing, for each chip, of net\ name\-pin\ number pairs.
Package types are copied through from the
.CW .pins
file for use by the physical design tools, and
the pin names are left as an aid to humans.
