#
/*
 *   KL/DL-11 driver
 *	UKC System changes which apply to this file:
 *	see changes.h
 *
 *	NEW_TTY
 */
#define NOZERO 0		/* Define if no echoing of break required */
#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"

/* base address */
#define	KLADDR	0177560	/* console */
#define	KLBASE	0176500	/* kl and dl11-a */
#define	DLBASE	0175610	/* dl-e */
#ifndef UKC1134
#define	NKL11	16
#endif
#ifdef UKC1134
#define NKL11	2
#endif
#define	NDL11	0
#define DSRDY	02
#define	IENABLE	0100
#define	RDRENB	01

struct	tty kl11[NKL11+NDL11];

struct klregs {
	int klrcsr;
	int klrbuf;
	int kltcsr;
	int kltbuf;
}

klopen(dev, flag)
{
	register char *addr;
	register struct tty *tp;

	if(dev.d_minor >= NKL11+NDL11) {
		u.u_error = ENXIO;
		return;
	}
	tp = &kl11[dev.d_minor];
	/*
	 * set up minor 0 to address KLADDR
	 * set up minor 1 thru NKL11-1 to address from KLBASE
	 * set up minor NKL11 on to address from DLBASE
	 */
	addr = KLADDR + 8*dev.d_minor;
	if(dev.d_minor)
		addr =+ KLBASE-KLADDR-8;
#ifdef DL11
	if(dev.d_minor >= NKL11)
		addr =+ DLBASE-KLBASE-8*NKL11+8;
#endif
	tp->t_addr = addr;
	tp->t_dev = dev;
	if ((tp->t_state&ISOPEN) == 0) {
		tp->t_state = ISOPEN|CARR_ON;
		tp->t_flags = XTABS|ECHO|CRMOD|INDCTL;
		tp->t_erase = CERASE;
		tp->t_kill = CKILL;
	}
	addr->klrcsr =| IENABLE|DSRDY|RDRENB;
	addr->kltcsr =| IENABLE;
	ttyopen( tp);
}

klclose(dev)
{
	register struct tty *tp;

	tp = &kl11[dev.d_minor];
	wflushtty(tp);
	tp->t_state = 0;
}

klread(dev)
{
	ttread(&kl11[dev.d_minor]);
}

klwrite(dev)
{
	ttwrite(&kl11[dev.d_minor]);
}

klxint(dev)
{
	register struct tty *tp;

	tp = &kl11[dev.d_minor];
	ttstart(tp);
	if (tp->t_outq.c_cc == 0 || tp->t_outq.c_cc == TTLOWAT)
		wakeup(&tp->t_outq);
}

klrint(dev)
{
	register int c, *addr;
	register struct tty *tp;

	tp = &kl11[dev.d_minor];
	addr = tp->t_addr;
	c = addr->klrbuf;
	addr->klrcsr =| RDRENB;
#ifndef NOZERO
	if ((c&0177)==0)
		addr->kltbuf = c;	/* hardware botch */
#endif
	if ( (tp->t_flags &ALL8BITS) == 0 )
	{
		c =& 0177;
		if(c == 0) return;
	}
	ttyinput(c, tp);
}

klsgtty(dev)
{
	ttystty(&kl11[dev.d_minor]);
}
